/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.utils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1530;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_270;
import net.minecraft.class_2960;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_6025;
import net.minecraft.class_7923;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.config.ServerConfig;
import net.spell_engine.internals.Beam;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.casting.SpellCasterClient;
import net.spell_engine.utils.VectorHelper;
import org.jetbrains.annotations.Nullable;

public class TargetHelper {
    private static final boolean[][] TABLE_OF_ULTIMATE_JUSTICE = new boolean[][]{{false, true, true, true, true}, {false, false, false, true, true}, {true, true, true, false, true}, {true, true, false, false, true}};

    public static Relation getRelation(class_1309 attacker, class_1297 target) {
        class_6025 tameable;
        class_1309 owner;
        if (attacker == target) {
            return Relation.FRIENDLY;
        }
        class_270 casterTeam = attacker.method_5781();
        class_270 targetTeam = target.method_5781();
        if (target instanceof class_6025 && (owner = (tameable = (class_6025)target).method_35057()) != null) {
            return TargetHelper.getRelation(attacker, (class_1297)owner);
        }
        if (target instanceof class_1530) {
            return Relation.NEUTRAL;
        }
        ServerConfig config = SpellEngineMod.config;
        if (casterTeam == null || targetTeam == null) {
            class_2960 id = class_7923.field_41177.method_10221((Object)target.method_5864());
            Relation mappedRelation = config.player_relations.get(id.toString());
            if (mappedRelation != null) {
                return mappedRelation;
            }
            if (target instanceof class_1296) {
                return Relation.coalesce(config.player_relation_to_passives, Relation.HOSTILE);
            }
            if (target instanceof class_1588) {
                return Relation.coalesce(config.player_relation_to_hostiles, Relation.HOSTILE);
            }
            return Relation.coalesce(config.player_relation_to_other, Relation.HOSTILE);
        }
        return attacker.method_5722(target) ? Relation.FRIENDLY : Relation.HOSTILE;
    }

    public static boolean actionAllowed(TargetingMode targetingMode, Intent intent, class_1309 attacker, class_1297 target) {
        Relation relation = TargetHelper.getRelation(attacker, target);
        int row = 0;
        if (intent == Intent.HELPFUL) {
            row += 2;
        }
        if (targetingMode == TargetingMode.AREA) {
            ++row;
        }
        int column = 0;
        switch (relation) {
            case FRIENDLY: {
                column = 0;
                break;
            }
            case SEMI_FRIENDLY: {
                column = 1;
                break;
            }
            case NEUTRAL: {
                column = 2;
                break;
            }
            case HOSTILE: {
                column = 3;
                break;
            }
            case MIXED: {
                column = 4;
            }
        }
        return TABLE_OF_ULTIMATE_JUSTICE[row][column];
    }

    public static boolean allowedToHurt(class_1297 e1, class_1297 e2) {
        class_270 abstractTeam = e1.method_5781();
        class_270 abstractTeam2 = e2.method_5781();
        if (abstractTeam == null) {
            return true;
        }
        return !abstractTeam.method_1206(abstractTeam2) || abstractTeam.method_1205();
    }

    public static class_1297 targetFromRaycast(class_1297 caster, float range, Predicate<class_1297> predicate) {
        class_238 searchAABB;
        class_243 look;
        class_243 end;
        class_243 start = caster.method_33571();
        class_3966 hitResult = class_1675.method_18075((class_1297)caster, (class_243)start, (class_243)(end = start.method_1019(look = caster.method_5828(1.0f).method_1029().method_1021((double)range))), (class_238)(searchAABB = caster.method_5829().method_1009((double)range, (double)range, (double)range)), target -> !target.method_7325() && target.method_5863() && predicate.test((class_1297)target), (double)(range * range));
        if (hitResult != null && (hitResult.method_17784() == null || TargetHelper.raycastObstacleFree(caster, start, hitResult.method_17784()))) {
            return hitResult.method_17782();
        }
        return null;
    }

    public static List<class_1297> targetsFromRaycast(class_1297 caster, float range, Predicate<class_1297> predicate) {
        class_243 start = caster.method_33571();
        class_243 look = caster.method_5828(1.0f).method_1029().method_1021((double)range);
        class_243 end = start.method_1019(look);
        class_238 searchAABB = caster.method_5829().method_1009((double)range, (double)range, (double)range);
        List<EntityHit> entitiesHit = TargetHelper.raycastMultiple(caster, start, end, searchAABB, target -> !target.method_7325() && target.method_5863() && predicate.test((class_1297)target), range * range);
        return entitiesHit.stream().filter(hit -> hit.position() == null || TargetHelper.raycastObstacleFree(caster, start, hit.position())).sorted(new Comparator<EntityHit>(){

            @Override
            public int compare(EntityHit hit1, EntityHit hit2) {
                if (hit1.squaredDistanceToSource == hit2.squaredDistanceToSource) {
                    return 0;
                }
                return hit1.squaredDistanceToSource < hit2.squaredDistanceToSource ? -1 : 1;
            }
        }).map(hit -> hit.entity).toList();
    }

    @Nullable
    private static List<EntityHit> raycastMultiple(class_1297 sourceEntity, class_243 min, class_243 max, class_238 searchBox, Predicate<class_1297> predicate, double squaredDistance) {
        class_1937 world = sourceEntity.method_37908();
        double e = squaredDistance;
        ArrayList<EntityHit> entities = new ArrayList<EntityHit>();
        class_243 vec3d = null;
        for (class_1297 entity : world.method_8333(sourceEntity, searchBox, predicate)) {
            class_243 hitPosition;
            double f;
            class_238 box2 = entity.method_5829().method_1014((double)entity.method_5871());
            Optional raycastResult = box2.method_992(min, max);
            if (box2.method_1006(min)) {
                if (!(e >= 0.0)) continue;
                vec3d = raycastResult.orElse(min);
                entities.add(new EntityHit(entity, vec3d, 0.0));
                e = 0.0;
                continue;
            }
            if (!raycastResult.isPresent() || !((f = min.method_1025(hitPosition = (class_243)raycastResult.get())) < e) && e != 0.0) continue;
            if (entity.method_5668() == sourceEntity.method_5668()) {
                if (e != 0.0) continue;
                vec3d = hitPosition;
                entities.add(new EntityHit(entity, vec3d, entity.method_5858(sourceEntity)));
                continue;
            }
            vec3d = hitPosition;
            entities.add(new EntityHit(entity, vec3d, entity.method_5858(sourceEntity)));
        }
        return entities;
    }

    public static List<class_1297> targetsFromArea(class_1297 caster, float range, Spell.Release.Target.Area area, @Nullable Predicate<class_1297> predicate) {
        class_243 origin = caster.method_33571();
        return TargetHelper.targetsFromArea(caster, origin, range, area, predicate);
    }

    public static List<class_1297> targetsFromArea(class_1297 centerEntity, class_243 origin, float range, Spell.Release.Target.Area area, @Nullable Predicate<class_1297> predicate) {
        float horizontal = range * area.horizontal_range_multiplier;
        float vertical = range * area.vertical_range_multiplier;
        class_238 box = centerEntity.method_5829().method_1009((double)(horizontal + 0.5f), (double)(vertical + 0.5f), (double)(horizontal + 0.5f));
        float squaredDistance = range * range;
        class_243 look = centerEntity.method_5720();
        float angle = area.angle_degrees / 2.0f;
        return centerEntity.method_37908().method_8333(centerEntity, box, target -> {
            class_243 targetCenter = target.method_19538().method_1031(0.0, (double)(target.method_17682() / 2.0f), 0.0);
            class_243 distanceVector = VectorHelper.distanceVector(origin, target.method_5829());
            return !target.method_7325() && target.method_5863() && (predicate == null || predicate.test((class_1297)target)) && targetCenter.method_1025(origin) <= (double)squaredDistance && (angle <= 0.0f || VectorHelper.angleBetween(look, targetCenter.method_1020(origin)) <= (double)angle || VectorHelper.angleBetween(look, distanceVector) <= (double)angle) && (TargetHelper.raycastObstacleFree(centerEntity, origin, targetCenter) || TargetHelper.raycastObstacleFree(centerEntity, origin, origin.method_1019(distanceVector)));
        });
    }

    public static boolean isInLineOfSight(class_1297 attacker, class_1297 target) {
        class_243 origin = attacker.method_33571();
        class_243 targetCenter = target.method_19538().method_1031(0.0, (double)(target.method_17682() / 2.0f), 0.0);
        class_243 distanceVector = VectorHelper.distanceVector(origin, target.method_5829());
        return TargetHelper.raycastObstacleFree(attacker, origin, targetCenter) || TargetHelper.raycastObstacleFree(attacker, origin, origin.method_1019(distanceVector));
    }

    private static boolean raycastObstacleFree(class_1297 entity, class_243 start, class_243 end) {
        class_3965 hit = entity.method_37908().method_17742(new class_3959(start, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, entity));
        return hit.method_17783() != class_239.class_240.field_1332;
    }

    public static boolean isTargetedByPlayer(class_1297 entity, class_1657 player) {
        if (entity.method_37908().field_9236 && player instanceof SpellCasterClient) {
            SpellCasterClient casterClient = (SpellCasterClient)player;
            return casterClient.getCurrentTargets().contains(entity);
        }
        return false;
    }

    public static Beam.Position castBeam(class_1309 caster, class_243 direction, float max) {
        class_243 start = SpellHelper.launchPoint(caster);
        class_243 end = start.method_1019(direction.method_1021((double)max));
        float length = max;
        boolean hitBlock = false;
        class_3965 hit = caster.method_37908().method_17742(new class_3959(start, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)caster));
        if (hit.method_17783() == class_239.class_240.field_1332) {
            hitBlock = true;
            end = hit.method_17784();
            length = (float)start.method_1022(hit.method_17784());
        }
        return new Beam.Position(start, end, length, hitBlock);
    }

    @Nullable
    public static class_243 findSolidBlockBelow(class_1309 entity, class_1937 world) {
        class_243 position = entity.method_19538();
        class_3965 hit = world.method_17742(new class_3959(position, position.method_1031(0.0, -20.0, 0.0), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)entity));
        if (hit.method_17783() == class_239.class_240.field_1332) {
            class_3965 blockHit = hit;
            return new class_243(position.method_10216(), (double)((float)blockHit.method_17777().method_10264() + 1.0f), position.method_10215());
        }
        return null;
    }

    public static enum Relation {
        FRIENDLY,
        SEMI_FRIENDLY,
        NEUTRAL,
        HOSTILE,
        MIXED;


        public static Relation coalesce(Relation value, Relation fallback) {
            if (value != null) {
                return value;
            }
            return fallback;
        }
    }

    public static enum Intent {
        HELPFUL,
        HARMFUL;

    }

    public static enum TargetingMode {
        DIRECT,
        AREA;

    }

    private record EntityHit(class_1297 entity, class_243 position, double squaredDistanceToSource) {
    }
}

