/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.util;

import ht.treechop.api.TreeData;
import ht.treechop.common.chop.ChopUtil;
import java.util.Objects;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

public class TreeCache {
    private final SingleBlockCache<TreeData> singleBlockCache = new SingleBlockCache();

    public void invalidate() {
        this.singleBlockCache.invalidate();
    }

    public TreeData getTree(class_1937 level, class_2338 pos) {
        TreeData tree = this.singleBlockCache.get((class_1922)level, pos);
        if (tree == null) {
            tree = ChopUtil.getTree(level, pos);
            this.singleBlockCache.put((class_1922)level, pos, tree);
        }
        return tree;
    }

    private static class SingleBlockCache<T> {
        private T value;
        private class_1922 level;
        private class_2680 blockState;
        private class_2338 pos;
        private class_2586 entity;

        private SingleBlockCache() {
        }

        public T get(class_1922 level, class_2338 pos) {
            if (level == this.level && pos.equals((Object)this.pos) && Objects.equals(level.method_8320(pos), this.blockState) && Objects.equals(level.method_8321(pos), this.entity)) {
                return this.value;
            }
            return null;
        }

        public void put(class_1922 level, class_2338 pos, T value) {
            this.value = value;
            this.level = level;
            this.pos = pos;
            this.blockState = level.method_8320(pos);
            this.entity = level.method_8321(pos);
        }

        public void invalidate() {
            this.level = null;
            this.value = null;
            this.blockState = class_2246.field_10124.method_9564();
            this.entity = null;
        }
    }
}

