/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.block;

import com.b1n_ry.yigd.Yigd;
import com.b1n_ry.yigd.block.entity.GraveBlockEntity;
import com.b1n_ry.yigd.components.GraveComponent;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.data.DeathInfoManager;
import com.b1n_ry.yigd.data.GraveStatus;
import com.b1n_ry.yigd.data.TimePoint;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5558;
import net.minecraft.class_6760;
import org.jetbrains.annotations.Nullable;

public class GraveBlock
extends class_2237
implements class_2343,
class_3737 {
    private static class_265 SHAPE_EAST;
    private static class_265 SHAPE_WEST;
    private static class_265 SHAPE_SOUTH;
    private static class_265 SHAPE_NORTH;

    public GraveBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11043)).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{class_2741.field_12481, class_2741.field_12508});
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof GraveBlockEntity) {
            GraveBlockEntity grave = (GraveBlockEntity)class_25862;
            if (itemStack.method_7938() && grave.getComponent() == null) {
                grave.setGraveText(itemStack.method_7964());
                grave.method_5431();
            }
        }
        super.method_9567(world, pos, state, placer, itemStack);
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2350 dir = ctx.method_8042().method_10153();
        class_2680 state = this.method_9564();
        class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
        return (class_2680)((class_2680)state.method_11657((class_2769)class_2741.field_12481, (Comparable)dir)).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
            world.method_8405().method_39363(class_6760.method_39410((Object)class_3612.field_15910, (class_2338)pos));
        }
        return direction.method_10166().method_10179() ? state : super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)class_2741.field_12508) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_2464 method_9604(class_2680 state) {
        YigdConfig.GraveRendering config = YigdConfig.getConfig().graveRendering;
        return config.useCustomFeatureRenderer ? class_2464.field_11455 : class_2464.field_11458;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new GraveBlockEntity(pos, state);
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)class_2741.field_12481);
        return switch (direction) {
            case class_2350.field_11034 -> SHAPE_EAST;
            case class_2350.field_11039 -> SHAPE_WEST;
            case class_2350.field_11035 -> SHAPE_SOUTH;
            default -> SHAPE_NORTH;
        };
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return GraveBlock.method_31618(type, Yigd.GRAVE_BLOCK_ENTITY, GraveBlockEntity::tick);
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 class_25862;
        YigdConfig config = YigdConfig.getConfig();
        if (!world.field_9236 && (class_25862 = world.method_8321(pos)) instanceof GraveBlockEntity) {
            GraveBlockEntity grave = (GraveBlockEntity)class_25862;
            if (config.graveConfig.retrieveMethods.onClick) {
                GraveComponent graveComponent = grave.getComponent();
                if (graveComponent == null) {
                    Optional<GraveComponent> component;
                    UUID graveId = grave.getGraveId();
                    if (graveId != null && (component = DeathInfoManager.INSTANCE.getGrave(graveId)).isPresent()) {
                        graveComponent = component.get();
                    }
                    if (graveComponent == null) {
                        return this.interactWithNonPlayerGrave(grave, state, world, pos, player, hand, hit);
                    }
                }
                if (config.graveConfig.persistentGraves.enabled && graveComponent.getStatus() == GraveStatus.CLAIMED && hand == class_1268.field_5808) {
                    class_5250 message = graveComponent.getDeathMessage().getDeathMessage();
                    TimePoint creationTime = graveComponent.getCreationTime();
                    if (config.graveConfig.persistentGraves.showDeathDay) {
                        message.method_10852((class_2561)class_2561.method_43469((String)"text.yigd.message.on_day", (Object[])new Object[]{creationTime.getDay()}));
                    }
                    if (config.graveConfig.persistentGraves.showDeathIrlTime) {
                        message.method_10852((class_2561)class_2561.method_43469((String)"text.yigd.message.irl_time", (Object[])new Object[]{creationTime.getMonthName(), creationTime.getDate(), creationTime.getYear(), creationTime.getHour(config.graveConfig.persistentGraves.useAmPm), creationTime.getMinute(), creationTime.getTimePostfix(config.graveConfig.persistentGraves.useAmPm)}));
                    }
                    player.method_43496((class_2561)message);
                    return class_1269.field_5812;
                }
                return graveComponent.claim((class_3222)player, (class_3218)world, grave.getPreviousState(), pos, player.method_5998(hand));
            }
        }
        return class_1269.field_5814;
    }

    private class_1269 interactWithNonPlayerGrave(GraveBlockEntity grave, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 ignoredHit) {
        class_2520 skullOwnerNbt;
        if (player.method_5715()) {
            return class_1269.field_5814;
        }
        class_1799 stack = player.method_5998(hand);
        class_2487 nbt = stack.method_7969();
        if (stack.method_31574(class_1802.field_8575) && nbt != null && (skullOwnerNbt = nbt.method_10580("SkullOwner")) != null) {
            byte nbtType = skullOwnerNbt.method_10711();
            GameProfile profile = switch (nbtType) {
                case 8 -> new GameProfile(null, skullOwnerNbt.method_10714());
                case 10 -> class_2512.method_10683((class_2487)((class_2487)skullOwnerNbt));
                default -> null;
            };
            grave.setGraveSkull(profile);
            grave.method_5431();
            world.method_8413(pos, state, state, 3);
            if (!player.method_7337()) {
                stack.method_7934(1);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public void method_9591(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
        if (!world.field_9236 && entity instanceof class_3222) {
            class_2586 class_25862;
            class_3222 player = (class_3222)entity;
            YigdConfig.GraveConfig graveConfig = YigdConfig.getConfig().graveConfig;
            if ((graveConfig.retrieveMethods.onStand || graveConfig.retrieveMethods.onSneak && player.method_5715()) && (class_25862 = world.method_8321(pos)) instanceof GraveBlockEntity) {
                Optional<GraveComponent> component;
                UUID graveId;
                GraveBlockEntity grave = (GraveBlockEntity)class_25862;
                GraveComponent graveComponent = grave.getComponent();
                if (graveComponent == null && (graveId = grave.getGraveId()) != null && (component = DeathInfoManager.INSTANCE.getGrave(graveId)).isPresent()) {
                    graveComponent = component.get();
                }
                if (graveComponent != null && graveComponent.getStatus() != GraveStatus.CLAIMED) {
                    graveComponent.claim(player, (class_3218)world, grave.getPreviousState(), pos, player.method_6047());
                }
            }
        }
        super.method_9591(world, pos, state, entity);
    }

    public void method_9556(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity, class_1799 tool) {
        GraveBlockEntity grave;
        YigdConfig config = YigdConfig.getConfig();
        if (!world.field_9236 && blockEntity instanceof GraveBlockEntity && (grave = (GraveBlockEntity)blockEntity).getComponent() != null && grave.getComponent().getStatus() != GraveStatus.CLAIMED) {
            if (config.graveConfig.retrieveMethods.onBreak) {
                grave.getComponent().claim((class_3222)player, (class_3218)world, grave.getPreviousState(), pos, tool);
                return;
            }
            world.method_8501(pos, state);
            Optional be = world.method_35230(pos, Yigd.GRAVE_BLOCK_ENTITY);
            if (be.isPresent()) {
                GraveBlockEntity graveBlockEntity = (GraveBlockEntity)((Object)be.get());
                graveBlockEntity.setPreviousState(grave.getPreviousState());
                Optional<GraveComponent> component = DeathInfoManager.INSTANCE.getGrave(grave.getGraveId());
                component.ifPresent(graveBlockEntity::setComponent);
                Yigd.END_OF_TICK.add(() -> {
                    graveBlockEntity.method_5431();
                    world.method_8413(pos, state, state, 3);
                });
                return;
            }
        }
        super.method_9556(world, player, pos, state, blockEntity, tool);
    }

    public float method_9594(class_2680 state, class_1657 player, class_1922 world, class_2338 pos) {
        GraveBlockEntity grave;
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof GraveBlockEntity && (grave = (GraveBlockEntity)class_25862).isUnclaimed() && !YigdConfig.getConfig().graveConfig.retrieveMethods.onBreak) {
            return 0.0f;
        }
        return super.method_9594(state, player, world, pos);
    }

    public static void reloadShapeFromJson(JsonObject json) throws IllegalStateException {
        ArrayList<class_265> voxelShapesNorth = new ArrayList<class_265>();
        ArrayList<class_265> voxelShapesSouth = new ArrayList<class_265>();
        ArrayList<class_265> voxelShapesEast = new ArrayList<class_265>();
        ArrayList<class_265> voxelShapesWest = new ArrayList<class_265>();
        JsonArray elements = json.getAsJsonArray("elements");
        for (JsonElement element : elements) {
            JsonObject o = element.getAsJsonObject();
            JsonArray from = o.getAsJsonArray("from");
            JsonArray to = o.getAsJsonArray("to");
            double x1 = from.get(0).getAsDouble() / 16.0;
            double y1 = from.get(1).getAsDouble() / 16.0;
            double z1 = from.get(2).getAsDouble() / 16.0;
            double x2 = to.get(0).getAsDouble() / 16.0;
            double y2 = to.get(1).getAsDouble() / 16.0;
            double z2 = to.get(2).getAsDouble() / 16.0;
            voxelShapesNorth.add(class_259.method_1081((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2));
            voxelShapesEast.add(class_259.method_1081((double)(1.0 - z2), (double)y1, (double)x1, (double)(1.0 - z1), (double)y2, (double)x2));
            voxelShapesSouth.add(class_259.method_1081((double)(1.0 - x2), (double)y1, (double)(1.0 - z2), (double)(1.0 - x1), (double)y2, (double)(1.0 - z1)));
            voxelShapesWest.add(class_259.method_1081((double)z1, (double)y1, (double)(1.0 - x2), (double)z2, (double)y2, (double)(1.0 - x1)));
        }
        if (voxelShapesNorth.isEmpty()) {
            return;
        }
        SHAPE_NORTH = (class_265)voxelShapesNorth.remove(0);
        SHAPE_EAST = (class_265)voxelShapesEast.remove(0);
        SHAPE_SOUTH = (class_265)voxelShapesSouth.remove(0);
        SHAPE_WEST = (class_265)voxelShapesWest.remove(0);
        voxelShapesNorth.forEach(shape -> {
            SHAPE_NORTH = class_259.method_1084((class_265)SHAPE_NORTH, (class_265)shape);
        });
        voxelShapesEast.forEach(shape -> {
            SHAPE_EAST = class_259.method_1084((class_265)SHAPE_EAST, (class_265)shape);
        });
        voxelShapesSouth.forEach(shape -> {
            SHAPE_SOUTH = class_259.method_1084((class_265)SHAPE_SOUTH, (class_265)shape);
        });
        voxelShapesWest.forEach(shape -> {
            SHAPE_WEST = class_259.method_1084((class_265)SHAPE_WEST, (class_265)shape);
        });
    }

    static {
        class_265 bottom = class_259.method_1081((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)1.0);
        class_265 supportEast = class_259.method_1081((double)0.0625, (double)0.0625, (double)0.125, (double)0.375, (double)0.1875, (double)0.875);
        class_265 bustEast = class_259.method_1081((double)0.125, (double)0.1875, (double)0.1875, (double)0.3125, (double)0.9375, (double)0.8125);
        class_265 topEast = class_259.method_1081((double)0.125, (double)0.9375, (double)0.25, (double)0.3125, (double)1.0, (double)0.75);
        class_265 supportWest = class_259.method_1081((double)0.625, (double)0.0625, (double)0.125, (double)0.9375, (double)0.1875, (double)0.875);
        class_265 bustWest = class_259.method_1081((double)0.6875, (double)0.1875, (double)0.1875, (double)0.875, (double)0.9375, (double)0.8125);
        class_265 topWest = class_259.method_1081((double)0.6875, (double)0.9375, (double)0.25, (double)0.875, (double)1.0, (double)0.75);
        class_265 supportSouth = class_259.method_1081((double)0.125, (double)0.0625, (double)0.0625, (double)0.875, (double)0.1875, (double)0.375);
        class_265 bustSouth = class_259.method_1081((double)0.1875, (double)0.1875, (double)0.125, (double)0.8125, (double)0.9375, (double)0.3125);
        class_265 topSouth = class_259.method_1081((double)0.25, (double)0.9375, (double)0.125, (double)0.75, (double)1.0, (double)0.3125);
        class_265 supportNorth = class_259.method_1081((double)0.125, (double)0.0625, (double)0.625, (double)0.875, (double)0.1875, (double)0.9375);
        class_265 bustNorth = class_259.method_1081((double)0.1875, (double)0.1875, (double)0.6875, (double)0.8125, (double)0.9375, (double)0.875);
        class_265 topNorth = class_259.method_1081((double)0.25, (double)0.9375, (double)0.6875, (double)0.75, (double)1.0, (double)0.875);
        SHAPE_EAST = class_259.method_17786((class_265)bottom, (class_265[])new class_265[]{supportEast, bustEast, topEast});
        SHAPE_WEST = class_259.method_17786((class_265)bottom, (class_265[])new class_265[]{supportWest, bustWest, topWest});
        SHAPE_SOUTH = class_259.method_17786((class_265)bottom, (class_265[])new class_265[]{supportSouth, bustSouth, topSouth});
        SHAPE_NORTH = class_259.method_17786((class_265)bottom, (class_265[])new class_265[]{supportNorth, bustNorth, topNorth});
    }
}

