/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.client.gui;

import com.b1n_ry.yigd.client.gui.widget.WCardButton;
import com.b1n_ry.yigd.client.gui.widget.WFilterableListPanel;
import com.b1n_ry.yigd.client.gui.widget.WHoverButton;
import com.b1n_ry.yigd.packets.ClientPacketHandler;
import com.b1n_ry.yigd.packets.LightPlayerData;
import com.mojang.authlib.GameProfile;
import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.client.LightweightGuiDescription;
import io.github.cottonmc.cotton.gui.widget.WCardPanel;
import io.github.cottonmc.cotton.gui.widget.WGridPanel;
import io.github.cottonmc.cotton.gui.widget.WLabel;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WTextField;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Insets;
import io.github.cottonmc.cotton.gui.widget.icon.Icon;
import io.github.cottonmc.cotton.gui.widget.icon.ItemIcon;
import io.github.cottonmc.cotton.gui.widget.icon.TextureIcon;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;

public class PlayerSelectionGui
extends LightweightGuiDescription {
    private final List<LightPlayerData> data;
    private final class_437 previousScreen;

    public PlayerSelectionGui(List<LightPlayerData> data, class_437 previousScreen) {
        this.data = data;
        this.previousScreen = previousScreen;
        WGridPanel root = new WGridPanel();
        this.setRootPanel((WPanel)root);
        root.setInsets(Insets.ROOT_PANEL);
        root.setGaps(5, 5);
        WLabel label = new WLabel((class_2561)class_2561.method_43471((String)"text.yigd.gui.players_on_server"));
        root.add((WWidget)label, 0, 0);
        WFilterableListPanel<LightPlayerData, WCardButton> listPanel = this.addFilterList(root);
        listPanel.setFilter("filter", lightPlayerData -> lightPlayerData.graveCount() - lightPlayerData.unclaimedCount() - lightPlayerData.destroyedCount() > 0);
        WTextField searchField = new WTextField();
        root.add((WWidget)searchField, 0, 1, 11, 1);
        searchField.setChangedListener(s -> listPanel.setFilter("filter", playerData -> !s.isEmpty() && playerData.playerProfile().getName().toLowerCase().startsWith(s.toLowerCase())));
        this.addFilterButton(root, listPanel);
        root.validate((GuiDescription)this);
    }

    private WFilterableListPanel<LightPlayerData, WCardButton> addFilterList(WGridPanel root) {
        ItemIcon defaultIcon = new ItemIcon(class_1802.field_8575.method_8389());
        WFilterableListPanel<LightPlayerData, WCardButton> listPanel = new WFilterableListPanel<LightPlayerData, WCardButton>(this.data, () -> new WCardButton((Icon)defaultIcon), (playerData, wCardButton) -> {
            GameProfile profile = playerData.playerProfile();
            class_1799 skull = new class_1799((class_1935)class_1802.field_8575);
            class_2487 profileNbt = new class_2487();
            class_2512.method_10684((class_2487)profileNbt, (GameProfile)profile);
            skull.method_7959("SkullOwner", (class_2520)profileNbt);
            ItemIcon icon = new ItemIcon(skull);
            wCardButton.setIcon((Icon)icon);
            wCardButton.setCardText((class_2561)class_2561.method_43469((String)"text.yigd.gui.player_name", (Object[])new Object[]{profile.getName()}));
            wCardButton.setTooltipText(List.of(class_2561.method_43469((String)"text.yigd.gui.unclaimed_count", (Object[])new Object[]{playerData.unclaimedCount()}), class_2561.method_43469((String)"text.yigd.gui.destroyed_count", (Object[])new Object[]{playerData.destroyedCount()}), class_2561.method_43469((String)"text.yigd.gui.total_count", (Object[])new Object[]{playerData.graveCount()})));
            wCardButton.setOnClick(() -> ClientPacketHandler.sendGraveSelectionRequest(profile));
        });
        root.add(listPanel, 0, 2, 12, 6);
        return listPanel;
    }

    private void addFilterButton(WGridPanel root, WFilterableListPanel<LightPlayerData, WCardButton> filterableList) {
        ItemIcon allIcon = new ItemIcon(class_1802.field_8077.method_8389());
        TextureIcon claimedIcon = new TextureIcon(new class_2960("yigd", "textures/gui/claimed_grave.png"));
        TextureIcon unclaimedIcon = new TextureIcon(new class_2960("yigd", "textures/gui/unclaimed_grave.png"));
        TextureIcon destroyedIcon = new TextureIcon(new class_2960("yigd", "textures/gui/destroyed_grave.png"));
        WCardPanel cardPanel = new WCardPanel();
        WHoverButton showAllButton = new WHoverButton((Icon)allIcon, (class_2561)class_2561.method_43471((String)"button.yigd.gui.showing_with_data"));
        WHoverButton showClaimedButton = new WHoverButton((Icon)claimedIcon, (class_2561)class_2561.method_43471((String)"button.yigd.gui.showing_with_claimed"));
        WHoverButton showUnclaimedButton = new WHoverButton((Icon)unclaimedIcon, (class_2561)class_2561.method_43471((String)"button.yigd.gui.showing_with_unclaimed"));
        WHoverButton showDestroyedButton = new WHoverButton((Icon)destroyedIcon, (class_2561)class_2561.method_43471((String)"button.yigd.gui.showing_with_destroyed"));
        cardPanel.add((WWidget)showAllButton);
        cardPanel.add((WWidget)showClaimedButton);
        cardPanel.add((WWidget)showUnclaimedButton);
        cardPanel.add((WWidget)showDestroyedButton);
        int amountOfCards = cardPanel.getCardCount();
        showAllButton.setOnClick(() -> {
            filterableList.setFilter("filter", lightPlayerData -> lightPlayerData.graveCount() - lightPlayerData.unclaimedCount() - lightPlayerData.destroyedCount() > 0);
            int index = (cardPanel.getSelectedIndex() + 1) % amountOfCards;
            cardPanel.setSelectedIndex(index);
        });
        showClaimedButton.setOnClick(() -> {
            filterableList.setFilter("filter", lightPlayerData -> lightPlayerData.unclaimedCount() > 0);
            int index = (cardPanel.getSelectedIndex() + 1) % amountOfCards;
            cardPanel.setSelectedIndex(index);
        });
        showUnclaimedButton.setOnClick(() -> {
            filterableList.setFilter("filter", lightPlayerData -> lightPlayerData.destroyedCount() > 0);
            int index = (cardPanel.getSelectedIndex() + 1) % amountOfCards;
            cardPanel.setSelectedIndex(index);
        });
        showDestroyedButton.setOnClick(() -> {
            filterableList.setFilter("filter", lightPlayerData -> true);
            int index = (cardPanel.getSelectedIndex() + 1) % amountOfCards;
            cardPanel.setSelectedIndex(index);
        });
        root.add((WWidget)cardPanel, 11, 1, 1, 1);
    }

    public class_437 getPreviousScreen() {
        return this.previousScreen;
    }
}

