/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.compat;

import com.b1n_ry.yigd.compat.CompatComponent;
import com.b1n_ry.yigd.compat.InvModCompat;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.data.DeathContext;
import com.b1n_ry.yigd.events.DropRuleEvent;
import com.b1n_ry.yigd.util.DropRule;
import com.glisco.numismaticoverhaul.ModComponents;
import com.glisco.numismaticoverhaul.NumismaticOverhaul;
import com.glisco.numismaticoverhaul.currency.CurrencyComponent;
import com.glisco.numismaticoverhaul.currency.CurrencyConverter;
import com.glisco.numismaticoverhaul.item.CoinItem;
import com.glisco.numismaticoverhaul.item.CurrencyItem;
import java.util.function.Predicate;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_3545;

public class NumismaticOverhaulCompat
implements InvModCompat<Long> {
    @Override
    public String getModName() {
        return "numismatic overhaul";
    }

    @Override
    public void clear(class_3222 player) {
        CurrencyComponent component = (CurrencyComponent)ModComponents.CURRENCY.get((Object)player);
        long value = component.getValue();
        component.silentModify(-value);
    }

    @Override
    public CompatComponent<Long> readNbt(class_2487 nbt) {
        long value = nbt.method_10537("value");
        long dropValue = nbt.method_10545("dropValue") ? nbt.method_10537("dropValue") : 0L;
        long keepValue = nbt.method_10545("keepValue") ? nbt.method_10537("keepValue") : 0L;
        long destroyValue = nbt.method_10545("destroyValue") ? nbt.method_10537("destroyValue") : 0L;
        long graveValue = nbt.method_10545("graveValue") ? nbt.method_10537("graveValue") : 0L;
        return new NumismaticCompatComponent(value, dropValue, keepValue, destroyValue, graveValue);
    }

    @Override
    public CompatComponent<Long> getNewComponent(class_3222 player) {
        return new NumismaticCompatComponent(player);
    }

    private static class NumismaticCompatComponent
    extends CompatComponent<Long> {
        private long dropValue = 0L;
        private long keepValue = 0L;
        private long destroyValue = 0L;
        private long graveValue = 0L;

        public NumismaticCompatComponent(class_3222 player) {
            super(player);
        }

        public NumismaticCompatComponent(long inventory, long dropValue, long keepValue, long destroyValue, long graveValue) {
            super(inventory);
            this.dropValue = dropValue;
            this.keepValue = keepValue;
            this.destroyValue = destroyValue;
            this.graveValue = graveValue;
        }

        @Override
        public Long getInventory(class_3222 player) {
            return ((CurrencyComponent)ModComponents.CURRENCY.get((Object)player)).getValue();
        }

        @Override
        public class_2371<class_1799> merge(CompatComponent<?> mergingComponent, class_3222 merger) {
            this.inventory = (Long)this.inventory + (Long)mergingComponent.inventory;
            return class_2371.method_10211();
        }

        @Override
        public class_2371<class_1799> storeToPlayer(class_3222 player) {
            ((CurrencyComponent)ModComponents.CURRENCY.get((Object)player)).modify(((Long)this.inventory).longValue());
            return class_2371.method_10211();
        }

        @Override
        public void handleDropRules(DeathContext context) {
            YigdConfig.CompatConfig compatConfig = YigdConfig.getConfig().compatConfig;
            int dropRate = ((class_1928.class_4312)context.world().method_8450().method_20746(NumismaticOverhaul.MONEY_DROP_PERCENTAGE)).method_20763();
            float dropFactor = (float)dropRate * 0.01f;
            float keepFactor = Math.max(1.0f - dropFactor, 0.0f);
            this.dropValue = 0L;
            this.destroyValue = 0L;
            this.graveValue = 0L;
            this.keepValue = (long)((float)((Long)this.inventory).longValue() * keepFactor);
            this.inventory = (Long)this.inventory - this.keepValue;
            block6: for (class_1799 stack : CurrencyConverter.getAsItemStackArray((long)((Long)this.inventory))) {
                DropRule dropRule = compatConfig.defaultNumismaticDropRule;
                class_1792 class_17922 = stack.method_7909();
                if (!(class_17922 instanceof CurrencyItem)) continue;
                CurrencyItem cItem = (CurrencyItem)class_17922;
                long itemValue = cItem.getValue(stack);
                if (dropRule == DropRule.PUT_IN_GRAVE) {
                    dropRule = ((DropRuleEvent)DropRuleEvent.EVENT.invoker()).getDropRule(stack, -1, context, true);
                }
                switch (dropRule) {
                    case DROP: {
                        this.inventory = (Long)this.inventory - itemValue;
                        this.dropValue += itemValue;
                        continue block6;
                    }
                    case DESTROY: {
                        this.inventory = (Long)this.inventory - itemValue;
                        this.destroyValue += itemValue;
                        continue block6;
                    }
                    case KEEP: {
                        this.inventory = (Long)this.inventory - itemValue;
                        this.keepValue += itemValue;
                        continue block6;
                    }
                    case PUT_IN_GRAVE: {
                        this.inventory = (Long)this.inventory - itemValue;
                        this.graveValue += itemValue;
                    }
                }
            }
        }

        @Override
        public class_2371<class_3545<class_1799, DropRule>> getAsStackDropList() {
            class_2371 list = class_2371.method_10211();
            if (this.graveValue != 0L) {
                for (class_1799 stack : CurrencyConverter.getAsItemStackArray((long)this.graveValue)) {
                    list.add((Object)new class_3545((Object)stack, (Object)DropRule.PUT_IN_GRAVE));
                }
            }
            if (this.dropValue != 0L) {
                for (class_1799 stack : CurrencyConverter.getAsItemStackArray((long)this.dropValue)) {
                    list.add((Object)new class_3545((Object)stack, (Object)DropRule.DROP));
                }
            }
            if (this.keepValue != 0L) {
                for (class_1799 stack : CurrencyConverter.getAsItemStackArray((long)this.keepValue)) {
                    list.add((Object)new class_3545((Object)stack, (Object)DropRule.KEEP));
                }
            }
            if (this.destroyValue != 0L) {
                for (class_1799 stack : CurrencyConverter.getAsItemStackArray((long)this.destroyValue)) {
                    list.add((Object)new class_3545((Object)stack, (Object)DropRule.DESTROY));
                }
            }
            return list;
        }

        @Override
        public CompatComponent<Long> filterInv(Predicate<DropRule> predicate) {
            long totalValue = 0L;
            long dropValue = 0L;
            long keepValue = 0L;
            long destroyValue = 0L;
            long graveValue = 0L;
            if (predicate.test(DropRule.DROP)) {
                totalValue += this.dropValue;
                dropValue = this.dropValue;
            }
            if (predicate.test(DropRule.KEEP)) {
                totalValue += this.keepValue;
                keepValue = this.keepValue;
            }
            if (predicate.test(DropRule.DESTROY)) {
                totalValue += this.destroyValue;
                destroyValue = this.destroyValue;
            }
            if (predicate.test(DropRule.PUT_IN_GRAVE)) {
                totalValue += this.graveValue;
                graveValue = this.graveValue;
            }
            return new NumismaticCompatComponent(totalValue, dropValue, keepValue, destroyValue, graveValue);
        }

        @Override
        public boolean removeItem(Predicate<class_1799> predicate, int itemCount) {
            class_1799[] stacks;
            for (class_1799 stack : stacks = CurrencyConverter.getAsItemStackArray((long)((Long)this.inventory))) {
                if (!predicate.test(stack)) continue;
                this.inventory = (Long)this.inventory - ((CoinItem)stack.method_7909()).currency.getRawValue((long)itemCount);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            this.inventory = 0L;
        }

        @Override
        public boolean containsGraveItems() {
            return this.graveValue != 0L;
        }

        @Override
        public class_2487 writeNbt() {
            class_2487 nbt = new class_2487();
            nbt.method_10544("value", ((Long)this.inventory).longValue());
            nbt.method_10544("dropValue", this.dropValue);
            nbt.method_10544("keepValue", this.keepValue);
            nbt.method_10544("destroyValue", this.destroyValue);
            nbt.method_10544("graveValue", this.graveValue);
            return nbt;
        }
    }
}

