/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.util;

import com.b1n_ry.yigd.Yigd;
import com.b1n_ry.yigd.config.YigdConfig;
import com.mojang.serialization.DynamicOps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class GraveCompassHelper {
    private static final Map<class_5321<class_1937>, KDNode> GRAVE_POSITIONS = new HashMap<class_5321<class_1937>, KDNode>();

    public static void giveCompass(class_3222 player, UUID graveId, class_2338 gravePos, class_5321<class_1937> worldKey) {
        class_1799 compass = class_1802.field_8251.method_7854();
        class_2487 compassNbt = new class_2487();
        class_2338 closestPos = null;
        class_5321 playerWorld = player.method_51469().method_27983();
        if (YigdConfig.getConfig().extraFeatures.graveCompass.pointToClosest != YigdConfig.ExtraFeatures.GraveCompassConfig.CompassGraveTarget.DISABLED) {
            closestPos = GraveCompassHelper.findClosest(player.method_5667(), (class_5321<class_1937>)playerWorld, player.method_24515());
        }
        if (closestPos != null) {
            compassNbt.method_10566("grave_pos", (class_2520)class_2512.method_10692(closestPos));
            class_1937.field_25178.encodeStart((DynamicOps)class_2509.field_11560, (Object)playerWorld).resultOrPartial(arg_0 -> ((Logger)Yigd.LOGGER).error(arg_0)).ifPresent(worldNbt -> compassNbt.method_10566("grave_dimension", worldNbt));
        } else {
            compassNbt.method_25927("linked_grave", graveId);
            compassNbt.method_10566("grave_pos", (class_2520)class_2512.method_10692((class_2338)gravePos));
            class_1937.field_25178.encodeStart((DynamicOps)class_2509.field_11560, worldKey).resultOrPartial(arg_0 -> ((Logger)Yigd.LOGGER).error(arg_0)).ifPresent(worldNbt -> compassNbt.method_10566("grave_dimension", worldNbt));
        }
        compass.method_7980(compassNbt);
        compass.method_7977((class_2561)class_2561.method_43471((String)"item.yigd.grave_compass").method_27694(style -> style.method_10978(Boolean.valueOf(false))));
        player.method_7270(compass);
    }

    public static void updateClosestNbt(class_5321<class_1937> worldKey, class_2338 pos, UUID holderId, class_1799 compass) {
        if (YigdConfig.getConfig().extraFeatures.graveCompass.pointToClosest == YigdConfig.ExtraFeatures.GraveCompassConfig.CompassGraveTarget.DISABLED) {
            return;
        }
        class_2487 compassNbt = compass.method_7969();
        if (compassNbt == null) {
            return;
        }
        if (!compassNbt.method_10545("grave_pos")) {
            return;
        }
        class_2338 closestPos = GraveCompassHelper.findClosest(holderId, worldKey, pos);
        if (closestPos != null) {
            compassNbt.method_10566("grave_pos", (class_2520)class_2512.method_10692((class_2338)closestPos));
            class_1937.field_25178.encodeStart((DynamicOps)class_2509.field_11560, worldKey).resultOrPartial(arg_0 -> ((Logger)Yigd.LOGGER).error(arg_0)).ifPresent(worldNbt -> compassNbt.method_10566("grave_dimension", worldNbt));
        }
    }

    public static void addGravePosition(class_5321<class_1937> worldKey, class_2338 gravePos, UUID ownerId) {
        KDNode root = GRAVE_POSITIONS.get(worldKey);
        int[] pos = new int[]{gravePos.method_10263(), gravePos.method_10264(), gravePos.method_10260()};
        if (root == null) {
            GRAVE_POSITIONS.put(worldKey, new KDNode(ownerId, pos, null, null));
            return;
        }
        GraveCompassHelper.addGravePosition(root, ownerId, pos, 0);
    }

    private static void addGravePosition(KDNode parent, UUID ownerId, int[] pos, int depth) {
        if (depth > 100) {
            return;
        }
        int cmp = depth % 3;
        if (pos[cmp] < parent.pos[cmp]) {
            if (parent.left == null) {
                parent.left = new KDNode(ownerId, pos, null, null);
            } else {
                GraveCompassHelper.addGravePosition(parent.left, ownerId, pos, depth + 1);
            }
        } else if (parent.right == null) {
            parent.right = new KDNode(ownerId, pos, null, null);
        } else {
            GraveCompassHelper.addGravePosition(parent.right, ownerId, pos, depth + 1);
        }
    }

    public static void setClaimed(class_5321<class_1937> worldKey, class_2338 gravePos) {
        KDNode root = GRAVE_POSITIONS.get(worldKey);
        if (root == null) {
            return;
        }
        int[] pos = new int[]{gravePos.method_10263(), gravePos.method_10264(), gravePos.method_10260()};
        GraveCompassHelper.setClaimed(root, pos, 0);
    }

    private static void setClaimed(KDNode node, int[] pos, int depth) {
        if (node == null) {
            return;
        }
        if (Arrays.equals(node.pos, pos)) {
            node.isUnclaimed = false;
            return;
        }
        int cmp = depth % 3;
        if (node.pos[cmp] < pos[cmp]) {
            GraveCompassHelper.setClaimed(node.right, pos, depth + 1);
        } else {
            GraveCompassHelper.setClaimed(node.left, pos, depth + 1);
        }
    }

    @Nullable
    public static class_2338 findClosest(UUID ownerId, class_5321<class_1937> worldKey, class_2338 pos) {
        YigdConfig.ExtraFeatures.GraveCompassConfig config = YigdConfig.getConfig().extraFeatures.graveCompass;
        if (config.pointToClosest == YigdConfig.ExtraFeatures.GraveCompassConfig.CompassGraveTarget.DISABLED) {
            return null;
        }
        KDNode root = GRAVE_POSITIONS.get(worldKey);
        if (root == null) {
            return null;
        }
        int[] searchPos = new int[]{pos.method_10263(), pos.method_10264(), pos.method_10260()};
        int[] closest = GraveCompassHelper.findClosest(root, ownerId, searchPos, 0, config);
        return closest == null ? null : new class_2338(closest[0], closest[1], closest[2]);
    }

    private static int[] findClosest(KDNode node, UUID ownerId, int[] pos, int depth, YigdConfig.ExtraFeatures.GraveCompassConfig config) {
        KDNode otherNode;
        KDNode nextNode;
        if (node == null || depth > 100) {
            return null;
        }
        int cmp = depth % 3;
        int[] closest = null;
        if ((config.pointToClosest == YigdConfig.ExtraFeatures.GraveCompassConfig.CompassGraveTarget.ALL || node.ownerId.equals(ownerId)) && node.isUnclaimed) {
            closest = node.pos;
        }
        if (pos[cmp] < node.pos[cmp]) {
            nextNode = node.left;
            otherNode = node.right;
        } else {
            nextNode = node.right;
            otherNode = node.left;
        }
        int[] closestChild = GraveCompassHelper.findClosest(nextNode, ownerId, pos, depth + 1, config);
        if (closestChild != null && (closest == null || GraveCompassHelper.distanceSquared(closestChild, pos) < GraveCompassHelper.distanceSquared(closest, pos))) {
            closest = closestChild;
        }
        if ((closestChild == null || Math.pow(node.pos[cmp] - pos[cmp], 2.0) < GraveCompassHelper.distanceSquared(closest, pos)) && (closestChild = GraveCompassHelper.findClosest(otherNode, ownerId, pos, depth + 1, config)) != null && (closest == null || GraveCompassHelper.distanceSquared(closestChild, pos) < GraveCompassHelper.distanceSquared(closest, pos))) {
            closest = closestChild;
        }
        return closest;
    }

    private static double distanceSquared(int[] pos1, int[] pos2) {
        return Math.pow(pos1[0] - pos2[0], 2.0) + Math.pow(pos1[1] - pos2[1], 2.0) + Math.pow(pos1[2] - pos2[2], 2.0);
    }

    private static class KDNode {
        @NotNull
        private final UUID ownerId;
        private boolean isUnclaimed = true;
        private final int @NotNull [] pos;
        @Nullable
        private KDNode left;
        @Nullable
        private KDNode right;

        public KDNode(@NotNull UUID ownerId, int @NotNull [] pos, @Nullable KDNode left, @Nullable KDNode right) {
            this.ownerId = ownerId;
            this.pos = pos;
            this.left = left;
            this.right = right;
        }
    }
}

