/*
 * Decompiled with CFR 0.152.
 */
package artifacts;

import artifacts.component.SwimData;
import artifacts.item.wearable.necklace.CharmOfSinkingItem;
import artifacts.platform.PlatformServices;
import artifacts.registry.ModGameRules;
import artifacts.registry.ModItems;
import artifacts.registry.ModKeyMappings;
import dev.architectury.event.events.client.ClientTickEvent;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class HeliumFlamingoInputEventHandler {
    private static boolean wasSprintKeyDown;
    private static boolean wasSprintingOnGround;
    private static boolean hasTouchedGround;

    public static void register() {
        ClientTickEvent.CLIENT_POST.register(HeliumFlamingoInputEventHandler::onClientTick);
    }

    private static void onClientTick(class_310 instance) {
        class_746 player = instance.field_1724;
        if (player != null && player.field_3913 != null) {
            HeliumFlamingoInputEventHandler.handleHeliumFlamingoInput((class_1657)player);
        }
    }

    private static void handleHeliumFlamingoInput(class_1657 player) {
        if (ModGameRules.HELIUM_FLAMINGO_FLIGHT_DURATION.get() == 0) {
            return;
        }
        boolean isSprintKeyDown = ModKeyMappings.getHeliumFlamingoKey().method_1434();
        SwimData swimData = PlatformServices.platformHelper.getSwimData((class_1309)player);
        if (swimData == null) {
            return;
        }
        if (!swimData.isSwimming()) {
            if (player.method_24828()) {
                hasTouchedGround = true;
            } else if (HeliumFlamingoInputEventHandler.canActivateHeliumFlamingo(swimData, player, isSprintKeyDown)) {
                swimData.setSwimming(true);
                swimData.syncSwimming();
                hasTouchedGround = false;
            }
        } else if (player.method_31549().field_7479) {
            swimData.setSwimming(false);
            swimData.syncSwimming();
            hasTouchedGround = true;
        }
        wasSprintKeyDown = isSprintKeyDown;
        if (!isSprintKeyDown) {
            wasSprintingOnGround = false;
        } else if (player.method_24828()) {
            wasSprintingOnGround = true;
        }
    }

    private static boolean canActivateHeliumFlamingo(SwimData swimData, class_1657 player, boolean isSprintKeyDown) {
        if (swimData.isSwimming() || swimData.getSwimTime() < 0 || !ModItems.HELIUM_FLAMINGO.get().isEquippedBy((class_1309)player)) {
            return false;
        }
        if (player.method_5681()) {
            return true;
        }
        return isSprintKeyDown && !wasSprintKeyDown && !wasSprintingOnGround && hasTouchedGround && !player.method_24828() && (!player.method_5799() || CharmOfSinkingItem.shouldSink((class_1309)player)) && !player.method_6128() && !player.method_31549().field_7479 && !player.method_5765();
    }
}

