/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.registry;

import com.google.common.collect.BiMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class DirectStorageBiMap<K, V>
implements BiMap<K, V> {
    private final Function<V, K> keyGetter;
    private final BiConsumer<V, K> keySetter;
    private final Map<K, V> forwardMap;

    public DirectStorageBiMap(Function<V, K> keyGetter, BiConsumer<V, K> keySetter) {
        Objects.requireNonNull(keyGetter);
        Objects.requireNonNull(keySetter);
        this.keyGetter = keyGetter;
        this.keySetter = keySetter;
        this.forwardMap = new Object2ObjectOpenHashMap();
    }

    public int size() {
        return this.forwardMap.size();
    }

    public boolean isEmpty() {
        return this.forwardMap.isEmpty();
    }

    public boolean containsKey(Object o) {
        return this.forwardMap.containsKey(o);
    }

    public boolean containsValue(Object o) {
        return o != null && this.keyGetter.apply(o) != null;
    }

    public V get(Object o) {
        return this.forwardMap.get(o);
    }

    public V put(K key, V value) {
        if (this.forwardMap.containsKey(key) || value != null && this.keyGetter.apply(value) != null) {
            throw new IllegalArgumentException("Already have mapping for " + key);
        }
        return this.forcePut(key, value);
    }

    public V remove(Object o) {
        return this.put(o, null);
    }

    public V forcePut(K key, V value) {
        V previousValue = this.forwardMap.put(key, value);
        if (previousValue != null) {
            this.keySetter.accept(previousValue, null);
        }
        if (value != null) {
            this.keySetter.accept(value, key);
        }
        return previousValue;
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        map.forEach(this::put);
    }

    public void clear() {
        for (V value : this.forwardMap.values()) {
            if (value == null) continue;
            this.keySetter.accept(value, null);
        }
        this.forwardMap.clear();
    }

    @NotNull
    public Set<K> keySet() {
        return this.forwardMap.keySet();
    }

    public Set<V> values() {
        return new HashSet<V>(this.forwardMap.values());
    }

    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.forwardMap.entrySet();
    }

    public BiMap<V, K> inverse() {
        return new Reverse();
    }

    class Reverse
    implements BiMap<V, K> {
        Reverse() {
        }

        public int size() {
            return DirectStorageBiMap.this.size();
        }

        public boolean isEmpty() {
            return DirectStorageBiMap.this.isEmpty();
        }

        public boolean containsKey(Object o) {
            return DirectStorageBiMap.this.containsValue(o);
        }

        public boolean containsValue(Object o) {
            return DirectStorageBiMap.this.containsKey(o);
        }

        public K get(Object o) {
            return o == null ? null : (Object)DirectStorageBiMap.this.keyGetter.apply(o);
        }

        public K put(V key, K value) {
            throw new UnsupportedOperationException();
        }

        public K remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public K forcePut(V key, K value) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map<? extends V, ? extends K> map) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public Set<V> keySet() {
            return DirectStorageBiMap.this.values();
        }

        public Set<K> values() {
            return DirectStorageBiMap.this.keySet();
        }

        @NotNull
        public Set<Map.Entry<V, K>> entrySet() {
            return DirectStorageBiMap.this.entrySet().stream().map(entry -> new AbstractMap.SimpleImmutableEntry(entry.getValue(), entry.getKey())).collect(Collectors.toSet());
        }

        public BiMap<K, V> inverse() {
            return DirectStorageBiMap.this;
        }
    }
}

