/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.gui.config;

import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import reborncore.client.ClientNetworkManager;
import reborncore.client.gui.GuiBase;
import reborncore.client.gui.config.GuiTab;
import reborncore.common.blockentity.RedstoneConfiguration;
import reborncore.common.network.IdentifiedPacket;
import reborncore.common.network.ServerBoundPackets;

@Environment(value=EnvType.CLIENT)
public class RedstoneConfigGui
extends GuiTab {
    public RedstoneConfigGui(GuiBase<?> guiBase) {
        super(guiBase);
    }

    @Override
    public String name() {
        return "reborncore.gui.tooltip.config_redstone";
    }

    @Override
    public boolean enabled() {
        return true;
    }

    @Override
    public class_1799 stack() {
        return new class_1799((class_1935)class_1802.field_8725);
    }

    @Override
    public void draw(class_332 drawContext, int mouseX, int mouseY) {
        if (this.guiBase.getMachine() == null) {
            return;
        }
        RedstoneConfiguration configuration = this.guiBase.getMachine().getRedstoneConfiguration();
        int x = 10;
        int y = 100;
        int i = 0;
        int spread = configuration.getElements().size() == 3 ? 27 : 18;
        for (RedstoneConfiguration.Element element : configuration.getElements()) {
            drawContext.method_51427(element.getIcon(), x - 3, y + i * spread - 5);
            drawContext.method_51439(this.guiBase.getTextRenderer(), (class_2561)class_2561.method_43471((String)("reborncore.gui.fluidconfig." + element.getName())), x + 15, y + i * spread, -1, false);
            boolean hovered = this.withinBounds(this.guiBase, mouseX, mouseY, x + 92, y + i * spread - 2, 63, 15);
            int color = hovered ? -7631989 : 0x668B8B8B;
            drawContext.method_25294(x + 91, y + i * spread - 2, x + 93 + 65, y + i * spread + 10, color);
            class_5250 name = class_2561.method_43471((String)("reborncore.gui.fluidconfig." + configuration.getState(element).name().toLowerCase(Locale.ROOT)));
            this.guiBase.drawCentredText(drawContext, (class_2561)name, y + i * spread, -1, x + 37, GuiBase.Layer.FOREGROUND);
            ++i;
        }
    }

    @Override
    public boolean click(double mouseX, double mouseY, int mouseButton) {
        if (this.guiBase.getMachine() == null) {
            return false;
        }
        RedstoneConfiguration configuration = this.guiBase.getMachine().getRedstoneConfiguration();
        int x = 10;
        int y = 100;
        int i = 0;
        int spread = configuration.getElements().size() == 3 ? 27 : 18;
        for (RedstoneConfiguration.Element element : configuration.getElements()) {
            if (this.withinBounds(this.guiBase, (int)mouseX, (int)mouseY, x + 91, y + i * spread - 2, 63, 15)) {
                RedstoneConfiguration.State currentState = configuration.getState(element);
                int ns = currentState.ordinal() + 1;
                if (ns >= RedstoneConfiguration.State.values().length) {
                    ns = 0;
                }
                RedstoneConfiguration.State nextState = RedstoneConfiguration.State.values()[ns];
                IdentifiedPacket packet = ServerBoundPackets.createPacketSetRedstoneSate(this.guiBase.getMachine().method_11016(), element, nextState);
                ClientNetworkManager.sendToServer(packet);
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean hideGuiElements() {
        return false;
    }

    private boolean withinBounds(GuiBase<?> guiBase, int mouseX, int mouseY, int x, int y, int width, int height) {
        return (mouseX -= guiBase.getGuiLeft()) > x && mouseX < x + width && (mouseY -= guiBase.getGuiTop()) > y && mouseY < y + height;
    }
}

