/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.crafting.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import org.jetbrains.annotations.Nullable;
import reborncore.common.crafting.ingredient.FluidIngredient;
import reborncore.common.crafting.ingredient.RebornIngredient;
import reborncore.common.crafting.ingredient.StackIngredient;
import reborncore.common.crafting.ingredient.TagIngredient;

public class IngredientFactory {
    public static RebornIngredient deserialize(@Nullable JsonElement jsonElement) {
        if (jsonElement == null || !jsonElement.isJsonObject()) {
            throw new JsonParseException("ingredient must be a json object");
        }
        JsonObject json = jsonElement.getAsJsonObject();
        if (json.has("type")) {
            throw new UnsupportedOperationException("type is unsupported");
        }
        if (json.has("fluid")) {
            return FluidIngredient.deserialize(json);
        }
        if (json.has("tag") || json.has("tag_server_sync")) {
            return TagIngredient.deserialize(json);
        }
        if (json.has("item")) {
            return StackIngredient.deserialize(json);
        }
        throw new UnsupportedOperationException("Unable to determine ingredient: " + String.valueOf(json));
    }
}

