/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.util;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.minecraft.class_124;
import net.minecraft.class_1262;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import org.jetbrains.annotations.Nullable;
import reborncore.common.powerSystem.RcEnergyItem;
import reborncore.common.recipes.IRecipeInput;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.EnergyStorageUtil;

public class ItemUtils {
    public static boolean isItemEqual(class_1799 a, class_1799 b, boolean matchNBT) {
        if (a.method_7960() || b.method_7960()) {
            return false;
        }
        if (a.method_7909() != b.method_7909()) {
            return false;
        }
        return !matchNBT || Objects.equals(a.method_7969(), b.method_7969());
    }

    public static boolean isItemEqual(class_1799 a, class_1799 b, boolean matchNBT, boolean useTags) {
        if (a.method_7960() && b.method_7960()) {
            return true;
        }
        if (ItemUtils.isItemEqual(a, b, matchNBT)) {
            return true;
        }
        if (a.method_7960() || b.method_7960()) {
            return false;
        }
        if (useTags) {
            // empty if block
        }
        return false;
    }

    public static boolean canExtractAnyFromShulker(class_1799 shulkerStack, class_1799 targetStack) {
        class_2371<class_1799> stacks = ItemUtils.getBlockEntityStacks(shulkerStack);
        if (stacks == null) {
            return false;
        }
        for (class_1799 stack : stacks) {
            if (!ItemUtils.isItemEqual(targetStack, stack, true)) continue;
            return true;
        }
        return false;
    }

    public static int canExtractFromCachedShulker(List<class_1799> stacks, class_1799 targetStack) {
        if (stacks == null) {
            return 0;
        }
        int defaultValue = 0;
        for (class_1799 stack : stacks) {
            if (!ItemUtils.isItemEqual(targetStack, stack, true)) continue;
            defaultValue += stack.method_7947();
        }
        return defaultValue;
    }

    public static boolean isStackListEmpty(List<class_1799> stacks) {
        for (class_1799 stack : stacks) {
            if (stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public static int extractableFromCachedShulker(List<class_1799> stacks, class_1799 targetStack, int maxAmount) {
        int extracted = 0;
        for (class_1799 stack : stacks) {
            if (stack.method_7960()) continue;
            if (ItemUtils.isItemEqual(targetStack, stack, true)) {
                int count = stack.method_7947();
                int toExtract = Math.min(maxAmount, count);
                stack.method_7934(toExtract);
                maxAmount -= toExtract;
                extracted += toExtract;
            }
            if (maxAmount == 0) break;
            if (maxAmount < 0) {
                throw new AssertionError((Object)"Extracted more than required amount!");
            }
        }
        return extracted;
    }

    public static class_3545<Integer, class_1799> extractFromShulker(class_1799 shulkerStack, class_2371<class_1799> entityStack, class_1799 targetStack, int capacity) {
        class_1799 newStack = shulkerStack.method_7972();
        if (entityStack == null) {
            entityStack = ItemUtils.getBlockEntityStacks(newStack);
        }
        if (entityStack == null) {
            return new class_3545((Object)0, (Object)shulkerStack);
        }
        int extracted = ItemUtils.extractableFromCachedShulker(entityStack, targetStack, capacity);
        if (extracted == 0) {
            return new class_3545((Object)0, (Object)shulkerStack);
        }
        class_2487 blockEntityTag = newStack.method_7941("BlockEntityTag");
        if (blockEntityTag == null) {
            throw new IllegalStateException("BlockEntityTag is removed during operation!");
        }
        if (ItemUtils.isStackListEmpty(entityStack)) {
            if (blockEntityTag.method_10545("Items")) {
                blockEntityTag.method_10551("Items");
            }
            if (blockEntityTag.method_10541().size() == 0) {
                blockEntityTag = null;
                newStack.method_7983("BlockEntityTag");
            }
            return new class_3545((Object)extracted, (Object)newStack);
        }
        class_1262.method_5426((class_2487)blockEntityTag, entityStack);
        return new class_3545((Object)extracted, (Object)newStack);
    }

    @Nullable
    public static class_2371<class_1799> getBlockEntityStacks(class_1799 targetStack) {
        int maxSize = 128;
        class_2487 compound = targetStack.method_7941("BlockEntityTag");
        if (compound == null) {
            return null;
        }
        class_2371 returnStacks = class_2371.method_10213((int)maxSize, (Object)class_1799.field_8037);
        if (compound.method_10545("Items")) {
            class_1262.method_5429((class_2487)compound, (class_2371)returnStacks);
        }
        return returnStacks;
    }

    public static boolean isEqualIgnoreEnergy(class_1799 stack1, class_1799 stack2) {
        if (stack1 == stack2) {
            return true;
        }
        if (!stack1.method_31574(stack2.method_7909())) {
            return false;
        }
        if (stack1.method_7947() != stack2.method_7947()) {
            return false;
        }
        if (stack1.method_7969() == stack2.method_7969()) {
            return true;
        }
        if (stack1.method_7969() == null || stack2.method_7969() == null) {
            return false;
        }
        class_2487 nbt1Copy = stack1.method_7969().method_10553();
        class_2487 nbt2Copy = stack2.method_7969().method_10553();
        nbt1Copy.method_10551("energy");
        nbt2Copy.method_10551("energy");
        return nbt1Copy.equals((Object)nbt2Copy);
    }

    public static boolean isInputEqual(Object input, class_1799 other, boolean matchNBT, boolean useTags) {
        if (input instanceof class_1799) {
            return ItemUtils.isItemEqual((class_1799)input, other, matchNBT, useTags);
        }
        if (!(input instanceof String) && input instanceof IRecipeInput) {
            List<class_1799> inputs = ((IRecipeInput)input).getAllStacks();
            for (class_1799 stack : inputs) {
                if (!ItemUtils.isItemEqual(stack, other, matchNBT, false)) continue;
                return true;
            }
        }
        return false;
    }

    public static void writeItemToNBT(class_1799 stack, class_2487 data) {
        if (stack.method_7960() || stack.method_7947() <= 0) {
            return;
        }
        if (stack.method_7947() > 127) {
            stack.method_7939(127);
        }
        stack.method_7953(data);
    }

    public static class_1799 readItemFromNBT(class_2487 data) {
        return class_1799.method_7915((class_2487)data);
    }

    public static int getPowerForDurabilityBar(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof RcEnergyItem)) {
            throw new UnsupportedOperationException();
        }
        RcEnergyItem energyItem = (RcEnergyItem)class_17922;
        return Math.round((float)energyItem.getStoredEnergy(stack) * 100.0f / (float)energyItem.getEnergyCapacity() * 13.0f) / 100;
    }

    public static int getColorForDurabilityBar(class_1799 stack) {
        return 16744454;
    }

    public static boolean isActive(class_1799 stack) {
        return !stack.method_7960() && stack.method_7969() != null && stack.method_7969().method_10577("isActive");
    }

    public static void checkActive(class_1799 stack, int cost, class_1297 player) {
        if (!ItemUtils.isActive(stack)) {
            return;
        }
        if (((RcEnergyItem)stack.method_7909()).getStoredEnergy(stack) >= (long)cost) {
            return;
        }
        if (player instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)player;
            serverPlayerEntity.method_7353((class_2561)class_2561.method_43471((String)"reborncore.message.energyError").method_27692(class_124.field_1080).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"reborncore.message.deactivating").method_27692(class_124.field_1065)), true);
        }
        stack.method_7948().method_10556("isActive", false);
    }

    public static void switchActive(class_1799 stack, int cost, class_1297 entity) {
        ItemUtils.checkActive(stack, cost, entity);
        if (!ItemUtils.isActive(stack)) {
            stack.method_7948().method_10556("isActive", true);
            if (entity instanceof class_3222) {
                class_3222 serverPlayerEntity = (class_3222)entity;
                serverPlayerEntity.method_7353((class_2561)class_2561.method_43471((String)"reborncore.message.setTo").method_27692(class_124.field_1080).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"reborncore.message.active").method_27692(class_124.field_1065)), true);
            }
        } else {
            stack.method_7948().method_10556("isActive", false);
            if (entity instanceof class_3222) {
                class_3222 serverPlayerEntity = (class_3222)entity;
                serverPlayerEntity.method_7353((class_2561)class_2561.method_43471((String)"reborncore.message.setTo").method_27692(class_124.field_1080).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"reborncore.message.inactive").method_27692(class_124.field_1065)), true);
            }
        }
    }

    public static void buildActiveTooltip(class_1799 stack, List<class_2561> tooltip) {
        if (!ItemUtils.isActive(stack)) {
            tooltip.add((class_2561)class_2561.method_43471((String)"reborncore.message.inactive").method_27692(class_124.field_1061));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"reborncore.message.active").method_27692(class_124.field_1060));
        }
    }

    public static void distributePowerToInventory(class_1657 player, class_1799 itemStack, long maxOutput) {
        ItemUtils.distributePowerToInventory(player, itemStack, maxOutput, stack -> true);
    }

    public static void distributePowerToInventory(class_1657 player, class_1799 itemStack, long maxOutput, Predicate<class_1799> filter) {
        PlayerInventoryStorage playerInv = PlayerInventoryStorage.of((class_1657)player);
        SingleSlotStorage sourceSlot = null;
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            if (player.method_31548().method_5438(i) != itemStack) continue;
            sourceSlot = (SingleSlotStorage)playerInv.getSlots().get(i);
            break;
        }
        if (sourceSlot == null) {
            throw new IllegalArgumentException("Failed to locate current stack in the player inventory.");
        }
        EnergyStorage sourceStorage = (EnergyStorage)ContainerItemContext.ofPlayerSlot((class_1657)player, sourceSlot).find(EnergyStorage.ITEM);
        if (sourceStorage == null) {
            return;
        }
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 invStack = player.method_31548().method_5438(i);
            if (invStack.method_7960() || !filter.test(invStack)) continue;
            EnergyStorageUtil.move((EnergyStorage)sourceStorage, (EnergyStorage)((EnergyStorage)ContainerItemContext.ofPlayerSlot((class_1657)player, (SingleSlotStorage)((SingleSlotStorage)playerInv.getSlots().get(i))).find(EnergyStorage.ITEM)), (long)maxOutput, null);
        }
    }
}

