/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.mythicmounts.client.renderer.model;

import com.yahoo.chirpycricket.mythicmounts.client.renderer.model.AnimatedLivingEntityModel;
import com.yahoo.chirpycricket.mythicmounts.entity.MountEntity;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.data.EntityModelData;

public class HeadRotationAdjustments {
    public static void getHeadAdjustment(AnimatedLivingEntityModel<MountEntity> model, MountEntity entity, AnimationState customPredicate) {
        switch (entity.mountKey) {
            default: {
                HeadRotationAdjustments.getDefaultHeadRotation(model, entity, customPredicate);
                break;
            }
            case COURIER_BIRD: {
                HeadRotationAdjustments.getCourierBirdHeadRotation(model, entity, customPredicate);
                break;
            }
            case DRAGON: {
                HeadRotationAdjustments.getDragonHeadRotation(model, entity, customPredicate);
                break;
            }
            case NIGHTMARE: {
                HeadRotationAdjustments.getNightmareHeadRotation(model, entity, customPredicate);
                break;
            }
            case RIDING_LIZARD: {
                HeadRotationAdjustments.getRidingLizardHeadRotation(model, entity, customPredicate);
            }
        }
    }

    public static void getDefaultHeadRotation(AnimatedLivingEntityModel<MountEntity> model, MountEntity entity, AnimationState customPredicate) {
        CoreGeoBone head = model.getBone("head").orElse(null);
        MountEntity entityIn = entity;
        EntityModelData extraData = (EntityModelData)customPredicate.getData(DataTickets.ENTITY_MODEL_DATA);
        if (head != null) {
            head.setRotY(extraData.netHeadYaw() * ((float)Math.PI / 180));
            head.setRotX(extraData.headPitch() * ((float)Math.PI / 180));
        }
    }

    public static void getRidingLizardHeadRotation(AnimatedLivingEntityModel<MountEntity> model, MountEntity entity, AnimationState customPredicate) {
        CoreGeoBone neck;
        CoreGeoBone head;
        MountEntity entityIn = entity;
        EntityModelData extraData = (EntityModelData)customPredicate.getData(DataTickets.ENTITY_MODEL_DATA);
        float yawAngle = 0.25f * extraData.netHeadYaw() * ((float)Math.PI / 180);
        float pitchAngle = 0.25f * extraData.headPitch() * ((float)Math.PI / 180);
        if (Math.abs(yawAngle) > 0.5235988f) {
            yawAngle = 0.0f;
        }
        if ((head = (CoreGeoBone)model.getBone("head").orElse(null)) != null) {
            head.setRotY(3.0f * yawAngle);
            head.setRotX(4.0f * pitchAngle);
        }
        if ((neck = (CoreGeoBone)model.getBone("neck").orElse(null)) != null) {
            neck.setRotY(yawAngle);
            neck.setRotX(pitchAngle);
        }
        if ((neck = (CoreGeoBone)model.getBone("neck2").orElse(null)) != null) {
            neck.setRotX(pitchAngle);
        }
        if ((neck = (CoreGeoBone)model.getBone("neck3").orElse(null)) != null) {
            neck.setRotX(pitchAngle);
        }
    }

    public static void getNightmareHeadRotation(AnimatedLivingEntityModel<MountEntity> model, MountEntity entity, AnimationState customPredicate) {
        CoreGeoBone neck;
        CoreGeoBone head;
        MountEntity entityIn = entity;
        EntityModelData extraData = (EntityModelData)customPredicate.getData(DataTickets.ENTITY_MODEL_DATA);
        float yawAngle = 0.25f * extraData.netHeadYaw() * ((float)Math.PI / 180);
        float pitchAngle = extraData.headPitch() * ((float)Math.PI / 180);
        if (Math.abs(yawAngle) > 0.5235988f) {
            yawAngle = 0.0f;
        }
        if ((head = (CoreGeoBone)model.getBone("noggin").orElse(null)) != null) {
            head.setRotY(2.0f * yawAngle);
            if (entity.method_6109()) {
                head.setRotX(pitchAngle * 1.25f);
            } else {
                head.setRotX(pitchAngle);
            }
        }
        if ((neck = (CoreGeoBone)model.getBone("head").orElse(null)) != null) {
            neck.setRotY(2.0f * yawAngle);
            neck.setRotX(pitchAngle + 0.15f);
        }
    }

    public static void getCourierBirdHeadRotation(AnimatedLivingEntityModel<MountEntity> model, MountEntity entity, AnimationState customPredicate) {
        CoreGeoBone neck;
        CoreGeoBone head;
        MountEntity entityIn = entity;
        EntityModelData extraData = (EntityModelData)customPredicate.getData(DataTickets.ENTITY_MODEL_DATA);
        float yawAngle = 0.125f * extraData.netHeadYaw() * ((float)Math.PI / 180);
        float pitchAngle = 0.125f * extraData.headPitch() * ((float)Math.PI / 180);
        if (Math.abs(yawAngle) > 0.5235988f) {
            yawAngle = 0.0f;
        }
        if ((head = (CoreGeoBone)model.getBone("head").orElse(null)) != null) {
            head.setRotY(7.0f * yawAngle);
            head.setRotX(7.0f * pitchAngle);
        }
        if ((neck = (CoreGeoBone)model.getBone("neck").orElse(null)) != null) {
            neck.setRotY(yawAngle);
            neck.setRotX(pitchAngle);
        }
        if ((neck = (CoreGeoBone)model.getBone("neck2").orElse(null)) != null) {
            neck.setRotX(pitchAngle);
        }
        if ((neck = (CoreGeoBone)model.getBone("neck3").orElse(null)) != null) {
            neck.setRotX(pitchAngle);
        }
    }

    public static void getDragonHeadRotation(AnimatedLivingEntityModel<MountEntity> model, MountEntity entity, AnimationState customPredicate) {
        MountEntity entityIn = entity;
        EntityModelData extraData = (EntityModelData)customPredicate.getData(DataTickets.ENTITY_MODEL_DATA);
        float yawAngle = 0.25f * extraData.netHeadYaw() * ((float)Math.PI / 180);
        float pitchAngle = 0.25f * extraData.headPitch() * ((float)Math.PI / 180);
        if (Math.abs(yawAngle) > 0.5235988f) {
            yawAngle = 0.0f;
        }
        if (!entity.method_6109()) {
            pitchAngle = 0.0f;
        }
        if (!entity.getIsFlying()) {
            CoreGeoBone neck;
            CoreGeoBone head = model.getBone("head").orElse(null);
            if (head != null) {
                head.setRotY(3.0f * yawAngle);
                if (entity.method_6109()) {
                    head.setRotX(pitchAngle + 0.15f);
                } else {
                    head.setRotX(5.0f * pitchAngle);
                }
            }
            if ((neck = (CoreGeoBone)model.getBone("neck").orElse(null)) != null) {
                neck.setRotY(yawAngle);
                neck.setRotX(pitchAngle);
            }
            if ((neck = (CoreGeoBone)model.getBone("neck2").orElse(null)) != null) {
                neck.setRotY(yawAngle);
                neck.setRotX(pitchAngle);
            }
            if ((neck = (CoreGeoBone)model.getBone("neck3").orElse(null)) != null) {
                neck.setRotY(0.5f * yawAngle);
                neck.setRotX(pitchAngle);
            }
        }
    }
}

