/*
 * Decompiled with CFR 0.152.
 */
package net.archers.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.archers.config.ArchersItemConfig;
import net.archers.item.Armors;
import net.archers.item.Weapons;
import net.fabric_extras.structure_pool.api.StructurePoolConfig;
import net.spell_engine.api.loot.LootConfig;

public class Default {
    public static final ArchersItemConfig itemConfig = new ArchersItemConfig();
    public static final StructurePoolConfig villages = new StructurePoolConfig();
    public static final LootConfig lootConfig;

    @SafeVarargs
    private static <T> List<T> joinLists(List<T> ... lists) {
        return Arrays.stream(lists).flatMap(Collection::stream).collect(Collectors.toList());
    }

    static {
        int largeWeight = 5;
        int smallWeight = 5;
        int limit = 1;
        Default.villages.entries = new ArrayList<StructurePoolConfig.Entry>(List.of(new StructurePoolConfig.Entry("minecraft:village/desert/houses", new ArrayList<StructurePoolConfig.Entry.Structure>(Arrays.asList(new StructurePoolConfig.Entry.Structure("archers:village/desert/archery_range_large", largeWeight, limit), new StructurePoolConfig.Entry.Structure("archers:village/desert/archery_range_small", smallWeight, limit)))), new StructurePoolConfig.Entry("minecraft:village/savanna/houses", new ArrayList<StructurePoolConfig.Entry.Structure>(Arrays.asList(new StructurePoolConfig.Entry.Structure("archers:village/savanna/archery_range_large", largeWeight, limit), new StructurePoolConfig.Entry.Structure("archers:village/savanna/archery_range_small", smallWeight, limit)))), new StructurePoolConfig.Entry("minecraft:village/plains/houses", new ArrayList<StructurePoolConfig.Entry.Structure>(Arrays.asList(new StructurePoolConfig.Entry.Structure("archers:village/plains/archery_range_large", largeWeight, limit), new StructurePoolConfig.Entry.Structure("archers:village/plains/archery_range_small", smallWeight, limit)))), new StructurePoolConfig.Entry("minecraft:village/taiga/houses", new ArrayList<StructurePoolConfig.Entry.Structure>(Arrays.asList(new StructurePoolConfig.Entry.Structure("archers:village/taiga/archery_range_large", largeWeight, limit), new StructurePoolConfig.Entry.Structure("archers:village/taiga/archery_range_small", smallWeight, limit)))), new StructurePoolConfig.Entry("minecraft:village/snowy/houses", new ArrayList<StructurePoolConfig.Entry.Structure>(Arrays.asList(new StructurePoolConfig.Entry.Structure("archers:village/snowy/archery_range_large", largeWeight, limit), new StructurePoolConfig.Entry.Structure("archers:village/snowy/archery_range_small", smallWeight, limit))))));
        lootConfig = new LootConfig();
        String weapons_tier_1 = "weapons_tier_1";
        Default.lootConfig.item_groups.put("weapons_tier_1", new LootConfig.ItemGroup(List.of(Weapons.composite_longbow.id().toString()), 1).chance(0.1f));
        String weapons_tier_2 = "weapons_tier_2";
        Default.lootConfig.item_groups.put("weapons_tier_2", new LootConfig.ItemGroup(List.of(Weapons.mechanic_shortbow.id().toString(), Weapons.royal_longbow.id().toString(), Weapons.rapid_crossbow.id().toString(), Weapons.heavy_crossbow.id().toString()), 1).chance(0.3f));
        String weapons_tier_2_enchanted = "weapons_tier_2_enchanted";
        Default.lootConfig.item_groups.put("weapons_tier_2_enchanted", new LootConfig.ItemGroup(new ArrayList(((LootConfig.ItemGroup)Default.lootConfig.item_groups.get((Object)"weapons_tier_2")).ids), 1).chance(0.3f).enchant());
        String armor_tier_1 = "armor_tier_1";
        Default.lootConfig.item_groups.put("armor_tier_1", new LootConfig.ItemGroup(Default.joinLists(Armors.archerArmorSet_T1.idStrings()), 1).chance(0.25f));
        String armor_tier_1_enchanted = "armor_tier_1_enchanted";
        Default.lootConfig.item_groups.put("armor_tier_1_enchanted", new LootConfig.ItemGroup(new ArrayList(((LootConfig.ItemGroup)Default.lootConfig.item_groups.get((Object)"armor_tier_1")).ids), 1).chance(0.25f).enchant());
        String armor_tier_2 = "armor_tier_2";
        Default.lootConfig.item_groups.put("armor_tier_2", new LootConfig.ItemGroup(Default.joinLists(Armors.archerArmorSet_T2.idStrings()), 1).chance(0.5f));
        List.of("minecraft:chests/desert_pyramid", "minecraft:chests/bastion_bridge", "minecraft:chests/jungle_temple", "minecraft:chests/pillager_outpost", "minecraft:chests/underwater_ruin_small", "minecraft:chests/stronghold_crossing").forEach(id -> Default.lootConfig.loot_tables.put(id, List.of("weapons_tier_1")));
        List.of("minecraft:chests/bastion_other", "minecraft:chests/nether_bridge", "minecraft:chests/underwater_ruin_small").forEach(id -> Default.lootConfig.loot_tables.put(id, List.of("weapons_tier_2")));
        List.of("minecraft:chests/shipwreck_supply", "minecraft:chests/stronghold_corridor").forEach(id -> Default.lootConfig.loot_tables.put(id, List.of("armor_tier_1")));
        List.of("minecraft:chests/stronghold_library", "minecraft:chests/underwater_ruin_big", "minecraft:chests/bastion_other", "minecraft:chests/woodland_mansion", "minecraft:chests/simple_dungeon", "minecraft:chests/underwater_ruin_big.json").forEach(id -> Default.lootConfig.loot_tables.put(id, List.of("weapons_tier_2", "armor_tier_1_enchanted")));
        List.of("minecraft:chests/end_city_treasure", "minecraft:chests/bastion_treasure", "minecraft:chests/ancient_city", "minecraft:chests/stronghold_library").forEach(id -> Default.lootConfig.loot_tables.put(id, List.of("weapons_tier_2_enchanted", "armor_tier_2")));
    }
}

