/*
 * Decompiled with CFR 0.152.
 */
package net.combatroll.client;

import net.combatroll.CombatRoll;
import net.combatroll.api.EntityAttributes_CombatRoll;
import net.combatroll.client.CombatRollClient;
import net.combatroll.mixin.PlayerEntityAccessor;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5134;
import net.minecraft.class_746;
import net.minecraft.class_7923;

public class RollManager {
    public boolean isEnabled = false;
    private int timeSinceLastRoll = 10;
    private int currentCooldownProgress = 0;
    private int currentCooldownLength = 0;
    private int maxRolls = 1;
    private int availableRolls = 0;

    public static int rollDuration() {
        return CombatRoll.config.roll_duration;
    }

    public CooldownInfo getCooldown() {
        return new CooldownInfo(this.currentCooldownProgress, this.currentCooldownLength, this.availableRolls, this.maxRolls);
    }

    public boolean isRollAvailable(class_1657 player) {
        return this.isEnabled && !this.isRolling() && this.availableRolls > 0 && !((PlayerEntityAccessor)player).invokeIsImmobile_CombatRoll() && player.method_6034() && player.method_26825(class_5134.field_23719) > 0.0;
    }

    public boolean isRolling() {
        return this.timeSinceLastRoll <= RollManager.rollDuration();
    }

    public void onRoll(class_746 player) {
        --this.availableRolls;
        this.timeSinceLastRoll = 0;
        this.updateCooldownLength(player);
    }

    public void tick(class_746 player) {
        this.maxRolls = (int)EntityAttributes_CombatRoll.getAttributeValue((class_1657)player, EntityAttributes_CombatRoll.Type.COUNT);
        ++this.timeSinceLastRoll;
        if (this.availableRolls < this.maxRolls) {
            ++this.currentCooldownProgress;
            if (this.currentCooldownProgress >= this.currentCooldownLength) {
                this.rechargeRoll(player);
            }
        }
        if (this.availableRolls == this.maxRolls) {
            this.currentCooldownProgress = 0;
        }
        if (this.availableRolls > this.maxRolls) {
            this.availableRolls = this.maxRolls;
        }
    }

    private void rechargeRoll(class_746 player) {
        class_3414 cooldownReady;
        ++this.availableRolls;
        this.currentCooldownProgress = 0;
        this.updateCooldownLength(player);
        if (CombatRollClient.config.playCooldownSound && (cooldownReady = (class_3414)class_7923.field_41172.method_10223(new class_2960("combatroll:roll_cooldown_ready"))) != null) {
            player.method_37908().method_8486(player.method_23317(), player.method_23318(), player.method_23321(), cooldownReady, class_3419.field_15248, 1.0f, 1.0f, false);
        }
    }

    private void updateCooldownLength(class_746 player) {
        float duration = CombatRoll.config.roll_cooldown;
        this.currentCooldownLength = (int)Math.round((double)(duration * 20.0f) * (20.0 / EntityAttributes_CombatRoll.getAttributeValue((class_1657)player, EntityAttributes_CombatRoll.Type.RECHARGE)));
    }

    public record CooldownInfo(int elapsed, int total, int availableRolls, int maxRolls) {
    }
}

