/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.common.config.impl;

import com.teamresourceful.resourcefulconfig.common.annotations.Category;
import com.teamresourceful.resourcefulconfig.common.annotations.Config;
import com.teamresourceful.resourcefulconfig.common.annotations.ConfigEntry;
import com.teamresourceful.resourcefulconfig.common.annotations.InlineCategory;
import com.teamresourceful.resourcefulconfig.common.config.ParsingUtils;
import com.teamresourceful.resourcefulconfig.common.config.impl.ResourcefulConfigEntryImpl;
import com.teamresourceful.resourcefulconfig.common.config.impl.ResourcefulConfigImpl;
import com.teamresourceful.resourcefulconfig.web.info.ResourcefulWebConfig;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public final class ConfigParser {
    public static ResourcefulConfigImpl parseConfig(Class<?> config) throws Exception {
        Config data = config.getAnnotation(Config.class);
        if (data == null) {
            throw new Exception("Config class " + config.getName() + " is missing @Config annotation!");
        }
        return ConfigParser.createConfig(ConfigParser.parseData(config, Config.class, "resourcefulconfig.config"), data.value());
    }

    private static ResourcefulConfigImpl createConfig(TempConfig config, @Nullable String file) {
        LinkedHashMap<String, ResourcefulConfigImpl> subConfigs = new LinkedHashMap<String, ResourcefulConfigImpl>();
        config.configs.forEach((key, value) -> subConfigs.put((String)key, ConfigParser.createConfig(value, null)));
        return new ResourcefulConfigImpl(config.web(), new LinkedHashMap<String, ResourcefulConfigEntryImpl>(config.entries()), subConfigs, file, config.translation());
    }

    private static TempConfig parseData(Class<?> config, Class<? extends Annotation> annotation, String translation) {
        ParsingUtils.assertValidClass(config, annotation);
        TempConfig builtConfig = new TempConfig(config, translation);
        for (Field field : config.getDeclaredFields()) {
            Annotation data;
            InlineCategory inlineCategory = field.getAnnotation(InlineCategory.class);
            if (inlineCategory != null) {
                data = field.getType().getAnnotation(Category.class);
                if (data == null) continue;
                builtConfig.configs.put(data.id(), ConfigParser.parseData(field.getType(), Category.class, data.translation()));
                continue;
            }
            data = ParsingUtils.assertEntry(field);
            if (data == null) continue;
            builtConfig.entries.put(data.id(), ResourcefulConfigEntryImpl.create((ConfigEntry)data, field));
        }
        for (AnnotatedElement annotatedElement : config.getDeclaredClasses()) {
            Category data = ((Class)annotatedElement).getAnnotation(Category.class);
            if (data == null) continue;
            builtConfig.configs.put(data.id(), ConfigParser.parseData(annotatedElement, Category.class, data.translation()));
        }
        return builtConfig;
    }

    private record TempConfig(ResourcefulWebConfig web, Map<String, ResourcefulConfigEntryImpl> entries, Map<String, TempConfig> configs, String translation) {
        private TempConfig(Class<?> config, String translation) {
            this(ResourcefulWebConfig.of(config), new LinkedHashMap<String, ResourcefulConfigEntryImpl>(), new LinkedHashMap<String, TempConfig>(), translation);
        }
    }
}

