/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.entity.animation;

import com.faboslav.friendsandfoes.client.render.entity.animation.KeyframeAnimation;
import com.faboslav.friendsandfoes.client.render.entity.animation.animator.context.AnimationContextTracker;
import com.faboslav.friendsandfoes.client.render.entity.animation.animator.context.KeyframeAnimationContext;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public interface AnimatedEntity {
    public AnimationContextTracker getAnimationContextTracker();

    default public ArrayList<KeyframeAnimation> getAnimations() {
        return new ArrayList<KeyframeAnimation>();
    }

    @Nullable
    default public KeyframeAnimation getMovementAnimation() {
        return null;
    }

    default public int getKeyframeAnimationTicks() {
        return 0;
    }

    default public void setKeyframeAnimationTicks(int keyframeAnimationTicks) {
    }

    default public void updateKeyframeAnimationTicks() {
        if (!this.isAnyKeyframeAnimationRunning()) {
            return;
        }
        this.setKeyframeAnimationTicks(this.getKeyframeAnimationTicks() - 1);
        if (this.getKeyframeAnimationTicks() != 1) {
            return;
        }
        for (KeyframeAnimation keyframeAnimation : this.getAnimations()) {
            KeyframeAnimationContext keyframeAnimationContext;
            if (!keyframeAnimation.getAnimation().looping() || !(keyframeAnimationContext = this.getAnimationContextTracker().get(keyframeAnimation)).isRunning()) continue;
            this.setKeyframeAnimationTicks(keyframeAnimation.getAnimationLengthInTicks());
        }
    }

    default public boolean isAnyKeyframeAnimationRunning() {
        return this.getKeyframeAnimationTicks() > 0;
    }

    default public boolean isKeyframeAnimationAtLastKeyframe(KeyframeAnimation keyframeAnimation) {
        return this.getAnimationContextTracker().get(keyframeAnimation).isAtLastKeyframe();
    }

    default public boolean isKeyframeAnimationRunning(KeyframeAnimation keyframeAnimation) {
        return this.getAnimationContextTracker().get(keyframeAnimation).isRunning();
    }

    default public void startKeyframeAnimation(KeyframeAnimation keyframeAnimation, int initialTick) {
        KeyframeAnimationContext keyframeAnimationContext = this.getAnimationContextTracker().get(keyframeAnimation);
        keyframeAnimationContext.setInitialTick(initialTick);
        keyframeAnimationContext.getAnimationState().method_41324(initialTick);
    }

    default public void forceStartKeyframeAnimation(KeyframeAnimation keyframeAnimation, int initialTick) {
        KeyframeAnimationContext keyframeAnimationContext = this.getAnimationContextTracker().get(keyframeAnimation);
        keyframeAnimationContext.setInitialTick(initialTick);
        keyframeAnimationContext.getAnimationState().method_41322(initialTick);
    }

    default public void stopRunningKeyframeAnimations() {
        for (KeyframeAnimation keyframeAnimation : this.getAnimations()) {
            if (this.getAnimationContextTracker().get(keyframeAnimation).isRunning()) continue;
            this.stopKeyframeAnimation(keyframeAnimation);
        }
    }

    default public void stopKeyframeAnimation(KeyframeAnimation keyframeAnimation) {
        KeyframeAnimationContext keyframeAnimationContext = this.getAnimationContextTracker().get(keyframeAnimation);
        keyframeAnimationContext.setInitialTick(0);
        keyframeAnimationContext.setCurrentTick(0);
        keyframeAnimationContext.getAnimationState().method_41325();
    }
}

