/*
 * Decompiled with CFR 0.152.
 */
package com.kirdow.itemlocks.client.update;

import com.kirdow.itemlocks.Logger;
import com.kirdow.itemlocks.client.update.UpdateCache;
import com.kirdow.itemlocks.client.update.UpdateMessage;
import com.kirdow.itemlocks.common.Reference;
import com.kirdow.itemlocks.config.state.ConfigStates;
import com.kirdow.itemlocks.util.Version;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;

public class UpdateManager {
    public static final UpdateManager UPDATE_MANAGER = new UpdateManager();
    private final Version version = new Version("1.3.6");
    private final UpdateCache updateCache = new UpdateCache(this::checkForUpdate);
    private static final UpdateMessage updateMessage = new UpdateMessage();

    public void checkAndNotifyAsync() {
        new Thread(() -> {
            boolean newUpdate = this.isUpdateAvailable();
            updateMessage.setMessage(newUpdate);
        }).start();
    }

    public boolean isUpdateAvailable() {
        return !this.updateCache.run(150000L);
    }

    public boolean checkForUpdate() {
        Logger.info("Checking for updates!", new Object[0]);
        String removeVersion = UpdateManager.downloadVersionString().trim();
        ArrayList<String> supportedVersions = new ArrayList<String>();
        StringBuilder versions = new StringBuilder();
        for (String line : removeVersion.split("\n")) {
            String trimmedLine = line.trim();
            Version supportedVersion = new Version(trimmedLine);
            if (!supportedVersion.getVersion().equals(trimmedLine)) continue;
            supportedVersions.add(trimmedLine);
            if (versions.length() > 0) {
                versions.append(", ");
            }
            versions.append(trimmedLine);
        }
        String allVersions = "[" + versions.toString() + "]";
        boolean upToDate = supportedVersions.stream().anyMatch(version -> version.equals(this.version.getVersion()));
        if (upToDate) {
            Logger.info("ItemLocks is up to date!", new Object[0]);
        } else {
            Logger.error("ItemLocks is outdated!", new Object[0]);
        }
        Logger.info("Currently supported versions: %s\n", allVersions);
        return upToDate;
    }

    public static String downloadVersionString() {
        String stringUrl = "https://bitbucket.org/!api/2.0/snippets/kirdowthrowsnull/6ezn6r/files/itemlocks.version";
        return UpdateManager.downloadString("https://bitbucket.org/!api/2.0/snippets/kirdowthrowsnull/6ezn6r/files/itemlocks.version");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String downloadString(String url) {
        BufferedReader reader = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(new URL(url).openStream()));
            while ((line = reader.readLine()) != null) {
                sb.append(line).append('\n');
            }
            IOUtils.closeQuietly((Reader)reader);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
        return sb.toString();
    }

    public static void queryOutdated() {
        updateMessage.query(outdated -> {
            if (outdated && ConfigStates.Notify.chat()) {
                Reference.logInChat("A new update for ItemLocks is available", new Object[0]);
            }
        });
    }
}

