/*
 * Decompiled with CFR 0.152.
 */
package com.kirdow.itemlocks.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.kirdow.itemlocks.Logger;
import com.kirdow.itemlocks.util.Utils;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class ConfigSpec<T> {
    private File file;
    private Class<T> clazz;
    private T data;
    private AtomicInteger req = new AtomicInteger(0);

    public ConfigSpec(File file, Class<T> clazz) {
        this.file = file;
        this.clazz = clazz;
        this.load();
    }

    public void load() {
        block9: {
            try (FileReader reader = new FileReader(this.file);){
                Gson gson = new GsonBuilder().create();
                Object result = gson.fromJson((Reader)reader, this.clazz);
                this.data = result;
            }
            catch (IOException ignored) {
                if (this.data != null) break block9;
                try {
                    Constructor<T> construct = this.clazz.getConstructor(new Class[0]);
                    construct.setAccessible(true);
                    this.data = construct.newInstance(new Object[0]);
                }
                catch (Throwable ex1) {
                    Logger.error("Failed to load and create config!", new Object[0]);
                    ex1.printStackTrace();
                }
            }
        }
    }

    public void save() {
        if (this.req.incrementAndGet() == 1) {
            Utils.runAsync(() -> {
                do {
                    this.saveImpl();
                } while (this.req.decrementAndGet() > 0);
            });
        }
    }

    private void saveImpl() {
        try (FileWriter writer = new FileWriter(this.file);){
            Gson gson = new GsonBuilder().create();
            gson.toJson(this.data, (Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public <R> R get(R _default, Function<T, R> func) {
        try {
            return func.apply(this.data);
        }
        catch (Throwable throwable) {
            return _default;
        }
    }

    public void set(Consumer<T> consumer) {
        try {
            consumer.accept(this.data);
        }
        catch (Throwable ignored) {
            return;
        }
        this.save();
    }

    public <R> Accessor<R> createAccessor(Consumer<R> setter, Supplier<R> getter) {
        return new Accessor<R>(setter, getter);
    }

    public static class Accessor<R> {
        private Consumer<R> setter;
        private Supplier<R> getter;

        public Accessor(Consumer<R> setter, Supplier<R> getter) {
            this.setter = setter;
            this.getter = getter;
        }

        public R get() {
            return this.getter.get();
        }

        public void set(R value) {
            this.setter.accept(value);
        }
    }
}

