/*
 * Decompiled with CFR 0.152.
 */
package com.kirdow.itemlocks.config.gui;

import com.kirdow.itemlocks.config.ConfigSpec;
import com.kirdow.itemlocks.config.LockOptions;
import com.kirdow.itemlocks.util.Core;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class LocksConfigGui
extends class_437 {
    private int centerX;
    private int centerY;
    private int marginX;
    private int marginY;
    private int mouseX;
    private int mouseY;
    private class_437 previousMenu;
    private class_4185 globalBtn;
    private class_4185 chatBtn;
    private class_4185 bypassHeldBtn;
    private class_4185 bypassAllBtn;
    private class_4185 bypassOffhandBtn;
    private class_4185 hotbarVisBtn;
    private Map<Integer, ButtonWidgetDelegate> delegateMap = new HashMap<Integer, ButtonWidgetDelegate>();
    private int buttonY;
    private double scrollY;
    private double scrollYmax;
    private boolean dirty;
    private List<Consumer<Integer>> scrollCorrectionList = new ArrayList<Consumer<Integer>>();
    private class_2561 activeTooltip;

    public LocksConfigGui() {
        this(null);
    }

    public LocksConfigGui(class_437 previous) {
        super((class_2561)class_2561.method_43471((String)"config.ktnilcks.base.config_title"));
        this.previousMenu = previous;
    }

    private int getOptionPosition(int index, boolean isText) {
        return 44 + 24 * index + (isText ? 6 : 0);
    }

    private void resetButtonPlacement() {
        this.buttonY = 0;
    }

    public void method_25426() {
        this.centerX = this.field_22789 / 2;
        this.centerY = this.field_22790 / 2;
        this.marginX = 10;
        this.marginY = 10;
        class_5250 backText = class_2561.method_43471((String)"gui.back");
        this.method_37063((class_364)class_4185.method_46430((class_2561)backText, btn -> this.method_25419()).method_46433(10, 10).method_46437(Core.mc().field_1772.method_1727(backText.getString()) + 12, 20).method_46431());
        this.globalBtn = this.addRenderableToggle(1, LockOptions.notifyGlobalValue);
        this.chatBtn = this.addRenderableToggle(2, LockOptions.notifyChatValue, () -> LockOptions.notifyGlobalValue.get());
        this.bypassHeldBtn = this.addRenderableToggle(5, LockOptions.bypassHeldValue);
        this.bypassOffhandBtn = this.addRenderableToggle(6, LockOptions.offhandBypassValue);
        this.bypassAllBtn = this.addRenderableToggle(7, LockOptions.bypassAllValue);
        this.hotbarVisBtn = this.addRenderableToggle(10, LockOptions.hotbarVisibleValue);
        this.pollDelegates();
    }

    private void correctScroll() {
        double max = this.scrollYmax;
        this.scrollYmax = this.getOptionPosition(11, true) - this.field_22790;
        if (this.scrollYmax < 0.0) {
            this.scrollYmax = 0.0;
        }
        if (this.scrollYmax != max) {
            this.dirty = true;
        }
        if (this.scrollY < 0.0) {
            this.dirty = true;
            this.scrollY = 0.0;
        }
        if (this.scrollY > this.scrollYmax) {
            this.dirty = true;
            this.scrollY = this.scrollYmax;
        }
        if (this.dirty) {
            for (Consumer<Integer> f : this.scrollCorrectionList) {
                f.accept((int)this.scrollY);
            }
            this.dirty = false;
        }
    }

    private void pollDelegates() {
        ButtonWidgetDelegate value;
        for (Map.Entry<Integer, ButtonWidgetDelegate> entry : this.delegateMap.entrySet()) {
            value = entry.getValue();
            value.widget.field_22763 = value.delegate.get();
        }
        for (Map.Entry<Integer, ButtonWidgetDelegate> entry : this.delegateMap.entrySet()) {
            value = entry.getValue();
            value.widget.method_25355(this.getMessageFromState(value.widget.field_22763 ? value.option.get() : false));
        }
    }

    private class_4185 addRenderableToggle(int pos, ConfigSpec.Accessor<Boolean> option) {
        return this.addRenderableToggle(pos, option, null);
    }

    private class_4185 addRenderableToggle(int pos, ConfigSpec.Accessor<Boolean> option, Supplier<Boolean> enableDelegate) {
        if (enableDelegate == null) {
            enableDelegate = () -> true;
        }
        class_4185 button = class_4185.method_46430((class_2561)this.getMessageFromState(option.get()), btn -> {
            option.set((Boolean)option.get() == false);
            this.pollDelegates();
        }).method_46433(this.centerX + 10, this.getOptionPosition(pos, false)).method_46437(100, 20).method_46431();
        this.scrollCorrectionList.add(scroll -> button.method_46419(this.getOptionPosition(pos, false) - scroll));
        this.method_37063((class_364)button);
        this.delegateMap.put(pos, new ButtonWidgetDelegate(pos, enableDelegate, button, option));
        return button;
    }

    private class_2561 getMessageFromState(boolean state) {
        return class_2561.method_43471((String)(state ? "gui.yes" : "gui.no")).method_10862(class_2583.field_24360.method_10977(state ? class_124.field_1077 : class_124.field_1079));
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float partialTicks) {
        this.activeTooltip = null;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.correctScroll();
        this.method_25420(ctx);
        class_5250 titleText = class_2561.method_43471((String)"config.ktnilcks.base.config_title");
        class_327 font = Core.mc().field_1772;
        ctx.method_51439(font, (class_2561)titleText, (this.field_22789 - font.method_1727(titleText.getString())) / 2, 20 - (int)this.scrollY, 0xF0F0F0, true);
        this.drawButtonPrefix(ctx, 0, "config.ktnilcks.section.versions", null);
        this.drawButtonPrefix(ctx, 1, "config.ktnilcks.notify.global.short", "config.ktnilcks.notify.global.long");
        this.drawButtonPrefix(ctx, 2, "config.ktnilcks.notify.chat.short", "config.ktnilcks.notify.chat.long");
        this.drawButtonPrefix(ctx, 4, "config.ktnilcks.section.actions", null);
        this.drawButtonPrefix(ctx, 5, "config.ktnilcks.action.bypassheld.short", "config.ktnilcks.action.bypassheld.long");
        this.drawButtonPrefix(ctx, 6, "config.ktnilcks.action.bypassoffhand.short", "config.ktnilcks.action.bypassoffhand.long");
        this.drawButtonPrefix(ctx, 7, "config.ktnilcks.action.bypassall.short", "config.ktnilcks.action.bypassall.long");
        this.drawButtonPrefix(ctx, 9, "config.ktnilcks.section.hotbar", null);
        this.drawButtonPrefix(ctx, 10, "config.ktnilcks.hotbar.visible.short", "config.ktnilcks.hotbar.visible.long");
        super.method_25394(ctx, mouseX, mouseY, partialTicks);
        if (this.activeTooltip != null) {
            List hoverTextLines = font.method_27527().method_27495((class_5348)this.activeTooltip, 134, class_2583.field_24360);
            ArrayList textLines = new ArrayList();
            for (class_5348 textLine : hoverTextLines) {
                textLine.method_27658((style, str) -> Optional.of(class_2561.method_43470((String)str).method_10862(style)), class_2583.field_24360).ifPresent(textLines::add);
            }
            this.method_47414(textLines.stream().map(p -> p.method_30937()).collect(Collectors.toList()));
        }
    }

    private void drawButtonPrefix(class_332 ctx, int index, String key, String hover) {
        class_2583 style = class_2583.field_24360.method_10977(class_124.field_1068);
        if (hover != null) {
            style = style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)hover).method_10862(class_2583.field_24360.method_10977(class_124.field_1060))));
        }
        this.drawButtonPrefix(ctx, (class_2561)class_2561.method_43471((String)key).method_10862(style), index, hover == null);
    }

    private void drawButtonPrefix(class_332 ctx, class_2561 text, int index, boolean isTitle) {
        block5: {
            block4: {
                class_327 font = Core.mc().field_1772;
                int textWidth = font.method_1727(text.getString());
                int x = this.centerX - (isTitle ? textWidth / 2 : textWidth + 10);
                int y = this.getOptionPosition(index, true) - (int)this.scrollY;
                ctx.method_51439(font, text, x, y, 0xF0F0F0, true);
                if (this.mouseX < x - 10 || this.mouseY < y - 10 || this.mouseX > x + textWidth + 10) break block4;
                Objects.requireNonNull(font);
                if (this.mouseY <= y + 9 + 10) break block5;
            }
            return;
        }
        class_2568 event = text.method_10866().method_10969();
        if (event != null && event.method_10892() == class_2568.class_5247.field_24342) {
            this.activeTooltip = (class_2561)event.method_10891(class_2568.class_5247.field_24342);
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (amount != 0.0) {
            this.scrollY -= 9.0 * amount;
            this.dirty = true;
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    public void method_25419() {
        if (this.previousMenu != null) {
            Core.mc().method_1507(this.previousMenu);
        } else {
            super.method_25419();
        }
    }

    private class ButtonWidgetDelegate {
        int id;
        Supplier<Boolean> delegate;
        class_4185 widget;
        ConfigSpec.Accessor<Boolean> option;

        public ButtonWidgetDelegate(int id, Supplier<Boolean> delegate, class_4185 widget, ConfigSpec.Accessor<Boolean> option) {
            this.id = id;
            this.delegate = delegate;
            this.widget = widget;
            this.option = option;
        }
    }
}

