/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.cable;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import org.apache.commons.lang3.mutable.MutableBoolean;
import owmii.powah.block.cable.CableTile;

class CableNet {
    private static final Map<class_1937, Map<class_2338, CableTile>> loadedCables = new WeakHashMap<class_1937, Map<class_2338, CableTile>>();
    List<CableTile> cableList;

    static void addCable(CableTile cable) {
        CableTile previousCable = loadedCables.computeIfAbsent(cable.method_10997(), l -> new HashMap()).put(cable.method_11016().method_10062(), cable);
        if (previousCable != null) {
            throw new RuntimeException("Cable added to position %s, but there was already one there?".formatted(cable.method_11016()));
        }
        CableNet.updateAdjacentCables(cable);
    }

    static void removeCable(CableTile cable) {
        Map<class_2338, CableTile> levelMap = loadedCables.get(cable.method_10997());
        if (levelMap.remove(cable.method_11016()) != cable) {
            throw new RuntimeException("Removed wrong cable from position %s".formatted(cable.method_11016()));
        }
        if (levelMap.size() == 0) {
            loadedCables.remove(cable.method_10997());
        }
        CableNet.updateAdjacentCables(cable);
    }

    static void updateAdjacentCables(CableTile cable) {
        Map<class_2338, CableTile> levelMap = loadedCables.get(cable.method_10997());
        if (levelMap == null) {
            return;
        }
        for (class_2350 direction : class_2350.values()) {
            class_2338 adjPos = cable.method_11016().method_10093(direction);
            CableTile adjCable = levelMap.get(adjPos);
            if (adjCable == null || adjCable.net == null) continue;
            adjCable.net.cableList.forEach(c -> {
                c.net = null;
            });
        }
    }

    static void calculateNetwork(CableTile cable) {
        Map<class_2338, CableTile> levelMap = Objects.requireNonNull(loadedCables.get(cable.method_10997()), "No level map?");
        LinkedHashSet<CableTile> cables = new LinkedHashSet<CableTile>();
        ArrayDeque<CableTile> queue = new ArrayDeque<CableTile>();
        cables.add(cable);
        queue.add(cable);
        while (!queue.isEmpty()) {
            CableTile cur = (CableTile)queue.pop();
            for (class_2350 direction : class_2350.values()) {
                class_2338 adjPos = cur.method_11016().method_10093(direction);
                CableTile adjCable = levelMap.get(adjPos);
                if (adjCable == null || !cables.add(adjCable)) continue;
                queue.add(adjCable);
            }
        }
        MutableBoolean insertionGuard = new MutableBoolean();
        CableNet net = new CableNet(new ArrayList<CableTile>(cables));
        for (CableTile tile : net.cableList) {
            tile.net = net;
            tile.netInsertionGuard = insertionGuard;
        }
    }

    CableNet(List<CableTile> cableList) {
        this.cableList = cableList;
    }
}

