/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.fabric.transfer;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.fabric.FluidStackHooksFabric;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import owmii.powah.lib.logistics.fluid.Tank;

public class TankWrapper
extends SnapshotParticipant<FluidStack>
implements SingleSlotStorage<FluidVariant> {
    private final Tank tank;

    public TankWrapper(Tank tank) {
        this.tank = tank;
    }

    public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
        FluidStack stack = FluidStackHooksFabric.fromFabric((FluidVariant)resource, (long)maxAmount);
        if (this.tank.fill(stack, true) > 0L) {
            this.updateSnapshots(transaction);
            this.tank.setSendUpdates(false);
            long filled = this.tank.fill(stack, false);
            this.tank.setSendUpdates(true);
            return filled;
        }
        return 0L;
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
        FluidStack stack = FluidStackHooksFabric.fromFabric((FluidVariant)resource, (long)maxAmount);
        if (!this.tank.drain(stack, true).isEmpty()) {
            this.updateSnapshots(transaction);
            this.tank.setSendUpdates(false);
            long drained = this.tank.drain(stack, false).getAmount();
            this.tank.setSendUpdates(true);
            return drained;
        }
        return 0L;
    }

    public boolean isResourceBlank() {
        return this.tank.getFluid().isEmpty();
    }

    public FluidVariant getResource() {
        return FluidStackHooksFabric.toFabric((FluidStack)this.tank.getFluid());
    }

    public long getAmount() {
        return this.tank.getFluidAmount();
    }

    public long getCapacity() {
        return this.tank.getCapacity();
    }

    protected FluidStack createSnapshot() {
        return this.tank.getFluid().copy();
    }

    protected void readSnapshot(FluidStack snapshot) {
        this.tank.setSendUpdates(false);
        this.tank.setFluid(snapshot);
        this.tank.setSendUpdates(true);
    }

    protected void onFinalCommit() {
        this.tank.onContentsChanged();
    }
}

