/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified;

import com.almostreliable.unified.AlmostUnifiedPlatform;
import com.almostreliable.unified.AlmostUnifiedRuntime;
import com.almostreliable.unified.api.StoneStrataHandler;
import com.almostreliable.unified.config.Config;
import com.almostreliable.unified.config.UnifyConfig;
import com.almostreliable.unified.utils.ReplacementMap;
import com.almostreliable.unified.utils.TagMap;
import com.almostreliable.unified.utils.TagOwnerships;
import com.almostreliable.unified.utils.UnifyTag;
import com.google.gson.JsonElement;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_2960;

public class AlmostUnifiedFallbackRuntime
implements AlmostUnifiedRuntime {
    @Nullable
    private static AlmostUnifiedFallbackRuntime INSTANCE;
    @Nullable
    private UnifyConfig unifyConfig;
    @Nullable
    private TagMap<class_1792> filteredTagMap;
    @Nullable
    private ReplacementMap replacementMap;

    public static AlmostUnifiedFallbackRuntime getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AlmostUnifiedFallbackRuntime();
            INSTANCE.reload();
        }
        return INSTANCE;
    }

    public void reload() {
        this.unifyConfig = null;
        this.filteredTagMap = null;
        this.replacementMap = null;
        this.build();
    }

    private void build() {
        this.unifyConfig = Config.load("unify", new UnifyConfig.Serializer());
        Set<UnifyTag<class_1792>> unifyTags = this.unifyConfig.bakeTags();
        this.filteredTagMap = TagMap.create(unifyTags).filtered($ -> true, this.unifyConfig::includeItem);
        StoneStrataHandler stoneStrataHandler = AlmostUnifiedFallbackRuntime.createStoneStrataHandler(this.unifyConfig);
        TagOwnerships tagOwnerships = new TagOwnerships(unifyTags, this.unifyConfig.getTagOwnerships());
        this.replacementMap = new ReplacementMap(this.unifyConfig, this.filteredTagMap, stoneStrataHandler, tagOwnerships);
    }

    private static StoneStrataHandler createStoneStrataHandler(UnifyConfig config) {
        Set<UnifyTag<class_1792>> stoneStrataTags = AlmostUnifiedPlatform.INSTANCE.getStoneStrataTags(config.getStoneStrata());
        TagMap<class_1792> stoneStrataTagMap = TagMap.create(stoneStrataTags);
        return StoneStrataHandler.create(config.getStoneStrata(), stoneStrataTags, stoneStrataTagMap);
    }

    @Override
    public void run(Map<class_2960, JsonElement> recipes, boolean skipClientTracking) {
    }

    @Override
    public Optional<TagMap<class_1792>> getFilteredTagMap() {
        return Optional.ofNullable(this.filteredTagMap);
    }

    @Override
    public Optional<ReplacementMap> getReplacementMap() {
        return Optional.ofNullable(this.replacementMap);
    }

    @Override
    public Optional<UnifyConfig> getUnifyConfig() {
        return Optional.ofNullable(this.unifyConfig);
    }
}

