/*
 * Decompiled with CFR 0.152.
 */
package com.dragonfight.config;

import com.dragonfight.DragonfightMod;
import com.dragonfight.config.CommonConfiguration;
import com.dragonfight.fight.DragonFightManagerCustom;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.class_1299;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class ConfigurationCache {
    public static void onConfigChanged() {
        DragonFightManagerCustom.spawnOnCrystalDeath = ConfigurationCache.parseEntityTypes(((CommonConfiguration)DragonfightMod.config.getCommonConfig()).spawnoncrystaldestroy);
        DragonFightManagerCustom.spawnOnCrystalRespawn = ConfigurationCache.parseEntityTypes(((CommonConfiguration)DragonfightMod.config.getCommonConfig()).spawnoncrystalrespawn);
        DragonFightManagerCustom.spawnOnDragonSitting = ConfigurationCache.parseEntityTypes(((CommonConfiguration)DragonfightMod.config.getCommonConfig()).spawnwhilelanded);
    }

    private static ImmutableList<EntitySpawnData> parseEntityTypes(List<String> data) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String entry : data) {
            String[] splitEntry;
            for (String entityString : splitEntry = entry.split(",")) {
                int nbtStart = entityString.indexOf("{");
                nbtStart = nbtStart == -1 ? entityString.length() : nbtStart;
                String typeString = entityString.substring(0, nbtStart);
                String nbtString = entityString.substring(nbtStart);
                class_2960 id = class_2960.method_12829((String)typeString);
                if (id == null) {
                    DragonfightMod.LOGGER.error("Config entry could not be parsed, not a valid resource location " + entityString);
                    continue;
                }
                class_1299 type = (class_1299)class_7923.field_41177.method_10223(id);
                if (type.equals(class_7923.field_41177.method_10223(class_7923.field_41177.method_10137()))) {
                    DragonfightMod.LOGGER.error("Config entry could not be parsed, not a valid entity type" + entityString);
                    continue;
                }
                class_2487 nbt = null;
                if (!nbtString.isEmpty()) {
                    try {
                        nbt = class_2522.method_10718((String)nbtString);
                    }
                    catch (Exception e) {
                        DragonfightMod.LOGGER.error("Config entry NBT data could not be parsed for " + entityString, (Throwable)e);
                    }
                }
                builder.add((Object)new EntitySpawnData(type, nbt));
            }
        }
        return builder.build();
    }

    public static class EntitySpawnData {
        public final class_1299 type;
        public final class_2487 nbt;

        public EntitySpawnData(class_1299 type, class_2487 nbt) {
            this.type = type;
            this.nbt = nbt;
        }
    }
}

