/*
 * Decompiled with CFR 0.152.
 */
package com.dragonfight.fight;

import com.cupboard.util.BlockSearch;
import com.dragonfight.DragonfightMod;
import com.dragonfight.config.CommonConfiguration;
import com.dragonfight.config.ConfigurationCache;
import com.dragonfight.fight.IDragonfightAccessor;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1322;
import net.minecraft.class_1510;
import net.minecraft.class_1511;
import net.minecraft.class_1515;
import net.minecraft.class_1521;
import net.minecraft.class_1527;
import net.minecraft.class_1538;
import net.minecraft.class_1560;
import net.minecraft.class_1588;
import net.minecraft.class_1655;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2881;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3310;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_4051;
import net.minecraft.class_5134;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_7923;

public class DragonFightManagerCustom {
    public static ImmutableList<ConfigurationCache.EntitySpawnData> spawnOnCrystalDeath = ImmutableList.of();
    public static ImmutableList<ConfigurationCache.EntitySpawnData> spawnOnCrystalRespawn = ImmutableList.of();
    public static ImmutableList<ConfigurationCache.EntitySpawnData> spawnOnDragonSitting = ImmutableList.of();
    private static final float CRYSTAL_RESPAWN_TIME = 8000.0f;
    private static final int LIGHTNING_DESTROY_RANGE = 100;
    private static final float ADD_TIMER = 2000.0f;
    private static class_2338 crystalRespawnPos = null;
    private static int crystalRespawnTimer = 0;
    private static class_1322 healthMod = new class_1322("savagedragonhealth", 200.0, class_1322.class_1323.field_6328);
    private static int timeSinceLastLanding = 0;
    private static boolean spawnAdds = false;
    private static final class_2338 spawnPos = new class_2338(0, 68, 0);
    private static int spawnCounter = 0;
    private static List<class_1560> meleeAdds = new ArrayList<class_1560>();
    private static int advancingLightningCurrent = 0;
    private static int advancingLightningStop = 0;
    private static int advancingExplosionCurrent = 0;
    private static int advancingExplosionStop = 0;
    private static class_1510 dragonEntity = null;
    public static boolean isFightRunning = true;
    public static class_1322 AA_GRAVITY_MOD = new class_1322("fall", 5.0, class_1322.class_1323.field_6328);
    public static Map<UUID, Integer> flyingPlayers = new HashMap<UUID, Integer>();

    public static void onCrystalDeath(class_1511 enderCrystalEntity, class_1282 damageSource) {
        class_1295 areaeffectcloudentity = new class_1295(enderCrystalEntity.method_37908(), enderCrystalEntity.method_23317(), enderCrystalEntity.method_23318(), enderCrystalEntity.method_23321());
        if (dragonEntity != null) {
            areaeffectcloudentity.method_5607((class_1309)dragonEntity);
        }
        DragonFightManagerCustom.notifyPlayer(enderCrystalEntity.method_37908(), "Crystal died from:" + damageSource);
        areaeffectcloudentity.method_5608((class_2394)class_2398.field_11216);
        areaeffectcloudentity.method_5603(1.0f);
        areaeffectcloudentity.method_5604((int)((double)(8000.0f / (float)DragonFightManagerCustom.getDifficulty()) * ((CommonConfiguration)DragonfightMod.config.getCommonConfig()).crystalRespawnTimeModifier));
        areaeffectcloudentity.method_5596((5.0f - areaeffectcloudentity.method_5599()) / (float)areaeffectcloudentity.method_5605());
        areaeffectcloudentity.method_5610(new class_1293(class_1294.field_5921, 100, 1));
        areaeffectcloudentity.method_5610(new class_1293(class_1294.field_5919, 100, 1));
        areaeffectcloudentity.method_5610(new class_1293(class_1294.field_5909, 100, 1));
        enderCrystalEntity.method_37908().method_8649((class_1297)areaeffectcloudentity);
        if (!(damageSource.method_5529() instanceof class_1657)) {
            return;
        }
        if (damageSource.method_5529().method_24515().method_10262((class_2382)enderCrystalEntity.method_24515()) > 100.0) {
            if (!((CommonConfiguration)DragonfightMod.config.getCommonConfig()).disableLightning) {
                class_1538 lightningboltentity = (class_1538)DragonFightManagerCustom.spawnEntity((class_3218)enderCrystalEntity.method_37908(), new ConfigurationCache.EntitySpawnData(class_1299.field_6112, null), damageSource.method_5529().method_19538());
                lightningboltentity.method_29498(false);
            }
            if (!spawnOnCrystalDeath.isEmpty()) {
                for (int i = 0; i < Math.max(1, DragonFightManagerCustom.getDifficulty() / 4); ++i) {
                    class_1309 entity;
                    class_2338 searchedPos = BlockSearch.findAround((class_3218)((class_3218)enderCrystalEntity.method_37908()), (class_2338)damageSource.method_5529().method_24515().method_10069(i + 1, 5, i + 1), (int)15, (int)15, (int)1, (level, checkPos) -> level.method_8320(checkPos).method_26215() && level.method_8320(checkPos.method_10084()).method_26215());
                    if (searchedPos == null) {
                        searchedPos = damageSource.method_5529().method_24515();
                    }
                    if (!((entity = (class_1309)DragonFightManagerCustom.spawnEntity((class_3218)enderCrystalEntity.method_37908(), (ConfigurationCache.EntitySpawnData)spawnOnCrystalDeath.get(DragonfightMod.rand.nextInt(spawnOnCrystalDeath.size())), DragonFightManagerCustom.createVec3(searchedPos))) instanceof class_1308)) continue;
                    ((class_1308)entity).method_5980((class_1309)damageSource.method_5529());
                }
            }
        } else if (dragonEntity != null && dragonEntity.method_6032() > 100.0f) {
            dragonEntity.method_6033(dragonEntity.method_6032() * 0.9f);
            float f = (DragonfightMod.rand.nextFloat() - 0.5f) * 8.0f;
            float f1 = (DragonfightMod.rand.nextFloat() - 0.5f) * 4.0f;
            float f2 = (DragonfightMod.rand.nextFloat() - 0.5f) * 8.0f;
            dragonEntity.method_37908().method_8406((class_2394)class_2398.field_11221, dragonEntity.method_23317() + (double)f, dragonEntity.method_23318() + 2.0 + (double)f1, dragonEntity.method_23321() + (double)f2, 0.0, 0.0, 0.0);
        }
    }

    public static void onWorldTick(class_1937 world) {
        class_2881 manager = ((class_3218)world).method_29198();
        if (manager == null || ((IDragonfightAccessor)manager).getDragonEvent().method_14092().isEmpty() || dragonEntity == null) {
            DragonFightManagerCustom.reset();
            return;
        }
        if (crystalRespawnPos != null) {
            if (--crystalRespawnTimer > 0) {
                if (crystalRespawnTimer == 200) {
                    DragonFightManagerCustom.spawnLightningAtCircle(crystalRespawnPos, 8, world);
                }
            } else {
                DragonFightManagerCustom.notifyPlayer(world, "Respawning crystal at" + crystalRespawnPos);
                DragonFightManagerCustom.respawnCrystalAt(crystalRespawnPos, world);
            }
        }
        if (dragonEntity.method_6032() < dragonEntity.method_6063() && dragonEntity.method_5805()) {
            if (!isFightRunning && !((IDragonfightAccessor)manager).getDragonEvent().method_14092().isEmpty()) {
                List monsterEntities = world.method_18467(class_1588.class, dragonEntity.method_5829().method_1014(150.0));
                for (class_1588 entity : monsterEntities) {
                    if (entity instanceof class_1655 || entity.method_5947()) continue;
                    entity.method_5650(class_1297.class_5529.field_26999);
                }
                isFightRunning = true;
                float pct = dragonEntity.method_6032() / dragonEntity.method_6063();
                if (dragonEntity.method_5996(class_5134.field_23716).method_6196(healthMod)) {
                    dragonEntity.method_5996(class_5134.field_23716).method_6202(healthMod);
                }
                healthMod = new class_1322("savagehealth", (double)(200 + 50 * ((CommonConfiguration)DragonfightMod.config.getCommonConfig()).dragonDifficulty), class_1322.class_1323.field_6328);
                dragonEntity.method_5996(class_5134.field_23716).method_26835(healthMod);
                dragonEntity.method_6033(dragonEntity.method_6063() * pct);
            }
        } else {
            if (isFightRunning) {
                DragonFightManagerCustom.reset();
            }
            isFightRunning = false;
        }
        if (!isFightRunning) {
            return;
        }
        if (dragonEntity.method_6831().method_6864() instanceof class_1515 && dragonEntity.method_6831().method_6864().method_6851() != null && dragonEntity.method_6831().method_6864().method_6851().method_1028((double)dragonEntity.method_24515().method_10263(), (double)dragonEntity.method_24515().method_10264(), dragonEntity.method_23321()) < 10.0) {
            dragonEntity.method_6033(0.0f);
        }
        if (++timeSinceLastLanding > 2400 && dragonEntity != null) {
            timeSinceLastLanding = 0;
            dragonEntity.method_6831().method_6863(class_1527.field_7071);
            DragonFightManagerCustom.notifyPlayer(world, "Forcing landing phase");
        }
        if ((double)dragonEntity.method_6032() > (double)dragonEntity.method_6063() * 0.9) {
            return;
        }
        for (class_1657 player : ((IDragonfightAccessor)manager).getDragonEvent().method_14092()) {
            int time = flyingPlayers.computeIfAbsent(player.method_5667(), s -> 0);
            if (DragonFightManagerCustom.isFlying(player)) {
                if (time == 300) {
                    flyingPlayers.put(player.method_5667(), ++time);
                    continue;
                }
                if (time > 400) {
                    player.method_5643(dragonEntity.method_48923().method_48827(), player.method_6063() * 0.9f);
                    player.method_6033(1.0f);
                    flyingPlayers.put(player.method_5667(), 0);
                    continue;
                }
                flyingPlayers.put(player.method_5667(), ++time);
                continue;
            }
            if (time > 300) {
                player.method_5643(dragonEntity.method_48923().method_48827(), player.method_6063() * 0.9f);
                player.method_6033(1.0f);
            }
            flyingPlayers.put(player.method_5667(), 0);
        }
        if (advancingLightningCurrent > 0 && world.method_8510() % 100L == 0L) {
            DragonFightManagerCustom.spawnLightningAtCircle(spawnPos, advancingLightningCurrent += 3, world);
            if (advancingLightningCurrent > advancingLightningStop) {
                advancingLightningCurrent = 0;
                advancingLightningStop = 0;
            }
        }
        if (dragonEntity != null && advancingExplosionCurrent == 0 && advancingLightningCurrent == 0) {
            double d = dragonEntity.method_6032() / dragonEntity.method_6063();
            double d2 = ((CommonConfiguration)DragonfightMod.config.getCommonConfig()).disableLightning ? 0.5 : 0.2;
            if (d < d2) {
                advancingExplosionCurrent = 8;
                advancingExplosionStop = 50;
            }
        }
        if (advancingExplosionCurrent > 0 && world.method_8510() % 200L == 0L) {
            DragonFightManagerCustom.explodeInCircleAround(spawnPos, advancingExplosionCurrent += 3, world);
            if (advancingExplosionCurrent > advancingExplosionStop) {
                advancingExplosionCurrent = 0;
                advancingExplosionStop = 0;
            }
        }
        if (spawnAdds) {
            int n = spawnCounter++;
            if ((float)n > 2000.0f / (float)DragonFightManagerCustom.getDifficulty()) {
                DragonFightManagerCustom.notifyPlayer(world, "Spawning melee add");
                DragonFightManagerCustom.spawnMeleeAdds(world);
                spawnCounter = 0;
            }
        }
    }

    private static boolean isFlying(class_1657 player) {
        return player != null && (player.field_6007 || !player.method_24828()) && player.field_6017 <= 0.1f && player.method_37908().method_22347(player.method_24515().method_10087(2));
    }

    private static void reset() {
        crystalRespawnPos = null;
        spawnAdds = false;
        spawnCounter = 0;
        if (DragonfightMod.server == null) {
            return;
        }
        for (class_1560 endermanEntity : meleeAdds) {
            endermanEntity.method_5650(class_1297.class_5529.field_26999);
        }
        isFightRunning = false;
        flyingPlayers.clear();
        meleeAdds.clear();
    }

    private static void spawnMeleeAdds(class_1937 world) {
        class_1309 entity;
        List closesPlayers;
        meleeAdds.removeIf(endermanEntity -> endermanEntity.method_31481());
        if (meleeAdds.size() >= DragonFightManagerCustom.getDifficulty()) {
            return;
        }
        if (spawnOnDragonSitting.isEmpty()) {
            return;
        }
        class_2338 searchedPos = BlockSearch.findAround((class_3218)((class_3218)world), (class_2338)spawnPos, (int)30, (int)30, (int)1, (level, checkPos) -> level.method_8320(checkPos).method_26215() && level.method_8320(checkPos.method_10084()).method_26215() && level.method_8320(checkPos.method_10074()).method_51367());
        if (searchedPos == null) {
            searchedPos = spawnPos;
        }
        if (!(closesPlayers = world.method_18464(class_4051.field_18092, entity = (class_1309)DragonFightManagerCustom.spawnEntity((class_3218)world, (ConfigurationCache.EntitySpawnData)spawnOnDragonSitting.get(DragonfightMod.rand.nextInt(spawnOnDragonSitting.size())), DragonFightManagerCustom.createVec3(searchedPos)), entity.method_5829().method_1014(20.0))).isEmpty()) {
            class_1657 closestPlayer = (class_1657)closesPlayers.get(DragonfightMod.rand.nextInt(closesPlayers.size()));
            if (entity instanceof class_1308) {
                ((class_1308)entity).method_5980((class_1309)closestPlayer);
            }
        } else {
            List farPlayers = world.method_18464(class_4051.field_18092, entity, entity.method_5829().method_1009(60.0, 120.0, 60.0));
            if (!farPlayers.isEmpty()) {
                class_1657 closestPlayer = (class_1657)farPlayers.get(DragonfightMod.rand.nextInt(farPlayers.size()));
                if (entity instanceof class_1308) {
                    ((class_1308)entity).method_5980((class_1309)closestPlayer);
                }
            }
        }
    }

    private static void respawnCrystalAt(class_2338 pos, class_1937 world) {
        if (world.method_18467(class_1511.class, new class_238(pos).method_1014(2.0)).isEmpty()) {
            class_1511 crystal = (class_1511)DragonFightManagerCustom.spawnEntity((class_3218)world, new ConfigurationCache.EntitySpawnData(class_1299.field_6110, null), DragonFightManagerCustom.createVec3(pos));
            class_243 spawnPos = DragonFightManagerCustom.createVec3(new class_2338((int)((double)pos.method_10263() * 0.8), pos.method_10264(), (int)((double)pos.method_10260() * 0.8)));
            for (int i = 0; i < Math.max(1, DragonFightManagerCustom.getDifficulty() / 3) && !spawnOnCrystalRespawn.isEmpty(); ++i) {
                class_1309 entity = (class_1309)DragonFightManagerCustom.spawnEntity((class_3218)world, (ConfigurationCache.EntitySpawnData)spawnOnCrystalRespawn.get(DragonfightMod.rand.nextInt(spawnOnCrystalRespawn.size())), spawnPos);
                if (!(entity instanceof class_1308)) continue;
                ((class_1308)entity).method_5980((class_1309)world.method_18460((class_1297)entity, 100.0));
            }
            float f = (DragonfightMod.rand.nextFloat() - 0.5f) * 8.0f;
            float f1 = (DragonfightMod.rand.nextFloat() - 0.5f) * 4.0f;
            float f2 = (DragonfightMod.rand.nextFloat() - 0.5f) * 8.0f;
            world.method_8406((class_2394)class_2398.field_11221, crystal.method_23317() + (double)f, crystal.method_23318() + 2.0 + (double)f1, crystal.method_23321() + (double)f2, 0.0, 0.0, 0.0);
        }
        crystalRespawnPos = null;
        DragonFightManagerCustom.checkCrystalsToRespawn(world);
    }

    public static void onDragonHeal(class_1510 dragonEntity) {
        dragonEntity.method_6033(Math.min(dragonEntity.method_6063(), dragonEntity.method_6032() + (float)DragonFightManagerCustom.getDifficulty() / 5.0f));
    }

    public static float onAttackPlayer(float damage) {
        return damage + (float)(DragonFightManagerCustom.getDifficulty() / 2);
    }

    public static void onPhaseChange(class_1527<?> newPhase, class_1527<? extends class_1521> oldphase, class_1510 dragon) {
        if (dragonEntity != dragon) {
            dragonEntity = dragon;
            return;
        }
        if (dragon == null || !(dragon.method_37908() instanceof class_3218) || !dragonEntity.method_5805()) {
            return;
        }
        class_2881 manager = ((class_3218)dragon.method_37908()).method_29198();
        if (manager == null || ((IDragonfightAccessor)manager).getDragonEvent().method_14092().isEmpty()) {
            return;
        }
        DragonFightManagerCustom.notifyPlayer(dragon.method_37908(), "Next phase:" + newPhase.toString());
        if (newPhase == class_1527.field_7077) {
            spawnAdds = true;
            DragonFightManagerCustom.checkCrystalsToRespawn(dragon.method_37908());
            if ((double)(dragon.method_6032() / dragon.method_6063()) < 0.25 && dragon.method_6829() != null) {
                dragon.method_37908().method_8486(dragon.method_23317(), dragon.method_23318(), dragon.method_23321(), class_3417.field_14671, dragon.method_5634(), 2.5f, 0.8f + DragonfightMod.rand.nextFloat() * 0.3f, false);
                for (class_1657 playerEntity : ((IDragonfightAccessor)dragon.method_6829()).getDragonEvent().method_14092()) {
                    playerEntity.method_6092(new class_1293(class_1294.field_5920, 100, DragonFightManagerCustom.getDifficulty() / 3));
                    if (!((double)(dragon.method_6032() / dragon.method_6063()) < 0.1)) continue;
                    playerEntity.method_6092(new class_1293(class_1294.field_5902, 200, 1));
                }
            }
        }
        if (newPhase == class_1527.field_7071 || newPhase == class_1527.field_7068) {
            timeSinceLastLanding = 0;
            spawnAdds = false;
        }
        if (oldphase == class_1527.field_7067 && newPhase == class_1527.field_7081) {
            timeSinceLastLanding = 0;
            double healthpercent = dragon.method_6032() / dragon.method_6063();
            if (healthpercent < 0.5) {
                advancingLightningCurrent = 6;
                advancingLightningStop = 50;
            } else {
                DragonFightManagerCustom.spawnLightningAtCircle(spawnPos, DragonfightMod.rand.nextInt(16) + 8, dragon.method_37908());
            }
        }
    }

    private static void checkCrystalsToRespawn(class_1937 world) {
        if (crystalRespawnPos != null) {
            return;
        }
        List spikes = class_3310.method_14506((class_5281)((class_3218)world));
        Collections.shuffle(spikes, DragonfightMod.rand);
        for (class_3310.class_3181 spike : spikes) {
            class_2338 pos = new class_2338(spike.method_13966(), spike.method_13964(), spike.method_13967());
            int addHeight = 0;
            for (int i = 0; i < 50 && (!world.method_8320(pos.method_10069(0, i, 0)).method_26215() || world.method_8320(pos.method_10069(0, i - 1, 0)).method_26215()); ++i) {
                ++addHeight;
            }
            pos = pos.method_10069(0, addHeight, 0);
            if (!world.method_18467(class_1511.class, spike.method_13968().method_989(0.0, (double)addHeight, 0.0).method_1014(5.0)).isEmpty()) continue;
            crystalRespawnPos = pos;
            crystalRespawnTimer = (int)Math.max(400.0, (double)(8000.0f / (float)DragonFightManagerCustom.getDifficulty()) * ((CommonConfiguration)DragonfightMod.config.getCommonConfig()).crystalRespawnTimeModifier);
            DragonFightManagerCustom.notifyPlayer(world, "Adding respawn at :" + crystalRespawnPos + " in:" + crystalRespawnTimer);
            break;
        }
    }

    private static void spawnLightningAtCircle(class_2338 midPoint, int radius, class_1937 world) {
        if (((CommonConfiguration)DragonfightMod.config.getCommonConfig()).disableLightning) {
            return;
        }
        Set<class_2338> lightningPositions = DragonFightManagerCustom.getCircularPositionsAround(midPoint, radius, 15 - radius / 10);
        for (class_2338 lightningPos : lightningPositions) {
            DragonFightManagerCustom.notifyPlayer(world, "spawning plightning at!" + new class_2338(lightningPos.method_10263(), world.method_8598(class_2902.class_2903.field_13202, lightningPos).method_10264(), lightningPos.method_10260()));
            int yLevel = world.method_8598(class_2902.class_2903.field_13202, lightningPos).method_10264();
            if (Math.abs(midPoint.method_10264() - yLevel) > 20) continue;
            class_1538 lightningboltentity = (class_1538)class_1299.field_6112.method_5883(world);
            lightningboltentity.method_24203((double)lightningPos.method_10263(), (double)yLevel, (double)lightningPos.method_10260());
            lightningboltentity.method_29498(false);
            world.method_8649((class_1297)lightningboltentity);
        }
    }

    private static void explodeInCircleAround(class_2338 midPoint, int radius, class_1937 world) {
        Set<class_2338> explodePos = DragonFightManagerCustom.getCircularPositionsAround(midPoint, radius, 15);
        for (class_2338 lightningPos : explodePos) {
            DragonFightManagerCustom.notifyPlayer(world, "spawning explosion at!" + new class_2338(lightningPos.method_10263(), world.method_8598(class_2902.class_2903.field_13202, lightningPos).method_10264(), lightningPos.method_10260()));
            int yLevel = world.method_8598(class_2902.class_2903.field_13202, lightningPos).method_10264();
            if (Math.abs(midPoint.method_10264() - yLevel) > 20) continue;
            world.method_8537((class_1297)dragonEntity, (double)lightningPos.method_10263(), (double)lightningPos.method_10264(), (double)lightningPos.method_10260(), 1.0f + (float)DragonFightManagerCustom.getDifficulty() / 4.0f, false, class_1937.class_7867.field_40888);
        }
    }

    private static Set<class_2338> getCircularPositionsAround(class_2338 start, int radius, int precision) {
        int randomOffset;
        HashSet<class_2338> positions = new HashSet<class_2338>();
        precision = (int)((double)precision / ((CommonConfiguration)DragonfightMod.config.getCommonConfig()).lightningExplosionDensity);
        for (int i = randomOffset = DragonfightMod.rand.nextInt(40); i < 360 + randomOffset; i += precision) {
            int x = (int)Math.round((double)radius * Math.cos(Math.toRadians(i)));
            int z = (int)Math.round((double)radius * Math.sin(Math.toRadians(i)));
            positions.add(start.method_10069(x, 0, z));
        }
        return positions;
    }

    public static void notifyPlayer(class_1937 world, String message) {
        if (((CommonConfiguration)DragonfightMod.config.getCommonConfig()).printDragonPhases) {
            for (class_1657 player : ((class_3218)world).method_18456()) {
                if (world.method_8503() == null || ((class_3218)world).method_8503().method_3835(player.method_7334()) <= 0) continue;
                player.method_43496((class_2561)class_2561.method_43470((String)message));
            }
        }
    }

    private static int getDifficulty() {
        int difficulty = ((CommonConfiguration)DragonfightMod.config.getCommonConfig()).dragonDifficulty;
        if (dragonEntity != null) {
            difficulty += dragonEntity.method_37908().method_8407().method_5461();
            if (dragonEntity.method_6829() != null) {
                difficulty += ((IDragonfightAccessor)dragonEntity.method_6829()).getDragonEvent().method_14092().size();
            }
        }
        return Math.max(difficulty, 1);
    }

    private static class_243 createVec3(class_2338 pos) {
        return new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
    }

    private static class_1297 spawnEntity(class_3218 world, ConfigurationCache.EntitySpawnData spawnData, class_243 pos) {
        class_2487 compoundtag = new class_2487();
        if (spawnData.nbt != null) {
            compoundtag = spawnData.nbt.method_10553();
        }
        compoundtag.method_10582("id", class_7923.field_41177.method_10221((Object)spawnData.type).toString());
        class_1297 entity = class_1299.method_17842((class_2487)compoundtag, (class_1937)world, p_138828_ -> {
            double offset = pos.field_1352 % 1.0 != 0.0 || pos.field_1350 % 1.0 != 0.0 ? 0.0 : 0.5;
            p_138828_.method_5808(pos.field_1352 + offset, pos.field_1351, pos.field_1350 + offset, p_138828_.method_36454(), p_138828_.method_36455());
            return p_138828_;
        });
        if (entity == null) {
            return null;
        }
        entity.method_5826(UUID.randomUUID());
        if (entity instanceof class_1308) {
            ((class_1308)entity).method_5943((class_5425)world, world.method_8404(entity.method_24515()), class_3730.field_16462, (class_1315)null, (class_2487)null);
        }
        world.method_8649(entity);
        return entity;
    }
}

