/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.common.entity;

import com.starfish_studios.naturalist.common.entity.core.EggLayingAnimal;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.BabyHurtByTargetGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.BabyPanicGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.CloseMeleeAttackGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.EggLayingBreedGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.LayEggGoal;
import com.starfish_studios.naturalist.core.registry.NaturalistBlocks;
import com.starfish_studios.naturalist.core.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.core.registry.NaturalistSoundEvents;
import com.starfish_studios.naturalist.core.registry.NaturalistTags;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1378;
import net.minecraft.class_1400;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3481;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Alligator
extends class_1429
implements GeoEntity,
EggLayingAnimal {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final class_1856 FOOD_ITEMS = class_1856.method_8106(NaturalistTags.ItemTags.ALLIGATOR_FOOD_ITEMS);
    private static final class_2940<Boolean> HAS_EGG = class_2945.method_12791(Alligator.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> LAYING_EGG = class_2945.method_12791(Alligator.class, (class_2941)class_2943.field_13323);
    int layEggCounter;
    boolean isDigging;

    public Alligator(class_1299<? extends class_1429> entityType, class_1937 level) {
        super(entityType, level);
        this.method_5941(class_7.field_18, 0.0f);
        this.method_49477(1.0f);
    }

    public static boolean checkAlligatorSpawnRules(class_1299<? extends Alligator> type, class_1936 level, class_3730 spawnType, class_2338 pos, class_5819 random) {
        return level.method_8320(pos.method_10074()).method_26164(class_3481.field_38928) && level.method_22335(pos, 0) > 8;
    }

    @javax.annotation.Nullable
    protected class_3414 method_6011(class_1282 pDamageSource) {
        return this.method_6109() ? NaturalistSoundEvents.GATOR_AMBIENT_BABY.get() : NaturalistSoundEvents.GATOR_HURT.get();
    }

    @javax.annotation.Nullable
    protected class_3414 method_6002() {
        return this.method_6109() ? NaturalistSoundEvents.GATOR_AMBIENT_BABY.get() : NaturalistSoundEvents.GATOR_DEATH.get();
    }

    public float method_6017() {
        return this.method_6109() ? super.method_6017() * 0.65f : super.method_6017();
    }

    @javax.annotation.Nullable
    protected class_3414 method_5994() {
        return this.method_6109() ? NaturalistSoundEvents.GATOR_AMBIENT_BABY.get() : NaturalistSoundEvents.GATOR_AMBIENT.get();
    }

    @Nullable
    public class_1296 method_5613(@NotNull class_3218 level, @NotNull class_1296 otherParent) {
        return (class_1296)NaturalistEntityTypes.ALLIGATOR.get().method_5883((class_1937)level);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23719, 0.2).method_26868(class_5134.field_23716, 30.0).method_26868(class_5134.field_23721, 6.0).method_26868(class_5134.field_23718, 0.6);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, new EggLayingBreedGoal<Alligator>(this, 1.0));
        this.field_6201.method_6277(1, new LayEggGoal<Alligator>(this, 1.0));
        this.field_6201.method_6277(2, (class_1352)new CloseMeleeAttackGoal((class_1314)this, 1.0, true));
        this.field_6201.method_6277(3, (class_1352)new BabyPanicGoal((class_1314)this, 1.25));
        this.field_6201.method_6277(4, (class_1352)new class_1353((class_1429)this, 1.2));
        this.field_6201.method_6277(5, (class_1352)new class_1378((class_1314)this, 1.0, 10));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new BabyHurtByTargetGoal((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, 10, true, false, entity -> !this.method_6109() && entity.method_5799()));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1309.class, 10, true, false, entity -> {
            if (entity instanceof Alligator) {
                return false;
            }
            Iterable list = class_2338.method_10097((class_2338)entity.method_24515().method_10069(-2, -2, -2), (class_2338)entity.method_24515().method_10069(2, 2, 2));
            boolean isEntityNearAlligatorEggs = false;
            for (class_2338 pos : list) {
                if (!this.method_37908().method_8320(pos).method_27852(NaturalistBlocks.ALLIGATOR_EGG.get())) continue;
                isEntityNearAlligatorEggs = true;
                break;
            }
            return !this.method_6109() && isEntityNearAlligatorEggs;
        }));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1309.class, 10, true, false, entity -> !this.method_6109() && entity.method_5864().method_20210(NaturalistTags.EntityTypes.ALLIGATOR_HOSTILES)));
    }

    public boolean method_6481(@NotNull class_1799 stack) {
        return FOOD_ITEMS.method_8093(stack);
    }

    protected float method_6120() {
        return 0.98f;
    }

    public int method_5986() {
        return 40;
    }

    public boolean method_6094() {
        return true;
    }

    @Override
    public boolean hasEgg() {
        return (Boolean)this.field_6011.method_12789(HAS_EGG);
    }

    @Override
    public void setHasEgg(boolean hasEgg) {
        this.field_6011.method_12778(HAS_EGG, (Object)hasEgg);
    }

    @Override
    public class_2248 getEggBlock() {
        return NaturalistBlocks.ALLIGATOR_EGG.get();
    }

    @Override
    public class_6862<class_2248> getEggLayableBlockTag() {
        return NaturalistTags.BlockTags.ALLIGATOR_EGG_LAYABLE_ON;
    }

    @Override
    public boolean isLayingEgg() {
        return (Boolean)this.field_6011.method_12789(LAYING_EGG);
    }

    @Override
    public void setLayingEgg(boolean isLayingEgg) {
        this.layEggCounter = isLayingEgg ? 1 : 0;
        this.field_6011.method_12778(LAYING_EGG, (Object)isLayingEgg);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(HAS_EGG, (Object)false);
        this.field_6011.method_12784(LAYING_EGG, (Object)false);
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("HasEgg", this.hasEgg());
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setHasEgg(compound.method_10577("HasEgg"));
    }

    @Override
    public int getLayEggCounter() {
        return this.layEggCounter;
    }

    @Override
    public void setLayEggCounter(int layEggCounter) {
        this.layEggCounter = layEggCounter;
    }

    public boolean method_6482() {
        return super.method_6482() && !this.hasEgg();
    }

    public void method_6007() {
        super.method_6007();
        class_2338 pos = this.method_24515();
        if (this.method_5805() && this.isLayingEgg() && this.layEggCounter >= 1 && this.layEggCounter % 5 == 0 && this.method_37908().method_8320(pos.method_10074()).method_26164(this.getEggLayableBlockTag())) {
            this.method_37908().method_20290(2001, pos, class_2248.method_9507((class_2680)this.method_37908().method_8320(pos.method_10074())));
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    protected <E extends Alligator> PlayState predicate(AnimationState<E> event) {
        if (this.method_18798().method_37268() > 1.0E-6) {
            if (this.method_5799()) {
                event.getController().setAnimation(RawAnimation.begin().thenLoop("swim"));
            } else {
                event.getController().setAnimation(RawAnimation.begin().thenLoop("walk"));
                if (this.method_6109()) {
                    event.getController().setAnimationSpeed(1.7);
                }
                event.getController().setAnimationSpeed(1.5);
            }
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("idle"));
            event.getController().setAnimationSpeed(0.6);
        }
        return PlayState.CONTINUE;
    }

    protected <E extends Alligator> PlayState attackPredicate(AnimationState<E> event) {
        if (this.field_6252 && event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("bite"));
            event.getController().forceAnimationReset();
            this.field_6252 = false;
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 2, this::attackPredicate)});
    }
}

