/*
 * Decompiled with CFR 0.152.
 */
package elocindev.customitemattributes.builder;

import com.google.common.collect.Multimap;
import elocindev.customitemattributes.CustomItemAttributes;
import elocindev.customitemattributes.api.GenericAttribute;
import elocindev.customitemattributes.api.ItemProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.fabricmc.fabric.api.item.v1.ModifyItemAttributeModifiersCallback;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_2487;

public class AttributeBuilderCallback {
    public static void register() {
        ModifyItemAttributeModifiersCallback.EVENT.register((stack, slot, builder) -> {
            for (ItemProperty item : CustomItemAttributes.CONFIG.items) {
                if (item.getItem() != stack.method_7909()) continue;
                class_2487 nbt = stack.method_7969();
                if (nbt != null && nbt.method_10577("Unbreakable") != item.unbreakable) {
                    nbt.method_10556("Unbreakable", item.unbreakable);
                    stack.method_7953(nbt);
                }
                switch (slot) {
                    case field_6173: {
                        AttributeBuilderCallback.applyModifiers(stack, item, item.overrides_main_hand, (Multimap<class_1320, class_1322>)builder);
                        break;
                    }
                    case field_6171: {
                        AttributeBuilderCallback.applyModifiers(stack, item, item.overrides_off_hand, (Multimap<class_1320, class_1322>)builder);
                        break;
                    }
                    case field_6169: {
                        AttributeBuilderCallback.applyModifiers(stack, item, item.overrides_head, (Multimap<class_1320, class_1322>)builder);
                        break;
                    }
                    case field_6174: {
                        AttributeBuilderCallback.applyModifiers(stack, item, item.overrides_chest, (Multimap<class_1320, class_1322>)builder);
                        break;
                    }
                    case field_6172: {
                        AttributeBuilderCallback.applyModifiers(stack, item, item.overrides_legs, (Multimap<class_1320, class_1322>)builder);
                        break;
                    }
                    case field_6166: {
                        AttributeBuilderCallback.applyModifiers(stack, item, item.overrides_feet, (Multimap<class_1320, class_1322>)builder);
                    }
                }
            }
        });
    }

    public static void applyModifiers(class_1799 stack, ItemProperty property, List<GenericAttribute<String, ?>> attributes, Multimap<class_1320, class_1322> builder) {
        for (GenericAttribute<String, ?> generic_attribute : attributes) {
            try {
                class_1320 attribute = generic_attribute.getAttribute();
                ArrayList<class_1322> newModifiers = new ArrayList<class_1322>();
                newModifiers.add(new class_1322(UUID.nameUUIDFromBytes(generic_attribute.getString().getBytes()), "Custom Item Attributes Modifier", generic_attribute.getDouble(), generic_attribute.getOperation()));
                if (builder.containsValue((Object)attribute)) {
                    builder.replaceValues((Object)attribute, newModifiers);
                    continue;
                }
                builder.putAll((Object)attribute, newModifiers);
            }
            catch (Exception e) {
                CustomItemAttributes.LOGGER.error("Error adding attribute modifier: " + e.getMessage());
            }
        }
    }
}

