/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.entity;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_5558;
import net.satisfy.brewery.Brewery;
import net.satisfy.brewery.block.brew_event.BrewEvent;
import net.satisfy.brewery.block.brew_event.BrewEvents;
import net.satisfy.brewery.block.brew_event.BrewHelper;
import net.satisfy.brewery.block.property.BrewMaterial;
import net.satisfy.brewery.block.property.Heat;
import net.satisfy.brewery.block.property.Liquid;
import net.satisfy.brewery.entity.BeerElementalEntity;
import net.satisfy.brewery.item.DrinkBlockItem;
import net.satisfy.brewery.recipe.BrewingRecipe;
import net.satisfy.brewery.registry.BlockEntityRegistry;
import net.satisfy.brewery.registry.BlockStateRegistry;
import net.satisfy.brewery.registry.EntityRegistry;
import net.satisfy.brewery.registry.ObjectRegistry;
import net.satisfy.brewery.registry.RecipeTypeRegistry;
import net.satisfy.brewery.registry.SoundEventRegistry;
import net.satisfy.brewery.util.BreweryMath;
import net.satisfy.brewery.util.BreweryUtil;
import net.satisfy.brewery.util.ImplementedInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrewstationBlockEntity
extends class_2586
implements ImplementedInventory,
class_5558<BrewstationBlockEntity> {
    @NotNull
    private Set<class_2338> components = new HashSet<class_2338>(4);
    private static final int MAX_BREW_TIME = 1200;
    private static final int MIN_TIME_FOR_EVENT = 100;
    private static final int MAX_TIME_FOR_EVENT = 300;
    private static final int SOUND_DURATION = 60;
    private int soundTime;
    private int brewTime;
    private int timeToNextEvent = Integer.MIN_VALUE;
    private final Set<BrewEvent> runningEvents = new HashSet<BrewEvent>();
    private int solved;
    private int totalEvents;
    private class_2371<class_1799> ingredients;
    private class_1799 beer = class_1799.field_8037;
    private final class_3414 spawnEntitySound = (class_3414)SoundEventRegistry.BREWSTATION_PROCESS_FAILED.get();

    public BrewstationBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)BlockEntityRegistry.BREWINGSTATION_BLOCK_ENTITY.get(), blockPos, blockState);
        this.ingredients = class_2371.method_10213((int)3, (Object)class_1799.field_8037);
    }

    public void updateInClientWorld() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            serverLevel.method_14178().method_14128(this.method_11016());
        }
    }

    public void setComponents(class_2338 ... components) {
        if (components.length != 4) {
            Brewery.LOGGER.debug("Cant add components to BrewingStation. Should have 4 but only have {} parts.", (Object)components.length);
            return;
        }
        this.components.addAll(Arrays.asList(components));
    }

    public class_1269 addIngredient(class_1799 itemStack) {
        for (int i = 0; i < 3; ++i) {
            class_1799 stack = (class_1799)this.ingredients.get(i);
            if (!stack.method_7960()) continue;
            this.method_5447(i, itemStack.method_7971(1));
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    @Nullable
    public class_1799 getBeer() {
        if (this.beer.method_7960()) {
            return null;
        }
        class_1799 beerStack = this.beer.method_7972();
        beerStack.method_7939(1);
        this.beer.method_7934(1);
        if (this.beer.method_7960() && this.field_11863 != null) {
            this.field_11863.method_8501(this.method_11016(), (class_2680)this.method_11010().method_11657(BlockStateRegistry.LIQUID, (Comparable)((Object)Liquid.EMPTY)));
        }
        return beerStack;
    }

    @Nullable
    public class_1799 removeIngredient() {
        for (int i = 0; i < 3; ++i) {
            class_1799 itemStack = (class_1799)this.ingredients.get(i);
            if (itemStack.method_7960()) continue;
            this.ingredients.set(i, (Object)class_1799.field_8037);
            return itemStack;
        }
        return null;
    }

    public void tick(class_1937 level, class_2338 blockPos, class_2680 blockState, BrewstationBlockEntity blockEntity) {
        if (level.field_9236) {
            return;
        }
        if (!this.beer.method_7960()) {
            return;
        }
        class_1860 recipe = level.method_8433().method_8132((class_3956)RecipeTypeRegistry.BREWING_RECIPE_TYPE.get(), (class_1263)this, level).orElse(null);
        if (!this.canBrew(recipe)) {
            this.endBrewing();
            return;
        }
        if (this.soundTime >= 60) {
            assert (this.field_11863 != null);
            level.method_8396(null, blockPos, (class_3414)SoundEventRegistry.BREWSTATION_AMBIENT.get(), class_3419.field_15245, 1.0f, 1.0f);
            this.soundTime = 0;
        }
        ++this.soundTime;
        if (this.timeToNextEvent == Integer.MIN_VALUE) {
            this.setTimeToEvent();
        }
        BrewHelper.checkRunningEvents(this);
        int timeLeft = 1200 - this.brewTime;
        if (this.brewTime >= 1200) {
            class_5455 access = level.method_30349();
            this.brew(recipe, access);
        } else if (timeLeft >= 100 && this.timeToNextEvent <= 0 && this.runningEvents.size() < BrewEvents.BREW_EVENTS.size()) {
            BrewEvent event = BrewHelper.getRdmEvent(this);
            if (event != null) {
                class_2960 eventId = BrewEvents.getId(event);
                if (eventId != null) {
                    Brewery.LOGGER.warn("Starting event! " + eventId.method_12832());
                    event.start(this.components, level);
                    this.runningEvents.add(event);
                    ++this.totalEvents;
                } else {
                    Brewery.LOGGER.warn("Event ID is null, cannot start event.");
                }
            } else {
                Brewery.LOGGER.warn("No event to start, skipping event triggering.");
            }
            this.setTimeToEvent();
        }
        ++this.brewTime;
        --this.timeToNextEvent;
    }

    private void setTimeToEvent() {
        if (this.field_11863 != null) {
            this.timeToNextEvent = BreweryMath.getRandomHighNumber(this.field_11863.method_8409(), 100, 300);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canBrew(class_1860<?> recipe) {
        if (recipe == null) return false;
        if (this.field_11863 == null) {
            return false;
        }
        if (!(recipe instanceof BrewingRecipe)) return false;
        BrewingRecipe brewingRecipe = (BrewingRecipe)recipe;
        if (((BrewMaterial)((Object)this.field_11863.method_8320(this.method_11016()).method_11654(BlockStateRegistry.MATERIAL))).getLevel() < brewingRecipe.getMaterial().getLevel()) return false;
        if (this.field_11863.method_8320(this.method_11016()).method_11654(BlockStateRegistry.LIQUID) == Liquid.EMPTY) return false;
        if (this.field_11863.method_8320(BrewHelper.getBlock((class_2248)ObjectRegistry.BREW_OVEN.get(), this.components, this.field_11863)).method_11654(BlockStateRegistry.HEAT) == Heat.OFF) return false;
        return true;
    }

    private void brew(class_1860<?> recipe, class_5455 access) {
        Brewery.LOGGER.info("Brewing!!!");
        class_1799 resultSack = recipe.method_8110(access);
        class_1792 class_17922 = resultSack.method_7909();
        if (class_17922 instanceof DrinkBlockItem) {
            DrinkBlockItem drinkItem = (DrinkBlockItem)class_17922;
            DrinkBlockItem.addQuality(resultSack, this.solved);
            if (this.solved == 0) {
                drinkItem.addCount(resultSack, 1);
            } else {
                drinkItem.addCount(resultSack, this.solved);
            }
        }
        this.beer = resultSack;
        this.spawnElementals();
        this.endBrewing();
        if (this.field_11863 != null) {
            class_2680 blockState = this.field_11863.method_8320(this.method_11016());
            this.field_11863.method_8501(this.method_11016(), (class_2680)blockState.method_11657(BlockStateRegistry.LIQUID, (Comparable)((Object)Liquid.BEER)));
            class_2338 ovenPos = BrewHelper.getBlock((class_2248)ObjectRegistry.BREW_OVEN.get(), this.components, this.field_11863);
            class_2680 ovenState = this.field_11863.method_8320(ovenPos);
            this.field_11863.method_8501(ovenPos, (class_2680)ovenState.method_11657(BlockStateRegistry.HEAT, (Comparable)((Object)Heat.OFF)));
            class_2338 timerPos = BrewHelper.getBlock((class_2248)ObjectRegistry.BREW_TIMER.get(), this.components, this.field_11863);
            class_2680 timerState = this.field_11863.method_8320(timerPos);
            this.field_11863.method_8501(timerPos, (class_2680)timerState.method_11657((class_2769)BlockStateRegistry.TIME, (Comparable)Boolean.valueOf(false)));
        }
        block0: for (class_1856 ingredient : recipe.method_8117()) {
            for (int i = 0; i < 3; ++i) {
                class_1799 itemStack = (class_1799)this.ingredients.get(i);
                if (!ingredient.method_8093(itemStack)) continue;
                this.method_5434(i, 1);
                continue block0;
            }
        }
    }

    private void spawnElementals() {
        class_2338 spawnPos;
        class_2680 blockState = this.field_11863.method_8320(this.method_11016());
        if (this.solved == 0 && this.field_11863 != null && this.field_11863.field_9229.method_43058() >= 0.1 && blockState.method_11654(BlockStateRegistry.MATERIAL) == BrewMaterial.WOOD && (spawnPos = BrewHelper.getBlock((class_2248)ObjectRegistry.BREW_OVEN.get(), this.components, this.field_11863)) != null) {
            BeerElementalEntity beerElemental = new BeerElementalEntity((class_1299<? extends class_1588>)((class_1299)EntityRegistry.BEER_ELEMENTAL.get()), this.field_11863);
            beerElemental.method_5814(spawnPos.method_10263(), spawnPos.method_10264(), spawnPos.method_10260());
            this.field_11863.method_8649((class_1297)beerElemental);
            this.field_11863.method_8396(null, spawnPos, this.spawnEntitySound, class_3419.field_15245, 1.0f, 1.0f);
        }
    }

    public void endBrewing() {
        BrewHelper.finishEvents(this);
        this.solved = 0;
        this.brewTime = 0;
        this.totalEvents = 0;
        this.soundTime = 60;
        this.timeToNextEvent = Integer.MIN_VALUE;
    }

    public boolean isPartOf(class_2338 blockPos) {
        return this.components.contains(blockPos);
    }

    public void method_11007(class_2487 compoundTag) {
        if (!this.components.isEmpty()) {
            BreweryUtil.putBlockPoses(compoundTag, this.components);
        }
        class_1262.method_5426((class_2487)compoundTag, this.ingredients);
        compoundTag.method_10566("beer", (class_2520)this.beer.method_7953(new class_2487()));
        compoundTag.method_10569("solved", this.solved);
        compoundTag.method_10569("brewTime", this.brewTime);
        compoundTag.method_10569("totalEvents", this.totalEvents);
        compoundTag.method_10569("timeToNextEvent", this.timeToNextEvent);
        BrewHelper.saveAdditional(this, compoundTag);
    }

    public void method_11014(class_2487 compoundTag) {
        this.components = BreweryUtil.readBlockPoses(compoundTag);
        this.ingredients = class_2371.method_10213((int)3, (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)compoundTag, this.ingredients);
        if (compoundTag.method_10545("beer")) {
            this.beer = class_1799.method_7915((class_2487)compoundTag.method_10562("beer"));
        }
        this.solved = compoundTag.method_10550("solved");
        this.brewTime = compoundTag.method_10550("brewTime");
        this.totalEvents = compoundTag.method_10550("totalEvents");
        this.timeToNextEvent = compoundTag.method_10550("timeToNextEvent");
        BrewHelper.load(this, compoundTag);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    @NotNull
    public class_2487 method_16887() {
        class_2487 compoundTag = new class_2487();
        this.method_11007(compoundTag);
        return compoundTag;
    }

    public void growSolved() {
        ++this.solved;
    }

    public Set<BrewEvent> getRunningEvents() {
        return this.runningEvents;
    }

    @NotNull
    public Set<class_2338> getComponents() {
        return this.components;
    }

    public List<class_1799> getIngredient() {
        return this.ingredients;
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.ingredients;
    }

    @Override
    public boolean method_5443(class_1657 player) {
        assert (this.field_11863 != null);
        if (this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }
}

