/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tinyskeletons.handler;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import java.util.Map;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1642;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class BabyConversionHandler {
    private static final Map<class_1299<? extends class_1308>, class_1299<? extends class_1308>> BABY_MOB_CONVERSIONS = Maps.newHashMap();

    public static void registerConversion(class_1299<? extends class_1308> targetMob, class_1299<? extends class_1308> convertsTo) {
        BABY_MOB_CONVERSIONS.put(targetMob, convertsTo);
    }

    public static EventResult onEntityLoad(class_1297 entity, class_3218 level, @Nullable class_3730 spawnType) {
        class_1299<? extends class_1308> entityType;
        if (spawnType != null && spawnType != class_3730.field_16462 && class_1642.method_29936((class_5819)level.method_8409()) && (entityType = BABY_MOB_CONVERSIONS.get(entity.method_5864())) != null && BabyConversionHandler.createAndSpawnBabyMob(level, entityType, entity, spawnType) != null) {
            return EventResult.INTERRUPT;
        }
        return EventResult.PASS;
    }

    public static EventResultHolder<class_1269> onEntityInteract(class_1657 player, class_1937 level, class_1268 hand, class_1297 target, class_243 hitVector) {
        class_1299 eggType;
        class_1299<? extends class_1308> babyType;
        class_1799 stackInHand = player.method_5998(hand);
        if (target.method_5805() && stackInHand.method_7909() instanceof class_1826 && (babyType = BABY_MOB_CONVERSIONS.get(eggType = ((class_1826)stackInHand.method_7909()).method_8015(stackInHand.method_7969()))) != null && (target.method_5864() == babyType || target.method_5864() == eggType)) {
            class_1308 mob;
            if (!level.field_9236 && (mob = BabyConversionHandler.createAndSpawnBabyMob((class_3218)level, babyType, target, class_3730.field_16465)) != null) {
                BabyConversionHandler.finalizeSpawnEggMob(mob, stackInHand, player);
            }
            return EventResultHolder.interrupt((Object)class_1269.method_29236((boolean)level.field_9236));
        }
        return EventResultHolder.pass();
    }

    private static void finalizeSpawnEggMob(class_1308 mob, class_1799 itemstack, class_1657 player) {
        mob.method_5966();
        if (itemstack.method_7938()) {
            mob.method_5665(itemstack.method_7964());
        }
        if (!player.method_31549().field_7477) {
            itemstack.method_7934(1);
        }
        player.method_7259(class_3468.field_15372.method_14956((Object)itemstack.method_7909()));
    }

    @Nullable
    private static class_1308 createAndSpawnBabyMob(class_3218 level, class_1299<? extends class_1308> entityType, class_1297 parent, class_3730 spawnReason) {
        class_1308 mob;
        if (parent instanceof class_1296) {
            class_1296 ageableMob = (class_1296)parent;
            mob = ageableMob.method_5613(level, ageableMob);
        } else {
            mob = (class_1308)entityType.method_5883((class_1937)level);
        }
        if (mob == null) {
            return null;
        }
        Preconditions.checkState((boolean)mob.method_6109(), (Object)"Baby mob must be a baby by default");
        mob.method_5808(parent.method_23317(), parent.method_23318(), parent.method_23321(), class_3532.method_15393((float)(level.field_9229.method_43057() * 360.0f)), 0.0f);
        mob.field_6241 = mob.method_36454();
        mob.field_6283 = mob.method_36454();
        class_1266 difficulty = new class_1266(level.method_8407(), level.method_8532(), 0L, level.method_30272());
        mob.method_5943((class_5425)level, difficulty, spawnReason, null, null);
        level.method_30771((class_1297)mob);
        return mob;
    }
}

