/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.item.additional_placements;

import com.mojang.datafixers.util.Pair;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.item.additional_placements.AdditionalItemPlacement;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.misc.IExtendedItem;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class AdditionalItemPlacementsAPI {
    private static boolean isAfterRegistration = false;
    private static WeakReference<Map<class_2248, class_1792>> blockToItemsMap = new WeakReference<Object>(null);
    private static final List<Consumer<Event>> registrationListeners = new ArrayList<Consumer<Event>>();
    private static final List<Pair<Supplier<? extends AdditionalItemPlacement>, Supplier<? extends class_1792>>> PLACEMENTS = new ArrayList<Pair<Supplier<? extends AdditionalItemPlacement>, Supplier<? extends class_1792>>>();
    private static final List<Pair<Function<class_1792, ? extends AdditionalItemPlacement>, Predicate<class_1792>>> PLACEMENTS_GENERIC = new ArrayList<Pair<Function<class_1792, ? extends AdditionalItemPlacement>, Predicate<class_1792>>>();

    @Deprecated(forRemoval=true)
    public static void register(Supplier<? extends AdditionalItemPlacement> placement, Supplier<? extends class_1792> itemSupplier) {
        if (PlatHelper.isDev() && isAfterRegistration) {
            throw new IllegalStateException("Attempted to add placeable behavior after registration");
        }
        PLACEMENTS.add((Pair<Supplier<? extends AdditionalItemPlacement>, Supplier<? extends class_1792>>)Pair.of(placement, itemSupplier));
    }

    @Deprecated(forRemoval=true)
    public static void register(Function<class_1792, ? extends AdditionalItemPlacement> placement, Predicate<class_1792> itemPredicate) {
        if (PlatHelper.isDev() && isAfterRegistration) {
            throw new IllegalStateException("Attempted to add placeable behavior after registration");
        }
        PLACEMENTS_GENERIC.add((Pair<Function<class_1792, ? extends AdditionalItemPlacement>, Predicate<class_1792>>)Pair.of(placement, itemPredicate));
    }

    @Deprecated(forRemoval=true)
    public static void registerSimple(Supplier<? extends class_2248> block, Supplier<? extends class_1792> itemSupplier) {
        AdditionalItemPlacementsAPI.register(() -> new AdditionalItemPlacement((class_2248)block.get()), itemSupplier);
    }

    public static void addRegistration(Consumer<Event> eventConsumer) {
        Moonlight.assertInitPhase();
        registrationListeners.add(eventConsumer);
    }

    @Nullable
    public static AdditionalItemPlacement getBehavior(class_1792 item) {
        return ((IExtendedItem)item).moonlight$getAdditionalBehavior();
    }

    public static boolean hasBehavior(class_1792 item) {
        return AdditionalItemPlacementsAPI.getBehavior(item) != null;
    }

    @ApiStatus.Internal
    public static void afterItemReg() {
        if (blockToItemsMap.get() == null && PlatHelper.isDev()) {
            throw new AssertionError((Object)"Block to items map was null");
        }
        AdditionalItemPlacementsAPI.attemptRegistering();
    }

    private static void attemptRegistering() {
        Map map = (Map)blockToItemsMap.get();
        if (map != null) {
            for (class_1792 item : class_7923.field_41178) {
                for (Pair<Function<class_1792, ? extends AdditionalItemPlacement>, Predicate<class_1792>> v : PLACEMENTS_GENERIC) {
                    Predicate predicate = (Predicate)v.getSecond();
                    if (!predicate.test(item)) continue;
                    PLACEMENTS.add((Pair<Supplier<? extends AdditionalItemPlacement>, Supplier<? extends class_1792>>)Pair.of(() -> (AdditionalItemPlacement)((Function)v.getFirst()).apply(item), () -> item));
                }
            }
            Event ev = (target, instance) -> PLACEMENTS.add((Pair<Supplier<? extends AdditionalItemPlacement>, Supplier<? extends class_1792>>)Pair.of(() -> instance, () -> target));
            for (Consumer<Event> consumer : registrationListeners) {
                consumer.accept(ev);
            }
            PLACEMENTS_GENERIC.clear();
            for (Pair pair : PLACEMENTS) {
                AdditionalItemPlacement placement = (AdditionalItemPlacement)((Supplier)pair.getFirst()).get();
                class_1792 i = (class_1792)((Supplier)pair.getSecond()).get();
                class_2248 b = placement.getPlacedBlock();
                if (i == null || b == null) continue;
                if (i != class_1802.field_8162 && b != class_2246.field_10124) {
                    ((IExtendedItem)i).moonlight$addAdditionalBehavior(placement);
                    if (map.containsKey(b)) continue;
                    map.put(b, i);
                    continue;
                }
                throw new AssertionError((Object)("Attempted to register an Additional behavior to invalid blocks " + b + " with item " + i + "This means that a you eiter attempted to register an additional placement for a block without an item or that the Block returned a null item"));
            }
        }
    }

    static void onRegistryCallback(Map<class_2248, class_1792> pBlockToItemMap) {
        blockToItemsMap = new WeakReference<Map<class_2248, class_1792>>(pBlockToItemMap);
        if (isAfterRegistration) {
            AdditionalItemPlacementsAPI.attemptRegistering();
            blockToItemsMap.clear();
        }
        isAfterRegistration = true;
    }

    public static interface Event {
        public void register(class_1792 var1, AdditionalItemPlacement var2);

        default public void registerSimple(class_1792 target, class_2248 toPlace) {
            this.register(target, new AdditionalItemPlacement(toPlace));
        }
    }
}

