/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.set;

import com.google.common.base.Stopwatch;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class BlocksColorInternal {
    public static final List<class_1767> VANILLA_COLORS = List.of(class_1767.field_7952, class_1767.field_7946, class_1767.field_7958, class_1767.field_7951, class_1767.field_7947, class_1767.field_7961, class_1767.field_7954, class_1767.field_7944, class_1767.field_7967, class_1767.field_7955, class_1767.field_7945, class_1767.field_7966, class_1767.field_7957, class_1767.field_7942, class_1767.field_7964, class_1767.field_7963);
    public static final List<class_1767> MODDED_COLORS = List.of((class_1767[])Arrays.stream(class_1767.values()).filter(v -> !VANILLA_COLORS.contains(v)).toArray(class_1767[]::new));
    private static final Map<String, ColoredSet<class_2248>> BLOCK_COLOR_SETS = new HashMap<String, ColoredSet<class_2248>>();
    private static final Map<String, ColoredSet<class_1792>> ITEM_COLOR_SETS = new HashMap<String, ColoredSet<class_1792>>();
    private static final Object2ObjectOpenHashMap<Object, class_1767> OBJ_TO_COLORS = new Object2ObjectOpenHashMap();
    private static final Object2ObjectOpenHashMap<Object, String> OBJ_TO_TYPE = new Object2ObjectOpenHashMap();

    public static void setup() {
        Stopwatch sw = Stopwatch.createStarted();
        HashMap<String, class_1767> colors = new HashMap<String, class_1767>();
        VANILLA_COLORS.forEach(d -> colors.put(d.method_7792(), (class_1767)d));
        ArrayList<String> colorPriority = new ArrayList<String>(colors.keySet().stream().toList());
        BlocksColorInternal.addColoredFromRegistry(colors, colorPriority, class_7923.field_41175, BLOCK_COLOR_SETS);
        BlocksColorInternal.addColoredFromRegistry(colors, colorPriority, class_7923.field_41178, ITEM_COLOR_SETS);
        Moonlight.LOGGER.info("Initialized color sets in {}ms", (Object)sw.elapsed().toMillis());
    }

    public static void registerBlockColorSet(class_2960 key, EnumMap<class_1767, class_2248> blocks, @Nullable class_2248 defaultBlock) {
        BLOCK_COLOR_SETS.put(key.toString(), new ColoredSet<class_2248>(key, blocks, (class_2378<class_2248>)class_7923.field_41175, defaultBlock));
    }

    public static void registerItemColorSet(class_2960 key, EnumMap<class_1767, class_1792> items, @Nullable class_1792 defaultItem) {
        ITEM_COLOR_SETS.put(key.toString(), new ColoredSet<class_1792>(key, items, (class_2378<class_1792>)class_7923.field_41178, defaultItem));
    }

    private static <T> void addColoredFromRegistry(Map<String, class_1767> colors, List<String> colorPriority, class_2378<T> registry, Map<String, ColoredSet<T>> colorSetMap) {
        HashMap<class_2960, EnumMap> groupedByType = new HashMap<class_2960, EnumMap>();
        colorPriority.sort(Comparator.comparingInt(String::length));
        Collections.reverse(colorPriority);
        block0: for (Map.Entry entry : registry.method_29722()) {
            class_2960 id = ((class_5321)entry.getKey()).method_29177();
            String name = id.method_12832();
            if (!name.contains("_")) continue;
            for (String c : colorPriority) {
                class_2960 newId = null;
                if (name.startsWith(c + "_")) {
                    newId = new class_2960(id.method_12836(), name.substring((c + "_").length()));
                }
                if (name.endsWith("_" + c)) {
                    newId = new class_2960(id.method_12836(), name.substring(0, name.length() - ("_" + c).length()));
                }
                if (newId == null) continue;
                class_1767 dyeColor = colors.get(c);
                groupedByType.computeIfAbsent(newId, a -> new EnumMap(class_1767.class)).put(dyeColor, entry.getValue());
                continue block0;
            }
        }
        for (Map.Entry entry : groupedByType.entrySet()) {
            EnumMap map = (EnumMap)entry.getValue();
            class_2960 id = (class_2960)entry.getKey();
            String modId = id.method_12836();
            if (modId.equals("energeticsheep") || modId.equals("xycraft_world") || modId.equals("botania") || !map.keySet().containsAll(VANILLA_COLORS)) continue;
            ColoredSet<T> set = new ColoredSet<T>(id, map, registry);
            colorSetMap.put(id.toString(), set);
            for (Map.Entry v : set.colorsToObj.entrySet()) {
                OBJ_TO_COLORS.put(v.getValue(), (Object)v.getKey());
                OBJ_TO_TYPE.put(v.getValue(), (Object)id.toString());
            }
            OBJ_TO_TYPE.put(set.defaultObj, (Object)id.toString());
        }
    }

    @Nullable
    public static class_1767 getColor(class_2248 block) {
        return (class_1767)OBJ_TO_COLORS.get((Object)block);
    }

    @Nullable
    public static class_1767 getColor(class_1792 item) {
        return (class_1767)OBJ_TO_COLORS.get((Object)item);
    }

    @Nullable
    public static class_1792 getColoredItem(String key, @Nullable class_1767 color) {
        ColoredSet<class_1792> set = BlocksColorInternal.getItemSet(key);
        if (set != null) {
            return set.with(color);
        }
        return null;
    }

    @Nullable
    public static class_2248 getColoredBlock(String key, @Nullable class_1767 color) {
        ColoredSet<class_2248> set = BlocksColorInternal.getBlockSet(key);
        if (set != null) {
            return set.with(color);
        }
        return null;
    }

    public static Set<String> getBlockKeys() {
        return BLOCK_COLOR_SETS.keySet();
    }

    public static Set<String> getItemKeys() {
        return ITEM_COLOR_SETS.keySet();
    }

    @Nullable
    public static class_2248 changeColor(class_2248 old, @Nullable class_1767 newColor) {
        class_2248 b;
        ColoredSet<class_2248> set;
        String key = BlocksColorInternal.getKey(old);
        if (key != null && (set = BlocksColorInternal.getBlockSet(key)) != null && (b = set.with(newColor)) != old) {
            return b;
        }
        return null;
    }

    @Nullable
    public static class_1792 changeColor(class_1792 old, @Nullable class_1767 newColor) {
        class_1792 i;
        ColoredSet<class_1792> set;
        String key = BlocksColorInternal.getKey(old);
        if (key != null && (set = BlocksColorInternal.getItemSet(key)) != null && (i = set.with(newColor)) != old) {
            return i;
        }
        return null;
    }

    @Nullable
    public static String getKey(class_2248 block) {
        return (String)OBJ_TO_TYPE.get((Object)block);
    }

    @Nullable
    public static String getKey(class_1792 item) {
        return (String)OBJ_TO_TYPE.get((Object)item);
    }

    @Nullable
    private static ColoredSet<class_2248> getBlockSet(String key) {
        key = new class_2960(key).toString();
        return BLOCK_COLOR_SETS.get(key);
    }

    @Nullable
    private static ColoredSet<class_1792> getItemSet(String key) {
        key = new class_2960(key).toString();
        return ITEM_COLOR_SETS.get(key);
    }

    @Nullable
    public static class_6885<class_2248> getBlockHolderSet(String key) {
        ColoredSet<class_2248> set = BlocksColorInternal.getBlockSet(key);
        if (set != null) {
            return set.makeHolderSet((class_2378<class_2248>)class_7923.field_41175);
        }
        return null;
    }

    @Nullable
    public static class_6885<class_1792> getItemHolderSet(String key) {
        ColoredSet<class_1792> set = BlocksColorInternal.getItemSet(key);
        if (set != null) {
            return set.makeHolderSet((class_2378<class_1792>)class_7923.field_41178);
        }
        return null;
    }

    private static class ColoredSet<T> {
        private final class_2960 id;
        private final Map<class_1767, T> colorsToObj;
        private final T defaultObj;

        private ColoredSet(class_2960 id, EnumMap<class_1767, T> map, class_2378<T> registry) {
            this(id, map, registry, null);
        }

        private ColoredSet(class_2960 id, EnumMap<class_1767, T> map, class_2378<T> registry, @Nullable T defBlock) {
            this.colorsToObj = map;
            this.id = id;
            List<String> newColorMods = List.of("tinted", "dye_depot", "dyenamics");
            block0: for (class_1767 c : MODDED_COLORS) {
                String namespace = id.method_12836();
                String path = id.method_12832();
                for (String mod : newColorMods) {
                    for (String s : new String[]{namespace + ":" + path + "_%s", namespace + ":%s_" + path, mod + ":" + path + "_%s", mod + ":%s_" + path}) {
                        Optional o = registry.method_17966(new class_2960(String.format(s, c.method_7792())));
                        if (!o.isPresent()) continue;
                        this.colorsToObj.put(c, o.get());
                        continue block0;
                    }
                }
            }
            this.defaultObj = defBlock == null ? this.computeDefault(id, registry) : defBlock;
        }

        private T computeDefault(class_2960 id, class_2378<T> registry) {
            if (id.method_12836().equals("minecraft") && id.method_12832().contains("stained_glass")) {
                id = new class_2960(id.method_12832().replace("stained_", ""));
            } else if (id.method_12836().equals("quark")) {
                if (id.method_12832().equals("rune")) {
                    id = new class_2960("quark", "blank_rune");
                } else if (id.method_12832().equals("shard")) {
                    id = new class_2960("quark", "clear_shard");
                }
            } else if (id.equals((Object)new class_2960("suppsquared:sack"))) {
                id = new class_2960("supplementaries:sack");
            }
            class_2960 finalId = id;
            Optional o = registry.method_17966(id);
            if (o.isEmpty()) {
                return (T)registry.method_17966(new class_2960(finalId.method_12832())).orElseGet(() -> this.colorsToObj.get(class_1767.field_7952));
            }
            return o.get();
        }

        private class_6885<T> makeHolderSet(class_2378<T> registry) {
            Optional v = registry.method_40266(class_6862.method_40092((class_5321)registry.method_30517(), (class_2960)new class_2960(this.id.method_12836(), this.id.method_12832() + "s")));
            if (v.isEmpty()) {
                v = registry.method_40266(class_6862.method_40092((class_5321)registry.method_30517(), (class_2960)new class_2960(PlatHelper.getPlatform().isForge() ? "forge" : "c", this.id.method_12832() + "s")));
            }
            if (v.isPresent()) {
                class_6885.class_6888 tag = (class_6885.class_6888)v.get();
                boolean success = true;
                for (T t2 : this.colorsToObj.values()) {
                    if (tag.method_40241((class_6880)registry.method_40290((class_5321)registry.method_29113(t2).get()))) continue;
                    success = false;
                    break;
                }
                if (success) {
                    return tag;
                }
            }
            return class_6885.method_40244(t -> registry.method_40290((class_5321)registry.method_29113(t).get()), new ArrayList<T>(this.colorsToObj.values()));
        }

        @Nullable
        private T with(@Nullable class_1767 newColor) {
            if (newColor != null && !this.colorsToObj.containsKey(newColor)) {
                return null;
            }
            return this.colorsToObj.getOrDefault(newColor, this.defaultObj);
        }
    }
}

