/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.client.recipebook.screen.widgets;

import com.google.common.collect.Lists;
import de.cristelknight.doapi.client.recipebook.IRecipeBookGroup;
import de.cristelknight.doapi.client.recipebook.PrivateRecipeBookGhostSlots;
import de.cristelknight.doapi.client.recipebook.handler.AbstractPrivateRecipeScreenHandler;
import de.cristelknight.doapi.client.recipebook.screen.PrivateRecipeBookRecipeArea;
import de.cristelknight.doapi.client.recipebook.screen.widgets.PrivateRecipeGroupButtonWidget;
import de.cristelknight.doapi.config.builtin.RBConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1662;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2561;
import net.minecraft.class_2952;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_342;
import net.minecraft.class_361;
import net.minecraft.class_364;
import net.minecraft.class_3956;
import net.minecraft.class_4068;
import net.minecraft.class_4587;
import net.minecraft.class_515;
import net.minecraft.class_5455;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public abstract class PrivateRecipeBookWidget
implements class_2952<class_1856>,
class_4068,
class_364,
class_515 {
    public static final class_2960 TEXTURE = new class_2960("textures/gui/recipe_book.png");
    private static final class_2561 SEARCH_HINT_TEXT = class_2561.method_43471((String)"gui.recipebook.search_hint").method_27692(class_124.field_1056).method_27692(class_124.field_1080);
    private static final class_2561 TOGGLE_CRAFTABLE_RECIPES_TEXT = class_2561.method_43471((String)"gui.recipebook.toggleRecipes.craftable");
    private static final class_2561 TOGGLE_ALL_RECIPES_TEXT = class_2561.method_43471((String)"gui.recipebook.toggleRecipes.all");
    protected final PrivateRecipeBookGhostSlots ghostSlots = new PrivateRecipeBookGhostSlots();
    private final List<PrivateRecipeGroupButtonWidget> tabButtons = Lists.newArrayList();
    @Nullable
    private PrivateRecipeGroupButtonWidget currentTab;
    protected class_361 toggleCraftableButton;
    protected AbstractPrivateRecipeScreenHandler screenHandler;
    @Nullable
    private class_342 searchField;
    private int leftOffset;
    private int parentWidth;
    private int parentHeight;
    protected class_310 client;
    private String searchText = "";
    private final PrivateRecipeBookRecipeArea recipesArea = new PrivateRecipeBookRecipeArea();
    private final class_1662 recipeFinder = new class_1662();
    private int cachedInvChangeCount;
    private boolean searching;
    private boolean open;
    private boolean narrow;

    protected abstract class_3956<? extends class_1860<class_1263>> getRecipeType();

    public abstract void insertRecipe(class_1860<?> var1);

    public abstract void showGhostRecipe(class_1860<?> var1, List<class_1735> var2, class_5455 var3);

    public void initialize(int parentWidth, int parentHeight, class_310 client, boolean narrow, AbstractPrivateRecipeScreenHandler craftingScreenHandler) {
        this.client = client;
        this.parentWidth = parentWidth;
        this.parentHeight = parentHeight;
        this.screenHandler = craftingScreenHandler;
        this.narrow = narrow;
        assert (client.field_1724 != null);
        client.field_1724.field_7512 = craftingScreenHandler;
        this.cachedInvChangeCount = client.field_1724.method_31548().method_7364();
        this.open = this.isGuiOpen();
        if (this.open) {
            this.reset();
        }
    }

    protected void setOpen(boolean opened) {
        if (opened) {
            this.reset();
        }
        this.open = opened;
        RBConfig.setRecipeBookOpenToggle(opened);
        if (!opened) {
            this.recipesArea.hideAlternates();
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    private boolean isGuiOpen() {
        return ((RBConfig)RBConfig.DEFAULT.getConfig()).recipeBookOpen();
    }

    public void toggleOpen() {
        this.setOpen(!this.isOpen());
    }

    private boolean toggleFilteringCraftable() {
        boolean bl = !((RBConfig)RBConfig.DEFAULT.getConfig()).craftableToggle();
        RBConfig.setCraftableToggle(bl);
        return bl;
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        if (this.isOpen()) {
            class_4587 poseStack = guiGraphics.method_51448();
            poseStack.method_22903();
            poseStack.method_22904(0.0, 0.0, 100.0);
            int i = (this.parentWidth - 147) / 2 - this.leftOffset;
            int j = (this.parentHeight - 166) / 2;
            guiGraphics.method_25302(TEXTURE, i, j, 1, 1, 147, 166);
            if (!this.searchField.method_25370() && this.searchField.method_1882().isEmpty()) {
                guiGraphics.method_27535(this.client.field_1772, SEARCH_HINT_TEXT, i + 25, j + 14, -1);
            } else {
                this.searchField.method_25394(guiGraphics, mouseX, mouseY, delta);
            }
            for (PrivateRecipeGroupButtonWidget recipeGroupButtonWidget : this.tabButtons) {
                recipeGroupButtonWidget.method_25394(guiGraphics, mouseX, mouseY, delta);
            }
            this.toggleCraftableButton.method_25394(guiGraphics, mouseX, mouseY, delta);
            this.recipesArea.draw(guiGraphics, i, j, mouseX, mouseY, delta);
            poseStack.method_22909();
        }
    }

    public void drawGhostSlots(class_332 guiGraphics, int x, int y, boolean bl, float delta) {
        this.ghostSlots.draw(guiGraphics, this.client, x, y, bl, delta);
    }

    public void drawTooltip(class_332 guiGraphics, int x, int y, int mouseX, int mouseY) {
        if (this.isOpen()) {
            this.recipesArea.drawTooltip(guiGraphics, mouseX, mouseY);
            if (this.toggleCraftableButton.method_49606()) {
                class_2561 text = this.getCraftableButtonText();
                if (this.client.field_1755 != null) {
                    guiGraphics.method_51438(this.client.field_1772, text, mouseX, mouseY);
                }
            }
            this.drawGhostSlotTooltip(guiGraphics, x, y, mouseX, mouseY);
        }
    }

    private void drawGhostSlotTooltip(class_332 guiGraphics, int x, int y, int mouseX, int mouseY) {
        class_1799 itemStack = null;
        for (int i = 0; i < this.ghostSlots.getSlotCount(); ++i) {
            PrivateRecipeBookGhostSlots.PrivateGhostInputSlot ghostInputSlot = this.ghostSlots.getSlot(i);
            int j = ghostInputSlot.getX() + x;
            int k = ghostInputSlot.getY() + y;
            if (mouseX < j || mouseY < k || mouseX >= j + 16 || mouseY >= k + 16) continue;
            itemStack = ghostInputSlot.getCurrentItemStack();
        }
        if (itemStack != null && this.client.field_1755 != null) {
            guiGraphics.method_51446(this.client.field_1772, itemStack, mouseX, mouseY);
        }
    }

    public void update() {
        boolean open = this.isGuiOpen();
        if (this.isOpen() != open) {
            this.setOpen(open);
        }
        if (this.isOpen()) {
            if (this.cachedInvChangeCount != this.client.field_1724.method_31548().method_7364()) {
                this.refreshInputs();
                this.cachedInvChangeCount = this.client.field_1724.method_31548().method_7364();
            }
            this.searchField.method_1865();
        }
    }

    private void refreshResults(boolean resetCurrentPage) {
        if (this.currentTab == null) {
            return;
        }
        if (this.searchField == null) {
            return;
        }
        List recipes = this.getResultsForGroup(this.currentTab.getGroup(), this.client.field_1687.method_8433().method_30027(this.getRecipeType()));
        String string = this.searchField.method_1882();
        if (!string.isEmpty()) {
            recipes.removeIf(recipe -> !recipe.method_8110(this.client.field_1687.method_30349()).method_7964().getString().toLowerCase(Locale.ROOT).contains(string.toLowerCase(Locale.ROOT)));
        }
        if (((RBConfig)RBConfig.DEFAULT.getConfig()).craftableToggle()) {
            recipes.removeIf(recipe -> !this.screenHandler.hasIngredient((class_1860<?>)recipe));
        }
        this.recipesArea.setResults(recipes, resetCurrentPage);
    }

    private <T extends class_1860<class_1263>> List<T> getResultsForGroup(IRecipeBookGroup group, List<T> recipes) {
        ArrayList results = Lists.newArrayList();
        for (class_1860 recipe : recipes) {
            if (!group.fitRecipe((class_1860<? extends class_1263>)recipe, this.client.field_1687.method_30349())) continue;
            results.add(recipe);
        }
        return results;
    }

    private void refreshTabButtons() {
        int i = (this.parentWidth - 147) / 2 - this.leftOffset - 30;
        int j = (this.parentHeight - 166) / 2 + 3;
        int l = 0;
        for (PrivateRecipeGroupButtonWidget recipeGroupButtonWidget : this.tabButtons) {
            recipeGroupButtonWidget.field_22764 = true;
            recipeGroupButtonWidget.method_48229(i, j + 27 * l++);
        }
    }

    private void refreshInputs() {
        this.recipeFinder.method_7409();
        this.client.field_1724.method_31548().method_7387(this.recipeFinder);
        this.refreshResults(false);
    }

    public void reset() {
        this.leftOffset = this.narrow ? 0 : 86;
        int i = (this.parentWidth - 147) / 2 - this.leftOffset;
        int j = (this.parentHeight - 166) / 2;
        this.recipeFinder.method_7409();
        this.client.field_1724.method_31548().method_7387(this.recipeFinder);
        String string = this.searchField != null ? this.searchField.method_1882() : "";
        class_327 var10003 = this.client.field_1772;
        int var10004 = i + 25;
        int var10005 = j + 14;
        Objects.requireNonNull(this.client.field_1772);
        this.searchField = new class_342(var10003, var10004, var10005, 80, 14, (class_2561)class_2561.method_43471((String)"itemGroup.search"));
        this.searchField.method_1880(50);
        this.searchField.method_1858(false);
        this.searchField.method_1862(true);
        this.searchField.method_1868(0xFFFFFF);
        this.searchField.method_1852(string);
        this.recipesArea.initialize(this.client, i, j, this.screenHandler);
        this.toggleCraftableButton = new class_361(i + 110, j + 12, 26, 16, ((RBConfig)RBConfig.DEFAULT.getConfig()).craftableToggle());
        this.setCraftableButtonTexture();
        this.tabButtons.clear();
        for (IRecipeBookGroup recipeBookGroup : this.screenHandler.getGroups()) {
            this.tabButtons.add(new PrivateRecipeGroupButtonWidget(recipeBookGroup));
        }
        if (this.currentTab != null) {
            this.currentTab = this.tabButtons.stream().filter(button -> button.getGroup().equals(this.currentTab.getGroup())).findFirst().orElse(null);
        }
        if (this.currentTab == null) {
            this.currentTab = this.tabButtons.get(0);
        }
        this.currentTab.method_1964(true);
        this.refreshResults(false);
        this.refreshTabButtons();
    }

    public void slotClicked(@Nullable class_1735 slot) {
        if (slot != null && slot.field_7874 < this.screenHandler.getCraftingSlotCount()) {
            this.ghostSlots.reset();
            if (this.isOpen()) {
                this.refreshInputs();
            }
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        System.out.println("jojojo");
        if (this.open && !this.client.field_1724.method_7325()) {
            PrivateRecipeGroupButtonWidget vineryRecipeGroupButtonWidget;
            if (this.recipesArea.mouseClicked(mouseX, mouseY, button)) {
                class_1860<?> recipe = this.recipesArea.getLastClickedRecipe();
                class_1860<?> recipeBookRecipe = this.recipesArea.getLastClickedRecipe();
                if (recipe != null) {
                    if (this.currentTab == null) {
                        return false;
                    }
                    this.ghostSlots.reset();
                    assert (recipeBookRecipe != null);
                    if (!this.screenHandler.hasIngredient(recipe)) {
                        this.showGhostRecipe(recipe, (List<class_1735>)this.screenHandler.field_7761, this.client.field_1687.method_30349());
                        return false;
                    }
                    this.ghostSlots.reset();
                    this.insertRecipe(recipe);
                    this.refreshResults(false);
                }
                return true;
            }
            if (this.searchField.method_25402(mouseX, mouseY, button)) {
                this.searchField.method_25365(true);
                return true;
            }
            if (this.toggleCraftableButton.method_25402(mouseX, mouseY, button)) {
                this.searchField.method_25365(false);
                boolean bl = this.toggleFilteringCraftable();
                this.toggleCraftableButton.method_1964(bl);
                this.refreshResults(false);
                return true;
            }
            Iterator<PrivateRecipeGroupButtonWidget> var6 = this.tabButtons.iterator();
            do {
                if (var6.hasNext()) continue;
                return false;
            } while (!(vineryRecipeGroupButtonWidget = var6.next()).method_25402(mouseX, mouseY, button));
            if (this.currentTab != vineryRecipeGroupButtonWidget) {
                if (this.currentTab != null) {
                    this.currentTab.method_1964(false);
                }
                this.currentTab = vineryRecipeGroupButtonWidget;
                this.currentTab.method_1964(true);
                this.refreshResults(true);
            }
            return false;
        }
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        System.out.println(keyCode);
        this.searching = false;
        if (this.isOpen() && !this.client.field_1724.method_7325()) {
            if (keyCode == 256 && !this.isWide()) {
                this.setOpen(false);
                return true;
            }
            if (this.searchField.method_25404(keyCode, scanCode, modifiers)) {
                this.refreshSearchResults();
                return true;
            }
            if (this.searchField.method_25370() && this.searchField.method_1885() && keyCode != 256) {
                return true;
            }
            if (this.client.field_1690.field_1890.method_1417(keyCode, scanCode) && !this.searchField.method_25370()) {
                this.searching = true;
                this.searchField.method_25365(true);
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        this.searching = false;
        return false;
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.searching) {
            return false;
        }
        if (this.isOpen() && !this.client.field_1724.method_7325() && this.searchField.method_25400(chr, modifiers)) {
            this.refreshSearchResults();
            return true;
        }
        return false;
    }

    private void refreshSearchResults() {
        String string = this.searchField.method_1882().toLowerCase(Locale.ROOT);
        this.triggerPrivateEasterEgg(string);
        if (!string.equals(this.searchText)) {
            this.refreshResults(false);
            this.searchText = string;
        }
    }

    private void triggerPrivateEasterEgg(String search) {
        String text;
        String name;
        switch (search) {
            case "misslilitu": {
                name = "MissLilitu";
                text = "Boo!";
                break;
            }
            case "satisfy": {
                name = "satisfy";
                text = "Boo!";
                break;
            }
            case "cristelknight": {
                name = "CristelKnight";
                text = "Boo!";
                break;
            }
            case "bmjo": {
                name = "BaumeisterJO";
                text = "42";
                break;
            }
            default: {
                return;
            }
        }
        class_746 playerEntity = this.client.field_1724;
        assert (playerEntity != null);
        playerEntity.method_43496(class_2561.method_30163((String)("<" + name + "> " + text)));
        playerEntity.method_5783(class_3417.field_14800, 0.5f, 1.0f);
    }

    public boolean isClickOutsideBounds(double mouseX, double mouseY, int x, int y, int backgroundWidth, int backgroundHeight) {
        if (!this.isOpen()) {
            return true;
        }
        boolean bl = mouseX < (double)x || mouseY < (double)y || mouseX >= (double)(x + backgroundWidth) || mouseY >= (double)(y + backgroundHeight);
        boolean bl2 = (double)(x - 147) < mouseX && mouseX < (double)x && (double)y < mouseY && mouseY < (double)(y + backgroundHeight);
        return bl && !bl2 && !this.currentTab.method_49606();
    }

    protected void setCraftableButtonTexture() {
        this.toggleCraftableButton.method_1962(152, 41, 28, 18, TEXTURE);
    }

    protected class_2561 getToggleCraftableButtonText() {
        return TOGGLE_CRAFTABLE_RECIPES_TEXT;
    }

    private class_2561 getCraftableButtonText() {
        return this.toggleCraftableButton.method_1965() ? this.getToggleCraftableButtonText() : TOGGLE_ALL_RECIPES_TEXT;
    }

    public int findLeftEdge(int width, int backgroundWidth) {
        int i = this.isOpen() && !this.narrow ? 177 + (width - backgroundWidth - 200) / 2 : (width - backgroundWidth) / 2;
        return i;
    }

    private boolean isWide() {
        return this.leftOffset == 86;
    }

    public void method_12815(Iterator<class_1856> inputs, int slot, int amount, int gridX, int gridY) {
    }

    public void method_2646(List<class_1860<?>> recipes) {
    }
}

