/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.client.render.feature;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import de.cristelknight.doapi.Util;
import de.cristelknight.doapi.api.DoApiAPI;
import de.cristelknight.doapi.api.DoApiPlugin;
import de.cristelknight.doapi.client.render.feature.FullCustomArmor;
import de.cristelknight.doapi.common.item.CustomArmorItem;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4057;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5599;
import net.minecraft.class_572;
import net.minecraft.class_918;

@Environment(value=EnvType.CLIENT)
public class CustomArmorFeatureRenderer<T extends class_1309, M extends class_572<T>>
extends class_3887<T, M> {
    public Map<FullCustomArmor, Pair<class_572<T>, class_572<T>>> MODELS = Maps.newHashMap();
    private final class_5599 modelLoader;

    public CustomArmorFeatureRenderer(class_3883<T, M> context, class_5599 modelSet) {
        super(context);
        this.modelLoader = modelSet;
    }

    public void render(class_4587 poseStack, class_4597 multiBufferSource, int i, T livingEntity, float f, float g, float h, float j, float k, float l) {
        this.renderArmorPiece(poseStack, multiBufferSource, livingEntity, class_1304.field_6174, i, this.getArmorModel(livingEntity, class_1304.field_6174));
        this.renderArmorPiece(poseStack, multiBufferSource, livingEntity, class_1304.field_6172, i, this.getArmorModel(livingEntity, class_1304.field_6172));
        this.renderArmorPiece(poseStack, multiBufferSource, livingEntity, class_1304.field_6166, i, this.getArmorModel(livingEntity, class_1304.field_6166));
    }

    private void renderArmorPiece(class_4587 poseStack, class_4597 multiBufferSource, T livingEntity, class_1304 equipmentSlot, int i, FullCustomArmor armor) {
        class_1799 itemStack = livingEntity.method_6118(equipmentSlot);
        class_1792 class_17922 = itemStack.method_7909();
        if (!(class_17922 instanceof class_1738)) {
            return;
        }
        class_1738 armorItem = (class_1738)class_17922;
        if (armorItem.method_7685() != equipmentSlot) {
            return;
        }
        if (armor == null) {
            return;
        }
        Pair<class_572<T>, class_572<T>> humanoidModels = this.MODELS.get(armor);
        class_572 humanoidModel = this.usesInnerModel(equipmentSlot) ? (class_572)humanoidModels.getSecond() : (class_572)humanoidModels.getFirst();
        ((class_572)this.method_17165()).method_2818(humanoidModel);
        this.setPartVisibility(humanoidModel, equipmentSlot);
        boolean bl = this.usesInnerModel(equipmentSlot);
        boolean bl2 = itemStack.method_7958();
        if (armorItem instanceof class_4057) {
            int j = ((class_4057)armorItem).method_7800(itemStack);
            float f = (float)(j >> 16 & 0xFF) / 255.0f;
            float g = (float)(j >> 8 & 0xFF) / 255.0f;
            float h = (float)(j & 0xFF) / 255.0f;
            this.renderModel(poseStack, multiBufferSource, i, armor, bl2, humanoidModel, f, g, h);
        } else {
            this.renderModel(poseStack, multiBufferSource, i, armor, bl2, humanoidModel, 1.0f, 1.0f, 1.0f);
        }
    }

    private void setPartVisibility(class_572<T> humanoidModel, class_1304 equipmentSlot) {
        humanoidModel.method_2805(false);
        switch (equipmentSlot) {
            case field_6169: {
                humanoidModel.field_3398.field_3665 = true;
                humanoidModel.field_3394.field_3665 = true;
                break;
            }
            case field_6174: {
                humanoidModel.field_3391.field_3665 = true;
                humanoidModel.field_3401.field_3665 = true;
                humanoidModel.field_27433.field_3665 = true;
                break;
            }
            case field_6172: {
                humanoidModel.field_3391.field_3665 = true;
                humanoidModel.field_3392.field_3665 = true;
                humanoidModel.field_3397.field_3665 = true;
                break;
            }
            case field_6166: {
                humanoidModel.field_3392.field_3665 = true;
                humanoidModel.field_3397.field_3665 = true;
            }
        }
    }

    private void renderModel(class_4587 poseStack, class_4597 multiBufferSource, int i, FullCustomArmor armor, boolean bl, class_572<T> humanoidModel, float f, float g, float h) {
        class_4588 vertexConsumer = class_918.method_27952((class_4597)multiBufferSource, (class_1921)class_1921.method_25448((class_2960)armor.texture), (boolean)false, (boolean)bl);
        humanoidModel.method_2828(poseStack, vertexConsumer, i, class_4608.field_21444, f, g, h, 1.0f);
    }

    public void addModels(FullCustomArmor armor, class_572<T> outerModel, class_572<T> innerModel) {
        this.MODELS.put(armor, new Pair(outerModel, innerModel));
    }

    private FullCustomArmor getArmorModel(T entity, class_1304 slot) {
        CustomArmorItem hatItem = this.getArmorItem(entity, slot);
        if (hatItem != null) {
            if (this.MODELS.isEmpty()) {
                List<DoApiAPI> apis = Util.getApis(DoApiAPI.class, "doapi", DoApiPlugin.class);
                for (DoApiAPI api : apis) {
                    api.registerArmor(this.MODELS, this.modelLoader);
                }
            }
            for (FullCustomArmor armor : this.MODELS.keySet()) {
                if (!armor.set.contains((Object)hatItem)) continue;
                return armor;
            }
        }
        return null;
    }

    private CustomArmorItem getArmorItem(T entity, class_1304 slot) {
        class_1799 armorSlot = entity.method_6118(slot);
        class_1792 class_17922 = armorSlot.method_7909();
        if (class_17922 instanceof CustomArmorItem) {
            CustomArmorItem hat = (CustomArmorItem)class_17922;
            if (!armorSlot.method_7960()) {
                return hat;
            }
        }
        return null;
    }

    private boolean usesInnerModel(class_1304 equipmentSlot) {
        return equipmentSlot == class_1304.field_6172;
    }
}

