/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client;

import dan200.computercraft.api.client.ComputerCraftAPIClient;
import dan200.computercraft.api.client.turtle.TurtleUpgradeModeller;
import dan200.computercraft.api.turtle.TurtleUpgradeSerialiser;
import dan200.computercraft.client.gui.ComputerScreen;
import dan200.computercraft.client.gui.DiskDriveScreen;
import dan200.computercraft.client.gui.GuiSprites;
import dan200.computercraft.client.gui.NoTermComputerScreen;
import dan200.computercraft.client.gui.PrinterScreen;
import dan200.computercraft.client.gui.PrintoutScreen;
import dan200.computercraft.client.gui.TurtleScreen;
import dan200.computercraft.client.pocket.ClientPocketComputers;
import dan200.computercraft.client.render.RenderTypes;
import dan200.computercraft.client.render.TurtleBlockEntityRenderer;
import dan200.computercraft.client.render.monitor.MonitorBlockEntityRenderer;
import dan200.computercraft.client.turtle.TurtleModemModeller;
import dan200.computercraft.client.turtle.TurtleUpgradeModellers;
import dan200.computercraft.core.util.Colour;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.media.items.DiskItem;
import dan200.computercraft.shared.media.items.TreasureDiskItem;
import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_326;
import net.minecraft.class_3302;
import net.minecraft.class_3917;
import net.minecraft.class_3929;
import net.minecraft.class_5272;
import net.minecraft.class_5616;
import net.minecraft.class_5912;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import net.minecraft.class_6395;

@Environment(value=EnvType.CLIENT)
public final class ClientRegistry {
    private static final String[] EXTRA_MODELS = new String[]{"block/turtle_colour", "block/turtle_elf_overlay", "block/turtle_rainbow_overlay", "block/turtle_trans_overlay"};

    private ClientRegistry() {
    }

    public static void register() {
        ComputerCraftAPIClient.registerTurtleUpgradeModeller((TurtleUpgradeSerialiser)ModRegistry.TurtleSerialisers.SPEAKER.get(), TurtleUpgradeModeller.sided(new class_2960("computercraft", "block/turtle_speaker_left"), new class_2960("computercraft", "block/turtle_speaker_right")));
        ComputerCraftAPIClient.registerTurtleUpgradeModeller((TurtleUpgradeSerialiser)ModRegistry.TurtleSerialisers.WORKBENCH.get(), TurtleUpgradeModeller.sided(new class_2960("computercraft", "block/turtle_crafting_table_left"), new class_2960("computercraft", "block/turtle_crafting_table_right")));
        ComputerCraftAPIClient.registerTurtleUpgradeModeller((TurtleUpgradeSerialiser)ModRegistry.TurtleSerialisers.WIRELESS_MODEM_NORMAL.get(), new TurtleModemModeller(false));
        ComputerCraftAPIClient.registerTurtleUpgradeModeller((TurtleUpgradeSerialiser)ModRegistry.TurtleSerialisers.WIRELESS_MODEM_ADVANCED.get(), new TurtleModemModeller(true));
        ComputerCraftAPIClient.registerTurtleUpgradeModeller((TurtleUpgradeSerialiser)ModRegistry.TurtleSerialisers.TOOL.get(), TurtleUpgradeModeller.flatItem());
        class_5616.method_32144((class_2591)((class_2591)ModRegistry.BlockEntities.MONITOR_NORMAL.get()), MonitorBlockEntityRenderer::new);
        class_5616.method_32144((class_2591)((class_2591)ModRegistry.BlockEntities.MONITOR_ADVANCED.get()), MonitorBlockEntityRenderer::new);
        class_5616.method_32144((class_2591)((class_2591)ModRegistry.BlockEntities.TURTLE_NORMAL.get()), TurtleBlockEntityRenderer::new);
        class_5616.method_32144((class_2591)((class_2591)ModRegistry.BlockEntities.TURTLE_ADVANCED.get()), TurtleBlockEntityRenderer::new);
    }

    public static void registerMainThread() {
        class_3929.method_17542((class_3917)((class_3917)ModRegistry.Menus.COMPUTER.get()), ComputerScreen::new);
        class_3929.method_17542((class_3917)((class_3917)ModRegistry.Menus.POCKET_COMPUTER.get()), ComputerScreen::new);
        class_3929.method_17542((class_3917)((class_3917)ModRegistry.Menus.POCKET_COMPUTER_NO_TERM.get()), NoTermComputerScreen::new);
        class_3929.method_17542((class_3917)((class_3917)ModRegistry.Menus.TURTLE.get()), TurtleScreen::new);
        class_3929.method_17542((class_3917)((class_3917)ModRegistry.Menus.PRINTER.get()), PrinterScreen::new);
        class_3929.method_17542((class_3917)((class_3917)ModRegistry.Menus.DISK_DRIVE.get()), DiskDriveScreen::new);
        class_3929.method_17542((class_3917)((class_3917)ModRegistry.Menus.PRINTOUT.get()), PrintoutScreen::new);
        class_3929.method_17542((class_3917)((class_3917)ModRegistry.Menus.VIEW_COMPUTER.get()), ComputerScreen::new);
        ClientRegistry.registerItemProperty("state", new UnclampedPropertyFunction((stack, world, player, random) -> ClientPocketComputers.get(stack).getState().ordinal()), ModRegistry.Items.POCKET_COMPUTER_NORMAL, ModRegistry.Items.POCKET_COMPUTER_ADVANCED);
        ClientRegistry.registerItemProperty("coloured", (stack, world, player, random) -> IColouredItem.getColourBasic(stack) != -1 ? 1.0f : 0.0f, ModRegistry.Items.POCKET_COMPUTER_NORMAL, ModRegistry.Items.POCKET_COMPUTER_ADVANCED);
    }

    @SafeVarargs
    private static void registerItemProperty(String name, class_6395 getter, Supplier<? extends class_1792> ... items) {
        class_2960 id = new class_2960("computercraft", name);
        for (Supplier<? extends class_1792> item : items) {
            class_5272.method_27879((class_1792)item.get(), (class_2960)id, (class_6395)getter);
        }
    }

    public static void registerReloadListeners(Consumer<class_3302> register, class_310 minecraft) {
        register.accept((class_3302)GuiSprites.initialise(minecraft.method_1531()));
    }

    public static void registerExtraModels(Consumer<class_2960> register) {
        for (String model : EXTRA_MODELS) {
            register.accept(new class_2960("computercraft", model));
        }
        TurtleUpgradeModellers.getDependencies().forEach(register);
    }

    public static void registerItemColours(BiConsumer<class_326, class_1935> register) {
        register.accept((stack, layer) -> layer == 1 ? ((DiskItem)stack.method_7909()).getColour(stack) : 0xFFFFFF, (class_1935)ModRegistry.Items.DISK.get());
        register.accept((stack, layer) -> layer == 1 ? TreasureDiskItem.getColour(stack) : 0xFFFFFF, (class_1935)ModRegistry.Items.TREASURE_DISK.get());
        register.accept(ClientRegistry::getPocketColour, (class_1935)ModRegistry.Items.POCKET_COMPUTER_NORMAL.get());
        register.accept(ClientRegistry::getPocketColour, (class_1935)ModRegistry.Items.POCKET_COMPUTER_ADVANCED.get());
        register.accept(ClientRegistry::getTurtleColour, (class_1935)ModRegistry.Blocks.TURTLE_NORMAL.get());
        register.accept(ClientRegistry::getTurtleColour, (class_1935)ModRegistry.Blocks.TURTLE_ADVANCED.get());
    }

    private static int getPocketColour(class_1799 stack, int layer) {
        switch (layer) {
            default: {
                return 0xFFFFFF;
            }
            case 1: {
                return IColouredItem.getColourBasic(stack);
            }
            case 2: 
        }
        int light = ClientPocketComputers.get(stack).getLightState();
        return light == -1 ? Colour.BLACK.getHex() : light;
    }

    private static int getTurtleColour(class_1799 stack, int layer) {
        return layer == 0 ? ((IColouredItem)stack.method_7909()).getColour(stack) : 0xFFFFFF;
    }

    public static void registerShaders(class_5912 resources, BiConsumer<class_5944, Consumer<class_5944>> load) throws IOException {
        RenderTypes.registerShaders(resources, load);
    }

    @Environment(value=EnvType.CLIENT)
    private record UnclampedPropertyFunction(class_6395 function) implements class_6395
    {
        public float unclampedCall(class_1799 stack, @Nullable class_638 level, @Nullable class_1309 entity, int layer) {
            return this.function.unclampedCall(stack, level, entity, layer);
        }

        @Deprecated
        public float call(class_1799 stack, @Nullable class_638 level, @Nullable class_1309 entity, int layer) {
            return this.function.unclampedCall(stack, level, entity, layer);
        }
    }
}

