/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis.http.websocket;

import com.google.common.base.Strings;
import dan200.computercraft.core.Logging;
import dan200.computercraft.core.apis.IAPIEnvironment;
import dan200.computercraft.core.apis.http.HTTPRequestException;
import dan200.computercraft.core.apis.http.NetworkUtils;
import dan200.computercraft.core.apis.http.Resource;
import dan200.computercraft.core.apis.http.ResourceGroup;
import dan200.computercraft.core.apis.http.options.Options;
import dan200.computercraft.core.apis.http.websocket.NoOriginWebSocketHandshaker;
import dan200.computercraft.core.apis.http.websocket.WebsocketClient;
import dan200.computercraft.core.apis.http.websocket.WebsocketCompressionHandler;
import dan200.computercraft.core.apis.http.websocket.WebsocketHandle;
import dan200.computercraft.core.apis.http.websocket.WebsocketHandler;
import dan200.computercraft.core.metrics.Metrics;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.ssl.SslContext;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Websocket
extends Resource<Websocket>
implements WebsocketClient {
    private static final Logger LOG = LoggerFactory.getLogger(Websocket.class);
    public static final int MAX_MESSAGE_SIZE = 0x40000000;
    @Nullable
    private Future<?> executorFuture;
    @Nullable
    private ChannelFuture channelFuture;
    private final IAPIEnvironment environment;
    private final URI uri;
    private final String address;
    private final HttpHeaders headers;
    private final int timeout;

    public Websocket(ResourceGroup<Websocket> limiter, IAPIEnvironment environment, URI uri, String address, HttpHeaders headers, int timeout) {
        super(limiter);
        this.environment = environment;
        this.uri = uri;
        this.address = address;
        this.headers = headers;
        this.timeout = timeout;
    }

    public void connect() {
        if (this.isClosed()) {
            return;
        }
        this.executorFuture = NetworkUtils.EXECUTOR.submit(this::doConnect);
        this.checkClosed();
    }

    private void doConnect() {
        if (this.isClosed()) {
            return;
        }
        try {
            boolean ssl = this.uri.getScheme().equalsIgnoreCase("wss");
            final InetSocketAddress socketAddress = NetworkUtils.getAddress(this.uri, ssl);
            final Options options = NetworkUtils.getOptions(this.uri.getHost(), socketAddress);
            final SslContext sslContext = ssl ? NetworkUtils.getSslContext() : null;
            final Consumer<SocketChannel> proxy = NetworkUtils.getProxyHandler(options, this.timeout);
            if (this.isClosed()) {
                return;
            }
            this.channelFuture = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(NetworkUtils.LOOP_GROUP)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    NetworkUtils.initChannel(ch, Websocket.this.uri, socketAddress, sslContext, proxy, Websocket.this.timeout);
                    String subprotocol = Websocket.this.headers.get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL);
                    NoOriginWebSocketHandshaker handshaker = new NoOriginWebSocketHandshaker(Websocket.this.uri, WebSocketVersion.V13, subprotocol, true, Websocket.this.headers, options.websocketMessage() <= 0 ? 0x40000000 : options.websocketMessage());
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(8192), WebsocketCompressionHandler.INSTANCE, new WebSocketClientProtocolHandler((WebSocketClientHandshaker)handshaker, false, (long)Websocket.this.timeout), new WebsocketHandler(Websocket.this, options)});
                }
            })).remoteAddress((SocketAddress)socketAddress).connect().addListener(c -> {
                if (!c.isSuccess()) {
                    this.failure(NetworkUtils.toFriendlyError(c.cause()));
                }
            });
            this.checkClosed();
        }
        catch (HTTPRequestException e) {
            this.failure(NetworkUtils.toFriendlyError(e));
        }
        catch (Exception e) {
            this.failure(NetworkUtils.toFriendlyError(e));
            LOG.error(Logging.HTTP_ERROR, "Error in websocket", (Throwable)e);
        }
    }

    void success(Options options) {
        if (this.isClosed()) {
            return;
        }
        WebsocketHandle handle = new WebsocketHandle(this.environment, this.address, this, options);
        this.environment().queueEvent("websocket_success", this.address, handle);
        this.createOwnerReference(handle);
        this.checkClosed();
    }

    void failure(String message) {
        if (this.tryClose()) {
            this.environment.queueEvent("websocket_failure", this.address, message);
        }
    }

    void close(int status, String reason) {
        if (this.tryClose()) {
            this.environment.queueEvent("websocket_closed", this.address, Strings.isNullOrEmpty((String)reason) ? null : reason, status < 0 ? null : Integer.valueOf(status));
        }
    }

    @Override
    protected void dispose() {
        super.dispose();
        this.executorFuture = Websocket.closeFuture(this.executorFuture);
        this.channelFuture = Websocket.closeChannel(this.channelFuture);
    }

    IAPIEnvironment environment() {
        return this.environment;
    }

    String address() {
        return this.address;
    }

    @Nullable
    private Channel channel() {
        ChannelFuture channel = this.channelFuture;
        return channel == null ? null : channel.channel();
    }

    @Override
    public void sendText(String message) {
        this.environment.observe(Metrics.WEBSOCKET_OUTGOING, message.length());
        Channel channel = this.channel();
        if (channel != null) {
            channel.writeAndFlush((Object)new TextWebSocketFrame(message));
        }
    }

    @Override
    public void sendBinary(ByteBuffer message) {
        this.environment.observe(Metrics.WEBSOCKET_OUTGOING, message.remaining());
        Channel channel = this.channel();
        if (channel != null) {
            channel.writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((ByteBuffer)message)));
        }
    }
}

