/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.asm;

import dan200.computercraft.api.lua.GenericSource;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.GenericPeripheral;
import dan200.computercraft.api.peripheral.PeripheralType;
import dan200.computercraft.core.asm.Reflect;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GenericMethod {
    private static final Logger LOG = LoggerFactory.getLogger(GenericMethod.class);
    final GenericSource source;
    final Method method;
    final LuaFunction annotation;
    final Class<?> target;
    @Nullable
    final PeripheralType peripheralType;

    private GenericMethod(GenericSource source, Method method, LuaFunction annotation, Class<?> target, @Nullable PeripheralType peripheralType) {
        this.source = source;
        this.method = method;
        this.annotation = annotation;
        this.target = target;
        this.peripheralType = peripheralType;
    }

    public String id() {
        return this.source.id() + "#" + this.name();
    }

    public String name() {
        return this.method.getName();
    }

    public static Stream<GenericMethod> getMethods(GenericSource source) {
        PeripheralType peripheralType;
        Class<?> klass = source.getClass();
        if (source instanceof GenericPeripheral) {
            GenericPeripheral generic = (GenericPeripheral)source;
            peripheralType = generic.getType();
        } else {
            peripheralType = null;
        }
        PeripheralType type = peripheralType;
        return Arrays.stream(klass.getDeclaredMethods()).map(method -> {
            LuaFunction annotation = method.getAnnotation(LuaFunction.class);
            if (annotation == null) {
                return null;
            }
            if (!Modifier.isStatic(method.getModifiers())) {
                LOG.error("GenericSource method {}.{} should be static.", method.getDeclaringClass(), (Object)method.getName());
                return null;
            }
            Type[] types = method.getGenericParameterTypes();
            if (types.length == 0) {
                LOG.error("GenericSource method {}.{} has no parameters.", method.getDeclaringClass(), (Object)method.getName());
                return null;
            }
            Class<?> target = Reflect.getRawType(method, types[0], false);
            if (target == null) {
                return null;
            }
            return new GenericMethod(source, (Method)method, annotation, target, type);
        }).filter(Objects::nonNull);
    }
}

