/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.filesystem;

import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.attribute.FileTime;
import java.time.Instant;

public final class MountHelpers {
    public static final FileTime EPOCH = FileTime.from(Instant.EPOCH);
    public static final long MINIMUM_FILE_SIZE = 500L;
    public static final String NO_SUCH_FILE = "No such file";
    public static final String NOT_A_DIRECTORY = "Not a directory";
    public static final String NOT_A_FILE = "Not a file";
    public static final String ACCESS_DENIED = "Access denied";
    public static final String FILE_EXISTS = "File exists";
    public static final String CANNOT_WRITE_TO_DIRECTORY = "Cannot write to directory";
    public static final String OUT_OF_SPACE = "Out of space";

    private MountHelpers() {
    }

    public static String getReason(FileSystemException exn) {
        if (exn instanceof FileAlreadyExistsException) {
            return FILE_EXISTS;
        }
        if (exn instanceof NoSuchFileException) {
            return NO_SUCH_FILE;
        }
        if (exn instanceof NotDirectoryException) {
            return NOT_A_DIRECTORY;
        }
        if (exn instanceof AccessDeniedException) {
            return ACCESS_DENIED;
        }
        String reason = exn.getReason();
        return reason != null ? reason.trim() : "Operation failed";
    }
}

