/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.lua;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaTable;
import dan200.computercraft.api.lua.LuaValues;
import dan200.computercraft.core.lua.CobaltLuaMachine;
import dan200.computercraft.core.lua.TableImpl;
import java.nio.ByteBuffer;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.LuaInteger;
import org.squiddev.cobalt.LuaNumber;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaUserdata;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.Varargs;

final class VarargArguments
implements IArguments {
    private static final Logger LOG = LoggerFactory.getLogger(VarargArguments.class);
    private static final VarargArguments EMPTY = new VarargArguments(Constants.NONE);
    private static boolean reportedIllegalGet;
    private final Varargs varargs;
    private volatile boolean closed;
    private final VarargArguments root;
    @Nullable
    private ArraySlice<Object> cache;
    @Nullable
    private ArraySlice<String> typeNames;
    private boolean escapes;

    private VarargArguments(Varargs varargs) {
        this.varargs = varargs;
        this.root = this;
    }

    private VarargArguments(Varargs varargs, VarargArguments root, int offset) {
        this.varargs = varargs;
        this.root = root;
        this.escapes = root.escapes;
        this.cache = root.cache == null ? null : root.cache.drop(offset);
        this.typeNames = root.typeNames == null ? null : root.typeNames.drop(offset);
    }

    static VarargArguments of(Varargs values) {
        return values == Constants.NONE ? EMPTY : new VarargArguments(values);
    }

    boolean isClosed() {
        return this.root.closed;
    }

    private void checkAccessible() {
        if (this.isClosed() && !this.escapes) {
            this.throwInaccessible();
        }
    }

    private void throwInaccessible() {
        IllegalStateException error = new IllegalStateException("Function arguments have escaped their original scope.");
        if (!reportedIllegalGet) {
            reportedIllegalGet = true;
            LOG.error("A function attempted to access arguments outside the scope of the original function. This is probably caused by the function scheduling work on the main thread. You may need to call IArguments.escapes().", (Throwable)error);
        }
        throw error;
    }

    @Override
    public int count() {
        return this.varargs.count();
    }

    @Override
    @Nullable
    public Object get(int index) {
        this.checkAccessible();
        if (index < 0 || index >= this.varargs.count()) {
            return null;
        }
        ArraySlice<Object> cache = this.cache;
        if (cache == null) {
            cache = this.cache = new ArraySlice<Object>(new Object[this.varargs.count()], 0);
        } else {
            Object existing = cache.get(index);
            if (existing != null) {
                return existing;
            }
        }
        LuaValue arg = this.varargs.arg(index + 1);
        assert (!this.isClosed() || !(arg instanceof org.squiddev.cobalt.LuaTable)) : "Converting a LuaTable after arguments were closed.";
        Object converted = CobaltLuaMachine.toObject(arg, null);
        cache.set(index, converted);
        return converted;
    }

    @Override
    public String getStringCoerced(int index) {
        this.checkAccessible();
        return this.varargs.arg(index + 1).toString();
    }

    @Override
    public String getType(int index) {
        String name;
        this.checkAccessible();
        LuaValue value = this.varargs.arg(index + 1);
        Object object = this.escapes ? (this.typeNames == null ? null : this.typeNames.get(index)) : (name = VarargArguments.getCustomType(value));
        if (name != null) {
            return name;
        }
        return value.typeName();
    }

    @Override
    public IArguments drop(int count) {
        if (count < 0) {
            throw new IllegalStateException("count cannot be negative");
        }
        if (count == 0) {
            return this;
        }
        Varargs newArgs = this.varargs.subargs(count + 1);
        if (newArgs == Constants.NONE) {
            return EMPTY;
        }
        return new VarargArguments(newArgs, this, count);
    }

    @Override
    public double getDouble(int index) throws LuaException {
        this.checkAccessible();
        LuaValue value = this.varargs.arg(index + 1);
        if (!(value instanceof LuaNumber)) {
            throw LuaValues.badArgument(index, "number", value.typeName());
        }
        return value.toDouble();
    }

    @Override
    public long getLong(int index) throws LuaException {
        this.checkAccessible();
        LuaValue value = this.varargs.arg(index + 1);
        if (!(value instanceof LuaNumber)) {
            throw LuaValues.badArgument(index, "number", value.typeName());
        }
        return value instanceof LuaInteger ? (long)value.toInteger() : (long)LuaValues.checkFinite(index, value.toDouble());
    }

    @Override
    public ByteBuffer getBytes(int index) throws LuaException {
        this.checkAccessible();
        LuaValue value = this.varargs.arg(index + 1);
        if (!(value instanceof LuaString)) {
            throw LuaValues.badArgument(index, "string", value.typeName());
        }
        LuaString str = (LuaString)value;
        return str.toBuffer();
    }

    @Override
    public Optional<ByteBuffer> optBytes(int index) throws LuaException {
        this.checkAccessible();
        LuaValue value = this.varargs.arg(index + 1);
        if (value.isNil()) {
            return Optional.empty();
        }
        if (!(value instanceof LuaString)) {
            throw LuaValues.badArgument(index, "string", value.typeName());
        }
        LuaString str = (LuaString)value;
        return Optional.of(str.toBuffer());
    }

    @Override
    public LuaTable<?, ?> getTableUnsafe(int index) throws LuaException {
        if (this.isClosed()) {
            throw new IllegalStateException("Cannot use getTableUnsafe after IArguments has been closed.");
        }
        LuaValue value = this.varargs.arg(index + 1);
        if (!(value instanceof org.squiddev.cobalt.LuaTable)) {
            throw LuaValues.badArgument(index, "table", value.typeName());
        }
        return new TableImpl(this, (org.squiddev.cobalt.LuaTable)value);
    }

    @Override
    public Optional<LuaTable<?, ?>> optTableUnsafe(int index) throws LuaException {
        if (this.isClosed()) {
            throw new IllegalStateException("Cannot use optTableUnsafe after IArguments has been closed.");
        }
        LuaValue value = this.varargs.arg(index + 1);
        if (value.isNil()) {
            return Optional.empty();
        }
        if (!(value instanceof org.squiddev.cobalt.LuaTable)) {
            throw LuaValues.badArgument(index, "table", value.typeName());
        }
        return Optional.of(new TableImpl(this, (org.squiddev.cobalt.LuaTable)value));
    }

    @Override
    public IArguments escapes() {
        if (this.escapes) {
            return this;
        }
        if (this.isClosed()) {
            throw new IllegalStateException("Cannot call escapes after IArguments has been closed.");
        }
        ArraySlice<Object> cache = this.cache;
        ArraySlice<String> typeNames = this.typeNames;
        int count = this.varargs.count();
        for (int i = 0; i < count; ++i) {
            String typeName;
            LuaValue arg = this.varargs.arg(i + 1);
            if (arg instanceof org.squiddev.cobalt.LuaTable) {
                if (cache == null) {
                    cache = new ArraySlice<Object>(new Object[count], 0);
                }
                cache.set(i, CobaltLuaMachine.toObject(arg, null));
            }
            if ((typeName = VarargArguments.getCustomType(arg)) == null) continue;
            if (typeNames == null) {
                typeNames = new ArraySlice<String>(new String[count], 0);
            }
            typeNames.set(i, typeName);
        }
        this.escapes = true;
        this.cache = cache;
        this.typeNames = typeNames;
        return this;
    }

    void close() {
        this.closed = true;
    }

    @Nullable
    private static String getCustomType(LuaValue arg) {
        String string;
        LuaValue luaValue;
        if (!(arg instanceof org.squiddev.cobalt.LuaTable) && !(arg instanceof LuaUserdata)) {
            return null;
        }
        org.squiddev.cobalt.LuaTable metatable = arg.getMetatable(null);
        if (metatable != null && (luaValue = metatable.rawget((LuaValue)Constants.NAME)) instanceof LuaString) {
            LuaString s = (LuaString)luaValue;
            string = s.toString();
        } else {
            string = null;
        }
        return string;
    }

    static {
        VarargArguments.EMPTY.closed = true;
        VarargArguments.EMPTY.escapes = true;
    }

    private record ArraySlice<T>(T[] array, int offset) {
        @Nullable
        T get(int index) {
            return this.array[this.offset + index];
        }

        void set(int index, @Nullable T value) {
            this.array[this.offset + index] = value;
        }

        ArraySlice<T> drop(int count) {
            return new ArraySlice<T>(this.array, this.offset + count);
        }
    }
}

