/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.client;

import dan200.computercraft.core.util.Nullability;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.client.ClientNetworkContext;
import dan200.computercraft.shared.peripheral.speaker.SpeakerPosition;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_2540;

public class SpeakerAudioClientMessage
implements NetworkMessage<ClientNetworkContext> {
    private final UUID source;
    private final SpeakerPosition.Message pos;
    @Nullable
    private final ByteBuffer content;
    private final float volume;

    public SpeakerAudioClientMessage(UUID source, SpeakerPosition pos, float volume, ByteBuffer content) {
        this.source = source;
        this.pos = pos.asMessage();
        this.content = content;
        this.volume = volume;
    }

    public SpeakerAudioClientMessage(class_2540 buf) {
        this.source = buf.method_10790();
        this.pos = SpeakerPosition.Message.read(buf);
        this.volume = buf.readFloat();
        ClientNetworkContext.get().handleSpeakerAudioPush(this.source, (ByteBuf)buf);
        this.content = null;
    }

    @Override
    public void toBytes(class_2540 buf) {
        buf.method_10797(this.source);
        this.pos.write(buf);
        buf.writeFloat(this.volume);
        buf.writeBytes(Nullability.assertNonNull(this.content).duplicate());
    }

    @Override
    public void handle(ClientNetworkContext context) {
        context.handleSpeakerAudio(this.source, this.pos, this.volume);
    }
}

