/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.generic;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IDynamicPeripheral;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.peripheral.generic.SaturatedMethod;
import dan200.computercraft.shared.platform.RegistryWrappers;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2960;

public final class GenericPeripheral
implements IDynamicPeripheral {
    private final class_2586 tile;
    private final class_2350 side;
    private final String type;
    private final Set<String> additionalTypes;
    private final List<SaturatedMethod> methods;

    GenericPeripheral(class_2586 tile, class_2350 side, @Nullable String name, Set<String> additionalTypes, List<SaturatedMethod> methods) {
        this.side = side;
        class_2960 type = RegistryWrappers.BLOCK_ENTITY_TYPES.getKey(tile.method_11017());
        this.tile = tile;
        this.type = name != null ? name : type.toString();
        this.additionalTypes = additionalTypes;
        this.methods = methods;
    }

    public class_2350 side() {
        return this.side;
    }

    @Override
    public String[] getMethodNames() {
        String[] names = new String[this.methods.size()];
        for (int i = 0; i < this.methods.size(); ++i) {
            names[i] = this.methods.get(i).getName();
        }
        return names;
    }

    @Override
    public MethodResult callMethod(IComputerAccess computer, ILuaContext context, int method, IArguments arguments) throws LuaException {
        return this.methods.get(method).apply(context, computer, arguments);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Set<String> getAdditionalTypes() {
        return this.additionalTypes;
    }

    @Override
    public Object getTarget() {
        return this.tile;
    }

    @Override
    public boolean equals(@Nullable IPeripheral other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GenericPeripheral)) {
            return false;
        }
        GenericPeripheral generic = (GenericPeripheral)other;
        return this.tile == generic.tile && this.methods.equals(generic.methods);
    }
}

