/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import immersive_armors.config.Config;
import immersive_armors.config.configEntries.FloatConfigEntry;
import immersive_armors.config.configEntries.IntegerConfigEntry;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JsonConfig {
    public static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public int version = 0;

    int getVersion() {
        return 1;
    }

    public JsonConfig() {
        for (Field field : Config.class.getDeclaredFields()) {
            for (Annotation annotation : field.getAnnotations()) {
                try {
                    if (annotation instanceof IntegerConfigEntry) {
                        IntegerConfigEntry entry = (IntegerConfigEntry)annotation;
                        field.setInt(this, entry.value());
                        continue;
                    }
                    if (!(annotation instanceof FloatConfigEntry)) continue;
                    FloatConfigEntry entry = (FloatConfigEntry)annotation;
                    field.setFloat(this, entry.value());
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static File getConfigFile() {
        return new File("./config/immersive_armors.json");
    }

    public void save() {
        try (FileWriter writer = new FileWriter(JsonConfig.getConfigFile());){
            this.version = this.getVersion();
            writer.write(this.toJsonString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String toJsonString() {
        return GSON.toJson((Object)this);
    }

    public static Config fromJsonString(String string) {
        return (Config)GSON.fromJson(string, Config.class);
    }

    public static Config loadOrCreate() {
        if (JsonConfig.getConfigFile().exists()) {
            Config config;
            FileReader reader = new FileReader(JsonConfig.getConfigFile());
            try {
                Config config2 = (Config)GSON.fromJson((Reader)reader, Config.class);
                if (config2.version != config2.getVersion()) {
                    config2 = new Config();
                }
                config2.save();
                config = config2;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.error("Failed to load Immersive Armors config! Default config is used for now. Delete the file to reset.");
                    LOGGER.error((Object)e);
                    return new Config();
                }
            }
            reader.close();
            return config;
        }
        Config config = new Config();
        config.save();
        return config;
    }
}

