/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.network;

import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2817;
import net.minecraft.class_2828;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4050;
import net.minecraft.class_634;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import org.vivecraft.client.VRPlayersClient;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.client_vr.settings.AutoCalibration;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.CommonDataHolder;
import org.vivecraft.common.VRServerPerms;
import org.vivecraft.common.network.BufferSerializable;
import org.vivecraft.common.network.CommonNetworkHelper;
import org.vivecraft.common.network.VrPlayerState;

public class ClientNetworking {
    public static boolean displayedChatMessage = false;
    public static boolean displayedChatWarning = false;
    public static boolean serverWantsData = false;
    public static boolean serverAllowsClimbey = false;
    public static boolean serverSupportsDirectTeleport = false;
    public static boolean serverAllowsCrawling = false;
    public static boolean serverAllowsVrSwitching = false;
    public static int usedNetworkVersion = -1;
    private static float worldScallast = 0.0f;
    private static float heightlast = 0.0f;
    private static float capturedYaw;
    private static float capturedPitch;
    private static boolean overrideActive;
    public static boolean needsReset;

    public static class_2817 getVivecraftClientPacket(CommonNetworkHelper.PacketDiscriminators command, byte[] payload) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        buffer.writeByte(command.ordinal());
        buffer.writeBytes(payload);
        return new class_2817(CommonNetworkHelper.CHANNEL, buffer);
    }

    public static class_2817 createVRActivePacket(boolean vrActive) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        buffer.writeByte(CommonNetworkHelper.PacketDiscriminators.IS_VR_ACTIVE.ordinal());
        buffer.writeBoolean(vrActive);
        return new class_2817(CommonNetworkHelper.CHANNEL, buffer);
    }

    public static void resetServerSettings() {
        worldScallast = 0.0f;
        heightlast = 0.0f;
        serverAllowsClimbey = false;
        serverWantsData = false;
        serverSupportsDirectTeleport = false;
        serverAllowsCrawling = false;
        serverAllowsVrSwitching = false;
        usedNetworkVersion = -1;
        VRPlayersClient.clear();
        VRServerPerms.INSTANCE.setTeleportSupported(false);
        if (VRState.vrInitialized) {
            ClientDataHolderVR.getInstance().vrPlayer.setTeleportOverride(false);
        }
        ClientDataHolderVR.getInstance().vrSettings.overrides.resetAll();
    }

    public static void sendVersionInfo() {
        String s = CommonNetworkHelper.CHANNEL.toString();
        class_2540 friendlybytebuf = new class_2540(Unpooled.buffer());
        friendlybytebuf.writeBytes(s.getBytes());
        class_310.method_1551().method_1562().method_2883((class_2596)new class_2817(new class_2960("minecraft:register"), friendlybytebuf));
        class_310.method_1551().method_1562().method_2883((class_2596)ClientNetworking.getVivecraftClientPacket(CommonNetworkHelper.PacketDiscriminators.VERSION, (CommonDataHolder.getInstance().versionIdentifier + (VRState.vrRunning ? " VR" : " NONVR") + "\n0\n0").getBytes(Charsets.UTF_8)));
    }

    public static void sendVRPlayerPositions(VRPlayer vrPlayer) {
        float f1;
        class_634 connection = class_310.method_1551().method_1562();
        if (!serverWantsData || connection == null) {
            return;
        }
        float worldScale = ClientDataHolderVR.getInstance().vrPlayer.vrdata_world_post.worldScale;
        if (worldScale != worldScallast) {
            ByteBuf bytebuf = Unpooled.buffer();
            bytebuf.writeFloat(worldScale);
            byte[] abyte = new byte[bytebuf.readableBytes()];
            bytebuf.readBytes(abyte);
            class_2817 serverboundcustompayloadpacket = ClientNetworking.getVivecraftClientPacket(CommonNetworkHelper.PacketDiscriminators.WORLDSCALE, abyte);
            class_310.method_1551().method_1562().method_2883((class_2596)serverboundcustompayloadpacket);
            worldScallast = worldScale;
        }
        if ((f1 = AutoCalibration.getPlayerHeight()) != heightlast) {
            ByteBuf bytebuf2 = Unpooled.buffer();
            bytebuf2.writeFloat(f1 / 1.52f);
            byte[] abyte3 = new byte[bytebuf2.readableBytes()];
            bytebuf2.readBytes(abyte3);
            class_2817 serverboundcustompayloadpacket1 = ClientNetworking.getVivecraftClientPacket(CommonNetworkHelper.PacketDiscriminators.HEIGHT, abyte3);
            class_310.method_1551().method_1562().method_2883((class_2596)serverboundcustompayloadpacket1);
            heightlast = f1;
        }
        VrPlayerState vrPlayerState = VrPlayerState.create(vrPlayer);
        if (usedNetworkVersion >= 0) {
            connection.method_2883((class_2596)ClientNetworking.createVrPlayerStatePacket(vrPlayerState));
        } else {
            ClientNetworking.sendLegacyPackets(connection, vrPlayerState);
        }
        VRPlayersClient.getInstance().Update(class_310.method_1551().field_1724.method_7334().getId(), vrPlayerState, worldScale, f1 / 1.52f, true);
    }

    private static byte[] serializeToArray(BufferSerializable object, byte[] additionalData) {
        class_2540 tempBuffer = new class_2540(Unpooled.buffer());
        if (additionalData != null) {
            tempBuffer.writeBytes(additionalData);
        }
        object.serialize(tempBuffer);
        byte[] buffer = new byte[tempBuffer.readableBytes()];
        tempBuffer.readBytes(buffer);
        tempBuffer.release();
        return buffer;
    }

    public static class_2817 createVrPlayerStatePacket(VrPlayerState vrPlayerState) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        buffer.writeByte(CommonNetworkHelper.PacketDiscriminators.VR_PLAYER_STATE.ordinal());
        vrPlayerState.serialize(buffer);
        return new class_2817(CommonNetworkHelper.CHANNEL, buffer);
    }

    public static void sendLegacyPackets(class_634 connection, VrPlayerState vrPlayerState) {
        class_2540 controller0Buffer = new class_2540(Unpooled.buffer());
        controller0Buffer.writeByte(CommonNetworkHelper.PacketDiscriminators.CONTROLLER0DATA.ordinal());
        controller0Buffer.writeBoolean(ClientDataHolderVR.getInstance().vrSettings.reverseHands);
        vrPlayerState.controller0().serialize(controller0Buffer);
        connection.method_2883((class_2596)new class_2817(CommonNetworkHelper.CHANNEL, controller0Buffer));
        class_2540 controller1Buffer = new class_2540(Unpooled.buffer());
        controller1Buffer.writeByte(CommonNetworkHelper.PacketDiscriminators.CONTROLLER1DATA.ordinal());
        controller1Buffer.writeBoolean(ClientDataHolderVR.getInstance().vrSettings.reverseHands);
        vrPlayerState.controller1().serialize(controller1Buffer);
        connection.method_2883((class_2596)new class_2817(CommonNetworkHelper.CHANNEL, controller1Buffer));
        class_2540 headBuffer = new class_2540(Unpooled.buffer());
        headBuffer.writeByte(CommonNetworkHelper.PacketDiscriminators.HEADDATA.ordinal());
        headBuffer.writeBoolean(ClientDataHolderVR.getInstance().vrSettings.seated);
        vrPlayerState.hmd().serialize(headBuffer);
        connection.method_2883((class_2596)new class_2817(CommonNetworkHelper.CHANNEL, headBuffer));
    }

    public static boolean isThirdPersonItems() {
        return ClientDataHolderVR.getInstance().vrSettings.overrides.getSetting(VRSettings.VrOptions.THIRDPERSON_ITEMTRANSFORMS).getBoolean();
    }

    public static boolean isLimitedSurvivalTeleport() {
        return ClientDataHolderVR.getInstance().vrSettings.overrides.getSetting(VRSettings.VrOptions.LIMIT_TELEPORT).getBoolean();
    }

    public static int getTeleportUpLimit() {
        return ClientDataHolderVR.getInstance().vrSettings.overrides.getSetting(VRSettings.VrOptions.TELEPORT_UP_LIMIT).getInt();
    }

    public static int getTeleportDownLimit() {
        return ClientDataHolderVR.getInstance().vrSettings.overrides.getSetting(VRSettings.VrOptions.TELEPORT_DOWN_LIMIT).getInt();
    }

    public static int getTeleportHorizLimit() {
        return ClientDataHolderVR.getInstance().vrSettings.overrides.getSetting(VRSettings.VrOptions.TELEPORT_HORIZ_LIMIT).getInt();
    }

    public static void sendActiveHand(byte c) {
        if (serverWantsData) {
            class_2817 serverboundcustompayloadpacket = ClientNetworking.getVivecraftClientPacket(CommonNetworkHelper.PacketDiscriminators.ACTIVEHAND, new byte[]{c});
            if (class_310.method_1551().method_1562() != null) {
                class_310.method_1551().method_1562().method_2883((class_2596)serverboundcustompayloadpacket);
            }
        }
    }

    public static void overridePose(class_746 player) {
        if (ClientDataHolderVR.getInstance().crawlTracker.crawling) {
            player.method_18380(class_4050.field_18079);
        }
    }

    public static void overrideLook(class_1657 player, class_243 view) {
        if (!serverWantsData) {
            capturedPitch = player.method_36455();
            capturedYaw = player.method_36454();
            float f = (float)Math.toDegrees(Math.asin(-view.field_1351 / view.method_1033()));
            float f1 = (float)Math.toDegrees(Math.atan2(-view.field_1352, view.field_1350));
            ((class_746)player).field_3944.method_2883((class_2596)new class_2828.class_2831(f1, f, player.method_24828()));
            overrideActive = true;
        }
    }

    public static void restoreLook(class_1657 player) {
        if (!serverWantsData && overrideActive) {
            ((class_746)player).field_3944.method_2883((class_2596)new class_2828.class_2831(capturedYaw, capturedPitch, player.method_24828()));
            overrideActive = false;
        }
    }

    public static void handlePacket(CommonNetworkHelper.PacketDiscriminators packetID, class_2540 buffer) {
        ClientDataHolderVR dataholder = ClientDataHolderVR.getInstance();
        class_310 mc = class_310.method_1551();
        switch (packetID) {
            case VERSION: {
                String s11 = buffer.method_10800(1024);
                VRServerPerms.INSTANCE.setTeleportSupported(true);
                if (VRState.vrInitialized) {
                    dataholder.vrPlayer.teleportWarning = false;
                    dataholder.vrPlayer.vrSwitchWarning = true;
                }
                if (!displayedChatMessage && (dataholder.vrSettings.showServerPluginMessage == VRSettings.ChatServerPluginMessage.ALWAYS || dataholder.vrSettings.showServerPluginMessage == VRSettings.ChatServerPluginMessage.SERVER_ONLY && !class_310.method_1551().method_1542())) {
                    displayedChatMessage = true;
                    mc.field_1705.method_1743().method_1812((class_2561)class_2561.method_43469((String)"vivecraft.messages.serverplugin", (Object[])new Object[]{s11}));
                }
                if (!VRState.vrEnabled || dataholder.vrSettings.manualCalibration != -1.0f || dataholder.vrSettings.seated) break;
                mc.field_1705.method_1743().method_1812((class_2561)class_2561.method_43471((String)"vivecraft.messages.calibrateheight"));
                break;
            }
            case IS_VR_ACTIVE: {
                if (buffer.readBoolean()) break;
                VRPlayersClient.getInstance().disableVR(buffer.method_10790());
                break;
            }
            case REQUESTDATA: {
                serverWantsData = true;
                break;
            }
            case CLIMBING: {
                serverAllowsClimbey = buffer.readBoolean();
                if (buffer.readableBytes() <= 0) break;
                dataholder.climbTracker.serverblockmode = buffer.readByte();
                dataholder.climbTracker.blocklist.clear();
                while (buffer.readableBytes() > 0) {
                    String s12 = buffer.method_10800(16384);
                    class_2248 block = (class_2248)class_7923.field_41175.method_10223(new class_2960(s12));
                    if (block == class_2246.field_10124) continue;
                    dataholder.climbTracker.blocklist.add(block);
                }
                break;
            }
            case TELEPORT: {
                serverSupportsDirectTeleport = true;
                break;
            }
            case UBERPACKET: {
                UUID uuid = buffer.method_10790();
                VrPlayerState vrPlayerState = VrPlayerState.deserialize(buffer);
                float worldScale = buffer.readFloat();
                float heightScale = buffer.readFloat();
                VRPlayersClient.getInstance().Update(uuid, vrPlayerState, worldScale, heightScale);
                break;
            }
            case SETTING_OVERRIDE: {
                while (buffer.readableBytes() > 0) {
                    String s13 = buffer.method_10800(16384);
                    String s14 = buffer.method_10800(16384);
                    String[] astring = s13.split("\\.", 2);
                    if (!dataholder.vrSettings.overrides.hasSetting(astring[0])) continue;
                    VRSettings.ServerOverrides.Setting vrsettings$serveroverrides$setting = dataholder.vrSettings.overrides.getSetting(astring[0]);
                    try {
                        if (astring.length > 1) {
                            String s15;
                            switch (s15 = astring[1]) {
                                case "min": {
                                    vrsettings$serveroverrides$setting.setValueMin(Float.parseFloat(s14));
                                    break;
                                }
                                case "max": {
                                    vrsettings$serveroverrides$setting.setValueMax(Float.parseFloat(s14));
                                }
                            }
                        } else {
                            Object object = vrsettings$serveroverrides$setting.getOriginalValue();
                            if (object instanceof Boolean) {
                                vrsettings$serveroverrides$setting.setValue(s14.equals("true"));
                            } else if (!(object instanceof Integer || object instanceof Byte || object instanceof Short)) {
                                if (!(object instanceof Float) && !(object instanceof Double)) {
                                    vrsettings$serveroverrides$setting.setValue(s14);
                                } else {
                                    vrsettings$serveroverrides$setting.setValue(Float.valueOf(Float.parseFloat(s14)));
                                }
                            } else {
                                vrsettings$serveroverrides$setting.setValue(Integer.parseInt(s14));
                            }
                        }
                        System.out.println("Server setting override: " + s13 + " = " + s14);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                break;
            }
            case CRAWL: {
                serverAllowsCrawling = true;
                break;
            }
            case NETWORK_VERSION: {
                usedNetworkVersion = buffer.readByte() & 0xFF;
                break;
            }
            case VR_SWITCHING: {
                serverAllowsVrSwitching = buffer.readBoolean();
                if (!VRState.vrInitialized) break;
                if (!serverAllowsVrSwitching) {
                    class_310.method_1551().field_1705.method_1743().method_1812((class_2561)class_2561.method_43471((String)"vivecraft.messages.novrhotswitching"));
                }
                dataholder.vrPlayer.vrSwitchWarning = false;
            }
        }
    }

    static {
        needsReset = true;
    }
}

