/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.utils.math;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class BezierCurve {
    public ArrayList<Node> nodes = new ArrayList();
    boolean circular;

    public BezierCurve(Node[] nodes, boolean circular) {
        this.nodes.addAll(Arrays.asList(nodes));
        this.circular = circular;
    }

    public BezierCurve(boolean circular) {
        this.circular = circular;
    }

    class_243 getIntermediate(Node n1, Node n2, double perc) {
        class_243 vec3 = n1.vertex;
        class_243 vec31 = n1.controlOut;
        class_243 vec32 = n2.controlIn;
        class_243 vec33 = n2.vertex;
        return vec3.method_1021(Math.pow(1.0 - perc, 3.0)).method_1019(vec31.method_1021(3.0 * Math.pow(1.0 - perc, 2.0) * perc)).method_1019(vec32.method_1021(3.0 * (1.0 - perc) * Math.pow(perc, 2.0))).method_1019(vec33.method_1021(Math.pow(perc, 3.0)));
    }

    public class_243 getPointOnPath(double perc) {
        int k;
        int i = this.circular ? this.nodes.size() : this.nodes.size() - 1;
        double d0 = perc * (double)i;
        int j = (int)Math.floor(d0) % this.nodes.size();
        if (j == (k = (int)Math.ceil(d0) % this.nodes.size())) {
            return this.nodes.get((int)j).vertex;
        }
        Node beziercurve$node = this.nodes.get(j);
        Node beziercurve$node1 = this.nodes.get(k);
        return this.getIntermediate(beziercurve$node, beziercurve$node1, d0 - (double)j);
    }

    public class_243[] getLinearInterpolation(int verticesPerNode) {
        if (this.nodes.size() == 0) {
            return new class_243[0];
        }
        int i = verticesPerNode * (this.circular ? this.nodes.size() : this.nodes.size() - 1) + 1;
        class_243[] avec3 = new class_243[i];
        for (int j = 0; j < i; ++j) {
            double d0 = (double)j / (double)Math.max(1, i - 1);
            avec3[j] = this.getPointOnPath(d0);
        }
        return avec3;
    }

    public void render(int vertexCount, Color c, float partialTicks) {
        class_746 player = class_310.method_1551().field_1724;
        double d0 = player.field_6038 + (player.method_23317() - player.field_6038) * (double)partialTicks;
        double d1 = player.field_5971 + (player.method_23318() - player.field_5971) * (double)partialTicks;
        double d2 = player.field_5989 + (player.method_23321() - player.field_5989) * (double)partialTicks;
        RenderSystem.depthMask((boolean)false);
        class_289 tesselator = class_289.method_1348();
        class_287 bufferbuilder = tesselator.method_1349();
        bufferbuilder.method_1328(class_293.class_5596.field_27377, class_290.field_1576);
        class_243[] avec3 = this.getLinearInterpolation(vertexCount / this.nodes.size());
        for (int i = 0; i < avec3.length; ++i) {
            this.renderVertex(bufferbuilder, avec3[i], c, d0, d1, d2);
        }
        tesselator.method_1350();
        RenderSystem.depthMask((boolean)true);
    }

    void renderVertex(class_287 buffer, class_243 vert, Color color, double offX, double offY, double offZ) {
        buffer.method_22912(vert.field_1352 - offX, vert.field_1351 - offY, vert.field_1350 - offZ).method_1336(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_1344();
    }

    public static class Node {
        class_243 vertex;
        class_243 controlIn;
        class_243 controlOut;

        public Node(class_243 vertex, class_243 controlIn, class_243 controlOut) {
            this.vertex = vertex;
            this.controlIn = controlIn;
            this.controlOut = controlOut;
        }

        public Node(class_243 vertex, class_243 controlDir, double controlLenIn, double controlLenOut) {
            this(vertex, vertex.method_1019(controlDir.method_1029().method_1021(-controlLenIn)), vertex.method_1019(controlDir.method_1029().method_1021(controlLenOut)));
        }
    }
}

