/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.provider.openvr_lwjgl;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sun.jna.NativeLibrary;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import net.minecraft.class_1074;
import net.minecraft.class_1078;
import net.minecraft.class_156;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3675;
import org.joml.Vector2f;
import org.lwjgl.openvr.HmdMatrix34;
import org.lwjgl.openvr.InputAnalogActionData;
import org.lwjgl.openvr.InputDigitalActionData;
import org.lwjgl.openvr.InputOriginInfo;
import org.lwjgl.openvr.InputPoseActionData;
import org.lwjgl.openvr.OpenVR;
import org.lwjgl.openvr.RenderModelComponentState;
import org.lwjgl.openvr.RenderModelControllerModeState;
import org.lwjgl.openvr.Texture;
import org.lwjgl.openvr.TrackedDevicePose;
import org.lwjgl.openvr.VR;
import org.lwjgl.openvr.VRActiveActionSet;
import org.lwjgl.openvr.VRApplications;
import org.lwjgl.openvr.VRChaperone;
import org.lwjgl.openvr.VRCompositor;
import org.lwjgl.openvr.VREvent;
import org.lwjgl.openvr.VRInput;
import org.lwjgl.openvr.VRRenderModels;
import org.lwjgl.openvr.VRSettings;
import org.lwjgl.openvr.VRSystem;
import org.lwjgl.openvr.VRTextureBounds;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client.utils.Utils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.gameplay.screenhandlers.KeyboardHandler;
import org.vivecraft.client_vr.gameplay.screenhandlers.RadialHandler;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.client_vr.provider.HardwareType;
import org.vivecraft.client_vr.provider.InputSimulator;
import org.vivecraft.client_vr.provider.MCVR;
import org.vivecraft.client_vr.provider.VRRenderer;
import org.vivecraft.client_vr.provider.openvr_lwjgl.OpenVRHapticScheduler;
import org.vivecraft.client_vr.provider.openvr_lwjgl.OpenVRStereoRenderer;
import org.vivecraft.client_vr.provider.openvr_lwjgl.OpenVRUtil;
import org.vivecraft.client_vr.provider.openvr_lwjgl.VRInputAction;
import org.vivecraft.client_vr.provider.openvr_lwjgl.control.TrackpadSwipeSampler;
import org.vivecraft.client_vr.provider.openvr_lwjgl.control.VRInputActionSet;
import org.vivecraft.client_vr.render.RenderConfigException;
import org.vivecraft.client_vr.settings.VRHotkeys;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.client_vr.utils.external.jinfinadeck;
import org.vivecraft.client_vr.utils.external.jkatvr;
import org.vivecraft.common.utils.math.Matrix4f;
import org.vivecraft.common.utils.math.Vector3;

public class MCOpenVR
extends MCVR {
    public static final int LEFT_CONTROLLER = 1;
    public static final int RIGHT_CONTROLLER = 0;
    public static final int THIRD_CONTROLLER = 2;
    protected static MCOpenVR ome;
    private final String ACTION_EXTERNAL_CAMERA = "/actions/mixedreality/in/externalcamera";
    private final String ACTION_LEFT_HAND = "/actions/global/in/lefthand";
    private final String ACTION_LEFT_HAPTIC = "/actions/global/out/lefthaptic";
    private final String ACTION_RIGHT_HAND = "/actions/global/in/righthand";
    private final String ACTION_RIGHT_HAPTIC = "/actions/global/out/righthaptic";
    private final Map<VRInputActionSet, Long> actionSetHandles = new EnumMap<VRInputActionSet, Long>(VRInputActionSet.class);
    private VRActiveActionSet.Buffer activeActionSetsBuffer;
    private Map<Long, String> controllerComponentNames;
    private Map<String, Matrix4f[]> controllerComponentTransforms;
    private boolean dbg = true;
    private long externalCameraPoseHandle;
    private final int[] controllerDeviceIndex = new int[3];
    private boolean getXforms = true;
    private final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final IntBuffer hmdErrorStore = MemoryUtil.memCallocInt((int)1);
    private IntBuffer hmdErrorStoreBuf;
    private TrackedDevicePose.Buffer hmdTrackedDevicePoses;
    private boolean inputInitialized;
    private long leftControllerHandle;
    private long leftHapticHandle;
    private long leftPoseHandle;
    private final InputOriginInfo originInfo;
    private boolean paused = false;
    private final InputPoseActionData poseData;
    private long rightControllerHandle;
    private long rightHapticHandle;
    private long rightPoseHandle;
    private final VRTextureBounds texBounds = VRTextureBounds.calloc();
    private final Map<String, TrackpadSwipeSampler> trackpadSwipeSamplers = new HashMap<String, TrackpadSwipeSampler>();
    private boolean tried;
    private final Queue<VREvent> vrEvents = new LinkedList<VREvent>();
    final Texture texType0 = Texture.calloc();
    final Texture texType1 = Texture.calloc();
    InputDigitalActionData digital = InputDigitalActionData.calloc();
    InputAnalogActionData analog = InputAnalogActionData.calloc();
    private static final Map<String, String> steamLanguages;
    private static final Map<String, String> steamLanguageWrongMappings;

    public MCOpenVR(class_310 mc, ClientDataHolderVR dh) {
        super(mc, dh, VivecraftVRMod.INSTANCE);
        ome = this;
        this.hapticScheduler = new OpenVRHapticScheduler();
        for (int i = 0; i < 3; ++i) {
            this.controllerDeviceIndex[i] = -1;
        }
        this.poseData = InputPoseActionData.calloc();
        this.originInfo = InputOriginInfo.calloc();
    }

    public static MCOpenVR get() {
        return ome;
    }

    static String getInputErrorName(int code) {
        switch (code) {
            case 0: {
                return "wat";
            }
            case 1: {
                return "NameNotFound";
            }
            case 2: {
                return "WrongType";
            }
            case 3: {
                return "InvalidHandle";
            }
            case 4: {
                return "InvalidParam";
            }
            case 5: {
                return "NoSteam";
            }
            case 6: {
                return "MaxCapacityReached";
            }
            case 7: {
                return "IPCError";
            }
            case 8: {
                return "NoActiveActionSet";
            }
            case 9: {
                return "InvalidDevice";
            }
            case 10: {
                return "InvalidSkeleton";
            }
            case 11: {
                return "InvalidBoneCount";
            }
            case 12: {
                return "InvalidCompressedData";
            }
            case 13: {
                return "NoData";
            }
            case 14: {
                return "BufferTooSmall";
            }
            case 15: {
                return "MismatchedActionManifest";
            }
            case 16: {
                return "MissingSkeletonData";
            }
            case 17: {
                return "InvalidBoneIndex";
            }
        }
        return "Unknown";
    }

    @Override
    public void destroy() {
        if (this.initialized) {
            try {
                VR.VR_ShutdownInternal();
                this.initialized = false;
                if (ClientDataHolderVR.katvr) {
                    jkatvr.Halt();
                }
                if (ClientDataHolderVR.infinadeck) {
                    jinfinadeck.Destroy();
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    @Override
    public String getID() {
        return "openvr_lwjgl";
    }

    @Override
    public String getName() {
        return "OpenVR_LWJGL";
    }

    @Override
    public Vector2f getPlayAreaSize() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            if (OpenVR.VRChaperone != null && OpenVR.VRChaperone.GetPlayAreaSize != 0L) {
                FloatBuffer pSizeZ = stack.callocFloat(1);
                FloatBuffer pSizeX = stack.callocFloat(1);
                boolean b0 = VRChaperone.VRChaperone_GetPlayAreaSize((FloatBuffer)pSizeX, (FloatBuffer)pSizeZ);
                Vector2f vector2f = b0 ? new Vector2f(pSizeX.get(0) * this.dh.vrSettings.walkMultiplier, pSizeZ.get(0) * this.dh.vrSettings.walkMultiplier) : null;
                return vector2f;
            }
            Vector2f vector2f = null;
            return vector2f;
        }
    }

    @Override
    public boolean init() {
        if (this.initialized) {
            return true;
        }
        if (this.tried) {
            return this.initialized;
        }
        this.tried = true;
        this.mc = class_310.method_1551();
        try {
            this.initializeOpenVR();
            this.initOpenVRCompositor();
        }
        catch (Exception exception2) {
            exception2.printStackTrace();
            this.initSuccess = false;
            this.initStatus = exception2.getLocalizedMessage();
            return false;
        }
        if (OpenVR.VRInput == null) {
            System.out.println("Controller input not available. Forcing seated mode.");
            this.dh.vrSettings.seated = true;
        }
        System.out.println("OpenVR initialized & VR connected.");
        this.deviceVelocity = new class_243[64];
        for (int i = 0; i < this.poseMatrices.length; ++i) {
            this.poseMatrices[i] = new Matrix4f();
            this.deviceVelocity[i] = new class_243(0.0, 0.0, 0.0);
        }
        this.initialized = true;
        if (ClientDataHolderVR.katvr) {
            try {
                System.out.println("Waiting for KATVR....");
                Utils.unpackNatives("katvr");
                NativeLibrary.addSearchPath((String)"WalkerBase.dll", (String)new File("openvr/katvr").getAbsolutePath());
                jkatvr.Init(1);
                jkatvr.Launch();
                if (jkatvr.CheckForLaunch()) {
                    System.out.println("KATVR Loaded");
                } else {
                    System.out.println("KATVR Failed to load");
                }
            }
            catch (Exception exception1) {
                System.out.println("KATVR crashed: " + exception1.getMessage());
            }
        }
        if (ClientDataHolderVR.infinadeck) {
            try {
                System.out.println("Waiting for Infinadeck....");
                Utils.unpackNatives("infinadeck");
                NativeLibrary.addSearchPath((String)"InfinadeckAPI.dll", (String)new File("openvr/infinadeck").getAbsolutePath());
                if (jinfinadeck.InitConnection()) {
                    jinfinadeck.CheckConnection();
                    System.out.println("Infinadeck Loaded");
                } else {
                    System.out.println("Infinadeck Failed to load");
                }
            }
            catch (Exception exception) {
                System.out.println("Infinadeck crashed: " + exception.getMessage());
            }
        }
        return true;
    }

    @Override
    public void poll(long frameIndex) {
        if (this.initialized) {
            this.paused = VRSystem.VRSystem_ShouldApplicationPause();
            this.mc.method_16011().method_15396("events");
            this.pollVREvents();
            if (!this.dh.vrSettings.seated) {
                this.mc.method_16011().method_15405("controllers");
                this.mc.method_16011().method_15396("gui");
                if (this.mc.field_1755 == null && this.dh.vrSettings.vrTouchHotbar) {
                    org.vivecraft.client_vr.settings.VRSettings vrsettings = this.dh.vrSettings;
                    if (this.dh.vrSettings.vrHudLockMode != VRSettings.HUDLock.HEAD && this.hudPopup) {
                        this.processHotbar();
                    }
                }
                this.mc.method_16011().method_15407();
            }
            this.mc.method_16011().method_15405("processEvents");
            this.processVREvents();
            this.mc.method_16011().method_15405("updatePose/Vsync");
            this.updatePose();
            this.mc.method_16011().method_15405("processInputs");
            this.processInputs();
            this.mc.method_16011().method_15405("hmdSampling");
            this.hmdSampling();
            this.mc.method_16011().method_15407();
        }
    }

    @Override
    public void processInputs() {
        if (!this.dh.vrSettings.seated && !ClientDataHolderVR.viewonly && this.inputInitialized) {
            for (VRInputAction vrinputaction : this.inputActions.values()) {
                if (vrinputaction.isHanded()) {
                    for (ControllerType controllertype : ControllerType.values()) {
                        vrinputaction.setCurrentHand(controllertype);
                        this.processInputAction(vrinputaction);
                    }
                    continue;
                }
                this.processInputAction(vrinputaction);
            }
            this.processScrollInput(GuiHandler.keyScrollAxis, () -> InputSimulator.scrollMouse(0.0, 1.0), () -> InputSimulator.scrollMouse(0.0, -1.0));
            this.processScrollInput(VivecraftVRMod.INSTANCE.keyHotbarScroll, () -> this.changeHotbar(-1), () -> this.changeHotbar(1));
            this.processSwipeInput(VivecraftVRMod.INSTANCE.keyHotbarSwipeX, () -> this.changeHotbar(1), () -> this.changeHotbar(-1), null, null);
            this.processSwipeInput(VivecraftVRMod.INSTANCE.keyHotbarSwipeY, null, null, () -> this.changeHotbar(-1), () -> this.changeHotbar(1));
            this.ignorePressesNextFrame = false;
        }
    }

    @Override
    @Deprecated
    protected void triggerBindingHapticPulse(class_304 binding, int duration) {
        ControllerType controllertype = this.findActiveBindingControllerType(binding);
        if (controllertype != null) {
            this.triggerHapticPulse(controllertype, duration);
        }
    }

    private boolean isError() {
        return this.hmdErrorStore.get(0) != 0 || this.hmdErrorStoreBuf.get(0) != 0;
    }

    private void debugOut(int deviceindex) {
    }

    @Override
    protected ControllerType findActiveBindingControllerType(class_304 binding) {
        if (!this.inputInitialized) {
            return null;
        }
        long i = this.getInputAction(binding).getLastOrigin();
        return i != 0L ? this.getOriginControllerType(i) : null;
    }

    private void generateActionManifest() {
        HashMap map = new HashMap();
        ArrayList<ImmutableMap> actionSets = new ArrayList<ImmutableMap>();
        for (VRInputActionSet actionSet : VRInputActionSet.values()) {
            String usage = actionSet.usage;
            if (actionSet.advanced && !this.dh.vrSettings.allowAdvancedBindings) {
                usage = "hidden";
            }
            actionSets.add(ImmutableMap.builder().put((Object)"name", (Object)actionSet.name).put((Object)"usage", (Object)usage).build());
        }
        map.put("action_sets", actionSets);
        ArrayList sortedActions = new ArrayList(this.inputActions.values());
        sortedActions.sort(Comparator.comparing(action -> action.keyBinding));
        ArrayList<ImmutableMap> actions = new ArrayList<ImmutableMap>();
        for (VRInputAction action2 : sortedActions) {
            actions.add(ImmutableMap.builder().put((Object)"name", (Object)action2.name).put((Object)"requirement", (Object)action2.requirement).put((Object)"type", (Object)action2.type).build());
        }
        actions.add(ImmutableMap.builder().put((Object)"name", (Object)"/actions/global/in/lefthand").put((Object)"requirement", (Object)"suggested").put((Object)"type", (Object)"pose").build());
        actions.add(ImmutableMap.builder().put((Object)"name", (Object)"/actions/global/in/righthand").put((Object)"requirement", (Object)"suggested").put((Object)"type", (Object)"pose").build());
        actions.add(ImmutableMap.builder().put((Object)"name", (Object)"/actions/mixedreality/in/externalcamera").put((Object)"requirement", (Object)"optional").put((Object)"type", (Object)"pose").build());
        actions.add(ImmutableMap.builder().put((Object)"name", (Object)"/actions/global/out/lefthaptic").put((Object)"requirement", (Object)"suggested").put((Object)"type", (Object)"vibration").build());
        actions.add(ImmutableMap.builder().put((Object)"name", (Object)"/actions/global/out/righthaptic").put((Object)"requirement", (Object)"suggested").put((Object)"type", (Object)"vibration").build());
        map.put("actions", actions);
        ArrayList<Object> languages = new ArrayList<Object>();
        languages.add("en_US");
        boolean gotRegistryValue = false;
        if (class_156.method_668() == class_156.class_158.field_1133) {
            String language = Utils.readWinRegistry("HKCU\\SOFTWARE\\Valve\\Steam\\Language");
            if (language != null) {
                gotRegistryValue = true;
                org.vivecraft.client_vr.settings.VRSettings.logger.info("Steam language setting: {}", (Object)language);
                if (!language.equals("english") && steamLanguages.containsKey(language)) {
                    languages.add(steamLanguages.get(language));
                }
            } else {
                org.vivecraft.client_vr.settings.VRSettings.logger.warn("Unable to read Steam language setting");
            }
        }
        if (!gotRegistryValue && !this.mc.field_1690.field_1883.startsWith("en_")) {
            String ucLanguageCode = this.mc.field_1690.field_1883.substring(0, this.mc.field_1690.field_1883.indexOf(95)) + this.mc.field_1690.field_1883.substring(this.mc.field_1690.field_1883.indexOf(95)).toUpperCase();
            if (steamLanguages.containsValue(ucLanguageCode)) {
                languages.add(ucLanguageCode);
            } else {
                Optional<String> langCode = steamLanguages.values().stream().filter(s -> ucLanguageCode.substring(0, ucLanguageCode.indexOf(95)).equals(s.substring(0, s.indexOf(95)))).findFirst();
                langCode.ifPresent(languages::add);
            }
        }
        ArrayList localeList = new ArrayList();
        for (String string : languages) {
            HashMap<String, Object> localeMap = new HashMap<String, Object>();
            ArrayList<String> langs = new ArrayList<String>();
            langs.add("en_us");
            if (!string.equals("en_US")) {
                langs.add(string.toLowerCase());
            }
            class_1078 lang = class_1078.method_4675((class_3300)this.mc.method_1478(), langs, (boolean)false);
            for (VRInputAction action3 : sortedActions) {
                localeMap.put(action3.name, lang.method_48307(action3.keyBinding.method_1423()) + " - " + lang.method_48307(action3.keyBinding.method_1431()));
            }
            for (VRInputActionSet actionSet : VRInputActionSet.values()) {
                localeMap.put(actionSet.name, lang.method_48307(actionSet.localizedName));
            }
            localeMap.put("/actions/global/in/lefthand", "Left Hand Pose");
            localeMap.put("/actions/global/in/righthand", "Right Hand Pose");
            localeMap.put("/actions/mixedreality/in/externalcamera", "External Camera");
            localeMap.put("/actions/global/out/lefthaptic", "Left Hand Haptic");
            localeMap.put("/actions/global/out/righthaptic", "Right Hand Haptic");
            localeMap.put("language_tag", steamLanguageWrongMappings.getOrDefault(string, string));
            localeList.add(localeMap);
        }
        map.put("localization", localeList);
        ArrayList<ImmutableMap> defaults = new ArrayList<ImmutableMap>();
        defaults.add(ImmutableMap.builder().put((Object)"controller_type", (Object)"vive_controller").put((Object)"binding_url", (Object)"vive_defaults.json").build());
        defaults.add(ImmutableMap.builder().put((Object)"controller_type", (Object)"oculus_touch").put((Object)"binding_url", (Object)"oculus_defaults.json").build());
        defaults.add(ImmutableMap.builder().put((Object)"controller_type", (Object)"holographic_controller").put((Object)"binding_url", (Object)"wmr_defaults.json").build());
        defaults.add(ImmutableMap.builder().put((Object)"controller_type", (Object)"knuckles").put((Object)"binding_url", (Object)"knuckles_defaults.json").build());
        defaults.add(ImmutableMap.builder().put((Object)"controller_type", (Object)"vive_cosmos_controller").put((Object)"binding_url", (Object)"cosmos_defaults.json").build());
        defaults.add(ImmutableMap.builder().put((Object)"controller_type", (Object)"vive_tracker_camera").put((Object)"binding_url", (Object)"tracker_defaults.json").build());
        map.put("default_bindings", defaults);
        try {
            new File("openvr/input").mkdirs();
            try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream("openvr/input/action_manifest.json"), StandardCharsets.UTF_8);){
                this.GSON.toJson(map, (Appendable)outputStreamWriter);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to write action manifest", exception);
        }
        String string = this.dh.vrSettings.reverseHands ? "_reversed" : "";
        Utils.loadAssetToFile("input/vive_defaults" + string + ".json", new File("openvr/input/vive_defaults.json"), false);
        Utils.loadAssetToFile("input/oculus_defaults" + string + ".json", new File("openvr/input/oculus_defaults.json"), false);
        Utils.loadAssetToFile("input/wmr_defaults" + string + ".json", new File("openvr/input/wmr_defaults.json"), false);
        Utils.loadAssetToFile("input/knuckles_defaults" + string + ".json", new File("openvr/input/knuckles_defaults.json"), false);
        Utils.loadAssetToFile("input/cosmos_defaults" + string + ".json", new File("openvr/input/cosmos_defaults.json"), false);
        Utils.loadAssetToFile("input/tracker_defaults.json", new File("openvr/input/tracker_defaults.json"), false);
    }

    private long getActionHandle(String name) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            LongBuffer longbyreference = stack.callocLong(1);
            int i = VRInput.VRInput_GetActionHandle((CharSequence)name, (LongBuffer)longbyreference);
            if (i != 0) {
                throw new RuntimeException("Error getting action handle for '" + name + "': " + MCOpenVR.getInputErrorName(i));
            }
            long l = longbyreference.get(0);
            return l;
        }
    }

    private boolean updateActiveActionSets() {
        ArrayList<VRInputActionSet> arraylist = new ArrayList<VRInputActionSet>();
        arraylist.add(VRInputActionSet.GLOBAL);
        arraylist.add(VRInputActionSet.MOD);
        arraylist.add(VRInputActionSet.MIXED_REALITY);
        arraylist.add(VRInputActionSet.TECHNICAL);
        if (this.mc.field_1755 == null) {
            arraylist.add(VRInputActionSet.INGAME);
            arraylist.add(VRInputActionSet.CONTEXTUAL);
        } else {
            arraylist.add(VRInputActionSet.GUI);
            if (ClientDataHolderVR.getInstance().vrSettings.ingameBindingsInGui) {
                arraylist.add(VRInputActionSet.INGAME);
            }
        }
        if (KeyboardHandler.Showing || RadialHandler.isShowing()) {
            arraylist.add(VRInputActionSet.KEYBOARD);
        }
        if (this.activeActionSetsBuffer == null) {
            this.activeActionSetsBuffer = VRActiveActionSet.calloc((int)arraylist.size());
        } else if (this.activeActionSetsBuffer.capacity() != arraylist.size()) {
            this.activeActionSetsBuffer.close();
            this.activeActionSetsBuffer = VRActiveActionSet.calloc((int)arraylist.size());
        }
        for (int i = 0; i < arraylist.size(); ++i) {
            VRInputActionSet vrinputactionset = (VRInputActionSet)((Object)arraylist.get(i));
            ((VRActiveActionSet)this.activeActionSetsBuffer.get(i)).set(this.getActionSetHandle(vrinputactionset), 0L, 0L, 0);
        }
        return !arraylist.isEmpty();
    }

    @Override
    public Matrix4f getControllerComponentTransform(int controllerIndex, String componenetName) {
        return this.controllerComponentTransforms != null && this.controllerComponentTransforms.containsKey(componenetName) && this.controllerComponentTransforms.get(componenetName)[controllerIndex] != null ? this.controllerComponentTransforms.get(componenetName)[controllerIndex] : Utils.Matrix4fSetIdentity(new Matrix4f());
    }

    private Matrix4f getControllerComponentTransformFromButton(int controllerIndex, long button) {
        return this.controllerComponentNames != null && this.controllerComponentNames.containsKey(button) ? this.getControllerComponentTransform(controllerIndex, this.controllerComponentNames.get(button)) : new Matrix4f();
    }

    private int getError() {
        return this.hmdErrorStore.get(0) != 0 ? this.hmdErrorStore.get(0) : this.hmdErrorStoreBuf.get(0);
    }

    long getHapticHandle(ControllerType hand) {
        return hand == ControllerType.RIGHT ? this.rightHapticHandle : this.leftHapticHandle;
    }

    public String memUTF8NullTerminated(ByteBuffer buf) {
        return MemoryUtil.memUTF8((long)MemoryUtil.memAddress((ByteBuffer)buf));
    }

    @Override
    public String getOriginName(long handle) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            ByteBuffer str = stack.calloc(32768);
            int i = VRInput.VRInput_GetOriginLocalizedName((long)handle, (ByteBuffer)str, (int)5);
            if (i != 0) {
                throw new RuntimeException("Error getting origin name: " + MCOpenVR.getInputErrorName(i));
            }
            String string = this.memUTF8NullTerminated(str);
            return string;
        }
    }

    float getSuperSampling() {
        return OpenVR.VRSettings == null ? -1.0f : VRSettings.VRSettings_GetFloat((CharSequence)"steamvr", (CharSequence)"supersampleScale", (IntBuffer)this.hmdErrorStore);
    }

    private void getTransforms() {
        if (OpenVR.VRRenderModels != null) {
            if (this.getXforms) {
                this.controllerComponentTransforms = new HashMap<String, Matrix4f[]>();
            }
            if (this.controllerComponentNames == null) {
                this.controllerComponentNames = new HashMap<Long, String>();
            }
            int i = VRRenderModels.VRRenderModels_GetRenderModelCount();
            ArrayList<String> list = new ArrayList<String>();
            list.add("tip");
            list.add("handgrip");
            boolean flag = false;
            for (String s : list) {
                this.controllerComponentTransforms.put(s, new Matrix4f[2]);
                for (int j = 0; j < 2; ++j) {
                    if (this.controllerDeviceIndex[j] == -1) {
                        flag = true;
                        continue;
                    }
                    try (MemoryStack stack = MemoryStack.stackPush();){
                        long l;
                        long k;
                        ByteBuffer stringBuffer = stack.calloc(32768);
                        VRSystem.VRSystem_GetStringTrackedDeviceProperty((int)this.controllerDeviceIndex[j], (int)1003, (ByteBuffer)stringBuffer, (IntBuffer)this.hmdErrorStore);
                        String renderModelName = this.memUTF8NullTerminated(stringBuffer);
                        VRSystem.VRSystem_GetStringTrackedDeviceProperty((int)this.controllerDeviceIndex[j], (int)1037, (ByteBuffer)stringBuffer, (IntBuffer)this.hmdErrorStore);
                        String inputProfilePath = this.memUTF8NullTerminated(stringBuffer);
                        boolean flag1 = inputProfilePath.contains("holographic");
                        boolean flag2 = inputProfilePath.contains("rifts");
                        String componentName = s;
                        if (flag1 && s.equals("handgrip")) {
                            componentName = "body";
                        }
                        if ((k = VRRenderModels.VRRenderModels_GetComponentButtonMask((CharSequence)renderModelName, (CharSequence)componentName)) > 0L) {
                            this.controllerComponentNames.put(k, s);
                        }
                        long l2 = l = j == 0 ? this.rightControllerHandle : this.leftControllerHandle;
                        if (l == 0L) {
                            flag = true;
                            continue;
                        }
                        RenderModelComponentState renderModelComponentState = RenderModelComponentState.calloc((MemoryStack)stack);
                        boolean b0 = VRRenderModels.VRRenderModels_GetComponentStateForDevicePath((CharSequence)renderModelName, (CharSequence)componentName, (long)l, (RenderModelControllerModeState)RenderModelControllerModeState.calloc((MemoryStack)stack), (RenderModelComponentState)renderModelComponentState);
                        if (!b0) {
                            flag = true;
                            continue;
                        }
                        Matrix4f matrix4f = new Matrix4f();
                        OpenVRUtil.convertSteamVRMatrix3ToMatrix4f(renderModelComponentState.mTrackingToComponentLocal(), matrix4f);
                        this.controllerComponentTransforms.get((Object)s)[j] = matrix4f;
                        if (j == 1 && flag2 && s.equals("handgrip")) {
                            this.controllerComponentTransforms.get((Object)s)[1] = this.controllerComponentTransforms.get(s)[0];
                        }
                        if (flag || j != 0) continue;
                        try {
                            Matrix4f matrix4f1 = this.getControllerComponentTransform(0, "tip");
                            Matrix4f matrix4f2 = this.getControllerComponentTransform(0, "handgrip");
                            Vector3 vector3 = matrix4f1.transform(this.forward);
                            Vector3 vector31 = matrix4f2.transform(this.forward);
                            double d0 = Math.abs(vector3.normalized().dot(vector31.normalized()));
                            double d1 = Math.acos(d0);
                            double d2 = Math.toDegrees(d1);
                            double d3 = Math.acos(vector3.normalized().dot(this.forward.normalized()));
                            double d4 = Math.toDegrees(d3);
                            this.gunStyle = d2 > 10.0;
                            this.gunAngle = d2;
                        }
                        catch (Exception exception) {
                            flag = true;
                        }
                        continue;
                    }
                }
                this.getXforms = flag;
            }
        }
    }

    private void initializeOpenVR() {
        this.hmdErrorStoreBuf = MemoryUtil.memCallocInt((int)1);
        int token = VR.VR_InitInternal((IntBuffer)this.hmdErrorStoreBuf, (int)1);
        if (!this.isError()) {
            OpenVR.create((int)token);
        }
        if (OpenVR.VRApplications == null || OpenVR.VRCompositor == null || OpenVR.VRInput == null || OpenVR.VRRenderModels == null || OpenVR.VRSystem == null || this.isError()) {
            if (this.isError()) {
                throw new RuntimeException(VR.VR_GetVRInitErrorAsEnglishDescription((int)this.getError()));
            }
            throw new RuntimeException(class_1074.method_4662((String)"vivecraft.messages.outdatedsteamvr", (Object[])new Object[0]));
        }
        org.vivecraft.client_vr.settings.VRSettings.logger.info("OpenVR System Initialized OK.");
        this.hmdTrackedDevicePoses = TrackedDevicePose.calloc((int)64);
        this.poseMatrices = new Matrix4f[64];
        for (int i = 0; i < this.poseMatrices.length; ++i) {
            this.poseMatrices[i] = new Matrix4f();
        }
        this.initSuccess = true;
    }

    @Override
    public boolean postinit() throws RenderConfigException {
        this.initInputAndApplication();
        return this.inputInitialized;
    }

    private void initInputAndApplication() throws RenderConfigException {
        this.populateInputActions();
        if (OpenVR.VRInput != null) {
            this.generateActionManifest();
            this.loadActionManifest();
            this.loadActionHandles();
            this.installApplicationManifest(false);
            this.inputInitialized = true;
        }
    }

    private void initOpenVRCompositor() {
        VRCompositor.VRCompositor_SetTrackingSpace((int)1);
        try (MemoryStack stack = MemoryStack.stackPush();){
            ByteBuffer pointer = stack.calloc(20);
            org.vivecraft.client_vr.settings.VRSettings.logger.info("TrackingSpace: {}", (Object)VRCompositor.VRCompositor_GetTrackingSpace());
            VRSystem.VRSystem_GetStringTrackedDeviceProperty((int)0, (int)1005, (ByteBuffer)pointer, (IntBuffer)this.hmdErrorStore);
            String s = this.memUTF8NullTerminated(pointer);
            org.vivecraft.client_vr.settings.VRSettings.logger.info("Device manufacturer is: {}", (Object)s);
            this.detectedHardware = HardwareType.fromManufacturer(s);
        }
        this.dh.vrSettings.loadOptions();
        VRHotkeys.loadExternalCameraConfig();
        this.texBounds.uMax(1.0f);
        this.texBounds.uMin(0.0f);
        this.texBounds.vMax(1.0f);
        this.texBounds.vMin(0.0f);
        this.texType0.eColorSpace(1);
        this.texType0.eType(1);
        this.texType0.handle(-1L);
        this.texType1.eColorSpace(1);
        this.texType1.eType(1);
        this.texType1.handle(-1L);
        org.vivecraft.client_vr.settings.VRSettings.logger.info("OpenVR Compositor initialized OK.");
    }

    private void checkPathValid(String path, String knownError, boolean alwaysThrow) throws RenderConfigException {
        Object pathFormatted = "";
        boolean hasInvalidChars = false;
        for (char c : path.toCharArray()) {
            if (c > '\u007f') {
                hasInvalidChars = true;
                pathFormatted = (String)pathFormatted + "\u00a7c" + c + "\u00a7r";
                continue;
            }
            pathFormatted = (String)pathFormatted + c;
        }
        if (hasInvalidChars || alwaysThrow) {
            String error = knownError + (hasInvalidChars ? "\nInvalid characters in path: \n" : "\n");
            System.out.println(error + path);
            if (hasInvalidChars) {
                throw new RenderConfigException(knownError, (class_2561)class_2561.method_43469((String)"vivecraft.messages.steamvrInvalidCharacters", (Object[])new Object[]{pathFormatted}));
            }
            throw new RenderConfigException(knownError, (class_2561)class_2561.method_43473().method_27693(error).method_27693((String)pathFormatted));
        }
    }

    private void installApplicationManifest(boolean force) throws RenderConfigException {
        File file1 = new File("openvr/vivecraft.vrmanifest");
        Utils.loadAssetToFile("vivecraft.vrmanifest", file1, true);
        File file2 = new File("openvr/custom.vrmanifest");
        if (file2.exists()) {
            file1 = file2;
        }
        if (OpenVR.VRApplications != null) {
            int j;
            String s;
            try {
                Map map = (Map)new Gson().fromJson((Reader)new FileReader(file1), Map.class);
                s = ((Map)((List)map.get("applications")).get(0)).get("app_key").toString();
            }
            catch (Exception exception1) {
                System.out.println("Error reading appkey from manifest");
                exception1.printStackTrace();
                return;
            }
            System.out.println("Appkey: " + s);
            this.checkPathValid(file1.getAbsolutePath(), "Failed to install application manifest", false);
            if (!force && VRApplications.VRApplications_IsApplicationInstalled((CharSequence)s)) {
                System.out.println("Application manifest already installed");
            } else {
                int i = VRApplications.VRApplications_AddApplicationManifest((CharSequence)file1.getAbsolutePath(), (boolean)true);
                if (i != 0) {
                    this.checkPathValid(file1.getAbsolutePath(), "Failed to install application manifest: " + VRApplications.VRApplications_GetApplicationsErrorNameFromEnum((int)i), true);
                }
                System.out.println("Application manifest installed successfully");
            }
            try {
                String s1 = ManagementFactory.getRuntimeMXBean().getName();
                j = Integer.parseInt(s1.split("@")[0]);
            }
            catch (Exception exception) {
                System.out.println("Error getting process id");
                exception.printStackTrace();
                return;
            }
            int k = VRApplications.VRApplications_IdentifyApplication((int)j, (CharSequence)s);
            if (k != 0) {
                System.out.println("Failed to identify application: " + VRApplications.VRApplications_GetApplicationsErrorNameFromEnum((int)k));
            } else {
                System.out.println("Application identified successfully");
            }
        }
    }

    private void loadActionHandles() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            LongBuffer longbyreference = stack.callocLong(1);
            for (VRInputAction vrinputaction : this.inputActions.values()) {
                int i = VRInput.VRInput_GetActionHandle((CharSequence)vrinputaction.name, (LongBuffer)longbyreference);
                if (i != 0) {
                    throw new RuntimeException("Error getting action handle for '" + vrinputaction.name + "': " + MCOpenVR.getInputErrorName(i));
                }
                vrinputaction.setHandle(longbyreference.get(0));
            }
            this.leftPoseHandle = this.getActionHandle("/actions/global/in/lefthand");
            this.rightPoseHandle = this.getActionHandle("/actions/global/in/righthand");
            this.leftHapticHandle = this.getActionHandle("/actions/global/out/lefthaptic");
            this.rightHapticHandle = this.getActionHandle("/actions/global/out/righthaptic");
            this.externalCameraPoseHandle = this.getActionHandle("/actions/mixedreality/in/externalcamera");
            for (VRInputActionSet vrinputactionset : VRInputActionSet.values()) {
                int j = VRInput.VRInput_GetActionSetHandle((CharSequence)vrinputactionset.name, (LongBuffer)longbyreference);
                if (j != 0) {
                    throw new RuntimeException("Error getting action set handle for '" + vrinputactionset.name + "': " + MCOpenVR.getInputErrorName(j));
                }
                this.actionSetHandles.put(vrinputactionset, longbyreference.get(0));
            }
            this.leftControllerHandle = this.getInputSourceHandle("/user/hand/left");
            this.rightControllerHandle = this.getInputSourceHandle("/user/hand/right");
        }
    }

    private void loadActionManifest() throws RenderConfigException {
        String actionsPath = new File("openvr/input/action_manifest.json").getAbsolutePath();
        this.checkPathValid(actionsPath, "Failed to install action manifest", false);
        int i = VRInput.VRInput_SetActionManifestPath((CharSequence)actionsPath);
        if (i != 0) {
            throw new RenderConfigException("Failed to load action manifest", (class_2561)class_2561.method_43470((String)MCOpenVR.getInputErrorName(i)));
        }
    }

    private void pollVREvents() {
        if (OpenVR.VRSystem != null) {
            VREvent vrevent = VREvent.calloc();
            while (VRSystem.VRSystem_PollNextEvent((VREvent)vrevent, (int)VREvent.SIZEOF)) {
                this.vrEvents.add(vrevent);
                vrevent = VREvent.calloc();
            }
        }
    }

    private void processInputAction(VRInputAction action) {
        if (action.isActive() && action.isEnabledRaw() && (!ClientDataHolderVR.getInstance().vrSettings.ingameBindingsInGui || action.actionSet != VRInputActionSet.INGAME || action.keyBinding.field_1655.method_1442() != class_3675.class_307.field_1672 || action.keyBinding.field_1655.method_1444() != 0 || this.mc.field_1755 == null)) {
            if (action.isButtonChanged()) {
                if (action.isButtonPressed() && action.isEnabled()) {
                    if (!this.ignorePressesNextFrame) {
                        action.pressBinding();
                    }
                } else {
                    action.unpressBinding();
                }
            }
        } else {
            action.unpressBinding();
        }
    }

    private void processScrollInput(class_304 keyBinding, Runnable upCallback, Runnable downCallback) {
        VRInputAction vrinputaction = this.getInputAction(keyBinding);
        if (vrinputaction.isEnabled() && vrinputaction.getLastOrigin() != 0L && vrinputaction.getAxis2D(true).getY() != 0.0f) {
            float f = vrinputaction.getAxis2D(false).getY();
            if (f > 0.0f) {
                upCallback.run();
            } else if (f < 0.0f) {
                downCallback.run();
            }
        }
    }

    private void processSwipeInput(class_304 keyBinding, Runnable leftCallback, Runnable rightCallback, Runnable upCallback, Runnable downCallback) {
        ControllerType controllertype;
        VRInputAction vrinputaction = this.getInputAction(keyBinding);
        if (vrinputaction.isEnabled() && vrinputaction.getLastOrigin() != 0L && (controllertype = this.findActiveBindingControllerType(keyBinding)) != null) {
            if (!this.trackpadSwipeSamplers.containsKey(keyBinding.method_1431())) {
                this.trackpadSwipeSamplers.put(keyBinding.method_1431(), new TrackpadSwipeSampler());
            }
            TrackpadSwipeSampler trackpadswipesampler = this.trackpadSwipeSamplers.get(keyBinding.method_1431());
            trackpadswipesampler.update(controllertype, vrinputaction.getAxis2D(false));
            if (trackpadswipesampler.isSwipedUp() && upCallback != null) {
                this.triggerHapticPulse(controllertype, 0.001f, 400.0f, 0.5f);
                upCallback.run();
            }
            if (trackpadswipesampler.isSwipedDown() && downCallback != null) {
                this.triggerHapticPulse(controllertype, 0.001f, 400.0f, 0.5f);
                downCallback.run();
            }
            if (trackpadswipesampler.isSwipedLeft() && leftCallback != null) {
                this.triggerHapticPulse(controllertype, 0.001f, 400.0f, 0.5f);
                leftCallback.run();
            }
            if (trackpadswipesampler.isSwipedRight() && rightCallback != null) {
                this.triggerHapticPulse(controllertype, 0.001f, 400.0f, 0.5f);
                rightCallback.run();
            }
        }
    }

    private void processVREvents() {
        while (!this.vrEvents.isEmpty()) {
            VREvent vrevent = this.vrEvents.poll();
            switch (vrevent.eventType()) {
                case 100: 
                case 101: 
                case 102: 
                case 108: 
                case 853: {
                    this.getXforms = true;
                    break;
                }
                case 700: {
                    this.mc.method_1592();
                }
            }
        }
    }

    private void readOriginInfo(long inputValueHandle) {
        int i = VRInput.VRInput_GetOriginTrackedDeviceInfo((long)inputValueHandle, (InputOriginInfo)this.originInfo, (int)InputOriginInfo.SIZEOF);
        if (i != 0) {
            throw new RuntimeException("Error reading origin info: " + MCOpenVR.getInputErrorName(i));
        }
    }

    private void readPoseData(long actionHandle) {
        int i = VRInput.VRInput_GetPoseActionDataForNextFrame((long)actionHandle, (int)1, (InputPoseActionData)this.poseData, (int)InputPoseActionData.SIZEOF, (long)0L);
        if (i != 0) {
            throw new RuntimeException("Error reading pose data: " + MCOpenVR.getInputErrorName(i));
        }
    }

    private void updateControllerPose(int controller, long actionHandle) {
        if (this.TPose) {
            if (controller == 0) {
                Utils.Matrix4fCopy(this.TPose_Right, this.controllerPose[controller]);
            } else if (controller == 1) {
                Utils.Matrix4fCopy(this.TPose_Left, this.controllerPose[controller]);
            }
            this.controllerTracking[controller] = true;
        } else {
            this.readPoseData(actionHandle);
            if (this.poseData.activeOrigin() != 0L) {
                TrackedDevicePose trackeddevicepose;
                this.readOriginInfo(this.poseData.activeOrigin());
                int i = this.originInfo.trackedDeviceIndex();
                if (i != this.controllerDeviceIndex[controller]) {
                    this.getXforms = true;
                }
                this.controllerDeviceIndex[controller] = i;
                if (i != -1 && (trackeddevicepose = this.poseData.pose()).bPoseIsValid()) {
                    OpenVRUtil.convertSteamVRMatrix3ToMatrix4f(trackeddevicepose.mDeviceToAbsoluteTracking(), this.poseMatrices[i]);
                    this.deviceVelocity[i] = new class_243((double)trackeddevicepose.vVelocity().v(0), (double)trackeddevicepose.vVelocity().v(1), (double)trackeddevicepose.vVelocity().v(2));
                    Utils.Matrix4fCopy(this.poseMatrices[i], this.controllerPose[controller]);
                    this.controllerTracking[controller] = true;
                    return;
                }
            } else {
                this.controllerDeviceIndex[controller] = -1;
            }
            this.controllerTracking[controller] = false;
        }
    }

    private void updatePose() {
        if (OpenVR.VRSystem != null && OpenVR.VRSystem != null) {
            int i = VRCompositor.VRCompositor_WaitGetPoses((TrackedDevicePose.Buffer)this.hmdTrackedDevicePoses, null);
            if (i > 0) {
                System.out.println("Compositor Error: GetPoseError " + OpenVRStereoRenderer.getCompostiorError(i));
            }
            if (i == 101) {
                this.triggerHapticPulse(0, 500);
                this.triggerHapticPulse(1, 500);
            }
            if (this.getXforms) {
                this.getTransforms();
            } else if (this.dbg) {
                this.dbg = false;
                this.debugOut(0);
                this.debugOut(this.controllerDeviceIndex[0]);
                this.debugOut(this.controllerDeviceIndex[1]);
            }
            try (MemoryStack stack = MemoryStack.stackPush();){
                HmdMatrix34 hmdmatrix34 = HmdMatrix34.calloc((MemoryStack)stack);
                OpenVRUtil.convertSteamVRMatrix3ToMatrix4f(VRSystem.VRSystem_GetEyeToHeadTransform((int)0, (HmdMatrix34)hmdmatrix34), this.hmdPoseLeftEye);
                OpenVRUtil.convertSteamVRMatrix3ToMatrix4f(VRSystem.VRSystem_GetEyeToHeadTransform((int)1, (HmdMatrix34)hmdmatrix34), this.hmdPoseRightEye);
            }
            for (int j = 0; j < 64; ++j) {
                if (!((TrackedDevicePose)this.hmdTrackedDevicePoses.get(j)).bPoseIsValid()) continue;
                OpenVRUtil.convertSteamVRMatrix3ToMatrix4f(((TrackedDevicePose)this.hmdTrackedDevicePoses.get(j)).mDeviceToAbsoluteTracking(), this.poseMatrices[j]);
                this.deviceVelocity[j] = new class_243((double)((TrackedDevicePose)this.hmdTrackedDevicePoses.get(j)).vVelocity().v(0), (double)((TrackedDevicePose)this.hmdTrackedDevicePoses.get(j)).vVelocity().v(1), (double)((TrackedDevicePose)this.hmdTrackedDevicePoses.get(j)).vVelocity().v(2));
            }
            if (((TrackedDevicePose)this.hmdTrackedDevicePoses.get(0)).bPoseIsValid()) {
                Utils.Matrix4fCopy(this.poseMatrices[0], this.hmdPose);
                this.headIsTracking = true;
            } else {
                this.headIsTracking = false;
                Utils.Matrix4fSetIdentity(this.hmdPose);
                this.hmdPose.M[1][3] = 1.62f;
            }
            this.TPose = false;
            if (this.TPose) {
                this.TPose_Right.M[0][3] = 0.0f;
                this.TPose_Right.M[1][3] = 0.0f;
                this.TPose_Right.M[2][3] = 0.0f;
                Matrix4f matrix4f = this.TPose_Right;
                Utils.Matrix4fCopy(Matrix4f.rotationY(-120.0f), this.TPose_Right);
                this.TPose_Right.M[0][3] = 0.5f;
                this.TPose_Right.M[1][3] = 1.0f;
                this.TPose_Right.M[2][3] = -0.5f;
                this.TPose_Left.M[0][3] = 0.0f;
                this.TPose_Left.M[1][3] = 0.0f;
                this.TPose_Left.M[2][3] = 0.0f;
                matrix4f = this.TPose_Left;
                Utils.Matrix4fCopy(Matrix4f.rotationY(120.0f), this.TPose_Left);
                this.TPose_Left.M[0][3] = -0.5f;
                this.TPose_Left.M[1][3] = 1.0f;
                this.TPose_Left.M[2][3] = -0.5f;
                this.Neutral_HMD.M[0][3] = 0.0f;
                this.Neutral_HMD.M[1][3] = 1.8f;
                Utils.Matrix4fCopy(this.Neutral_HMD, this.hmdPose);
                this.headIsTracking = true;
            }
            if (this.inputInitialized) {
                int k;
                this.mc.method_16011().method_15396("updateActionState");
                if (this.updateActiveActionSets() && (k = VRInput.VRInput_UpdateActionState((VRActiveActionSet.Buffer)this.activeActionSetsBuffer, (int)VRActiveActionSet.SIZEOF)) != 0) {
                    throw new RuntimeException("Error updating action state: code " + MCOpenVR.getInputErrorName(k));
                }
                this.inputActions.values().forEach(this::readNewData);
                this.mc.method_16011().method_15407();
                if (this.dh.vrSettings.reverseHands) {
                    this.updateControllerPose(0, this.leftPoseHandle);
                    this.updateControllerPose(1, this.rightPoseHandle);
                } else {
                    this.updateControllerPose(0, this.rightPoseHandle);
                    this.updateControllerPose(1, this.leftPoseHandle);
                }
                this.updateControllerPose(2, this.externalCameraPoseHandle);
            }
            this.updateAim();
        }
    }

    long getActionSetHandle(VRInputActionSet actionSet) {
        return this.actionSetHandles.get((Object)actionSet);
    }

    long getControllerHandle(ControllerType hand) {
        if (this.dh.vrSettings.reverseHands) {
            return hand == ControllerType.RIGHT ? this.leftControllerHandle : this.rightControllerHandle;
        }
        return hand == ControllerType.RIGHT ? this.rightControllerHandle : this.leftControllerHandle;
    }

    long getInputSourceHandle(String path) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            LongBuffer longbyreference = stack.callocLong(1);
            int i = VRInput.VRInput_GetInputSourceHandle((CharSequence)path, (LongBuffer)longbyreference);
            if (i != 0) {
                throw new RuntimeException("Error getting input source handle for '" + path + "': " + MCOpenVR.getInputErrorName(i));
            }
            long l = longbyreference.get(0);
            return l;
        }
    }

    ControllerType getOriginControllerType(long inputValueHandle) {
        if (inputValueHandle == 0L) {
            return null;
        }
        this.readOriginInfo(inputValueHandle);
        if (this.originInfo.trackedDeviceIndex() != -1) {
            if (this.originInfo.trackedDeviceIndex() == this.controllerDeviceIndex[0]) {
                return ControllerType.RIGHT;
            }
            if (this.originInfo.trackedDeviceIndex() == this.controllerDeviceIndex[1]) {
                return ControllerType.LEFT;
            }
        }
        return null;
    }

    public void readNewData(VRInputAction action) {
        String s;
        switch (s = action.type) {
            case "boolean": {
                if (action.isHanded()) {
                    for (ControllerType controllertype1 : ControllerType.values()) {
                        this.readDigitalData(action, controllertype1);
                    }
                    break;
                }
                this.readDigitalData(action, null);
                break;
            }
            case "vector1": 
            case "vector2": 
            case "vector3": {
                if (action.isHanded()) {
                    for (ControllerType controllertype : ControllerType.values()) {
                        this.readAnalogData(action, controllertype);
                    }
                    break;
                }
                this.readAnalogData(action, null);
            }
        }
    }

    private void readDigitalData(VRInputAction action, ControllerType hand) {
        int j;
        int i = 0;
        if (hand != null) {
            i = hand.ordinal();
        }
        if ((j = VRInput.VRInput_GetDigitalActionData((long)action.handle, (InputDigitalActionData)this.digital, (int)InputDigitalActionData.SIZEOF, (long)(hand != null ? this.getControllerHandle(hand) : 0L))) != 0) {
            throw new RuntimeException("Error reading digital data for '" + action.name + "': " + MCOpenVR.getInputErrorName(j));
        }
        action.digitalData[i].activeOrigin = this.digital.activeOrigin();
        action.digitalData[i].isActive = this.digital.bActive();
        action.digitalData[i].state = this.digital.bState();
        action.digitalData[i].isChanged = this.digital.bChanged();
    }

    private void readAnalogData(VRInputAction action, ControllerType hand) {
        int j;
        int i = 0;
        if (hand != null) {
            i = hand.ordinal();
        }
        if ((j = VRInput.VRInput_GetAnalogActionData((long)action.handle, (InputAnalogActionData)this.analog, (int)InputAnalogActionData.SIZEOF, (long)(hand != null ? this.getControllerHandle(hand) : 0L))) != 0) {
            throw new RuntimeException("Error reading analog data for '" + action.name + "': " + MCOpenVR.getInputErrorName(j));
        }
        action.analogData[i].x = this.analog.x();
        action.analogData[i].y = this.analog.y();
        action.analogData[i].z = this.analog.z();
        action.analogData[i].deltaX = this.analog.deltaX();
        action.analogData[i].deltaY = this.analog.deltaY();
        action.analogData[i].deltaZ = this.analog.deltaZ();
        action.analogData[i].activeOrigin = this.analog.activeOrigin();
        action.analogData[i].isActive = this.analog.bActive();
    }

    @Override
    public boolean hasThirdController() {
        return this.controllerDeviceIndex[2] != -1;
    }

    @Override
    public List<Long> getOrigins(VRInputAction action) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            LongBuffer longbyreference = stack.callocLong(16);
            int i = VRInput.VRInput_GetActionOrigins((long)this.getActionSetHandle(action.actionSet), (long)action.handle, (LongBuffer)longbyreference);
            if (i != 0) {
                throw new RuntimeException("Error getting action origins for '" + action.name + "': " + MCOpenVR.getInputErrorName(i));
            }
            ArrayList<Long> list = new ArrayList<Long>();
            while (longbyreference.remaining() > 0) {
                long j = longbyreference.get();
                if (j == 0L) continue;
                list.add(j);
            }
            ArrayList<Long> arrayList = list;
            return arrayList;
        }
    }

    @Override
    public VRRenderer createVRRenderer() {
        return new OpenVRStereoRenderer(this);
    }

    @Override
    public boolean isActive() {
        int activityLevel = VRSystem.VRSystem_GetTrackedDeviceActivityLevel((int)0);
        return activityLevel == 1 || activityLevel == 2;
    }

    @Override
    public float getIPD() {
        return VRSystem.VRSystem_GetFloatTrackedDeviceProperty((int)0, (int)2003, (IntBuffer)this.hmdErrorStore);
    }

    @Override
    public String getRuntimeName() {
        return "SteamVR";
    }

    static {
        steamLanguages = Map.ofEntries(Map.entry("english", "en_US"), Map.entry("bulgarian", "bg_BG"), Map.entry("schinese", "zh_CN"), Map.entry("tchinese", "zh_TW"), Map.entry("czech", "cs_CZ"), Map.entry("danish", "da_DK"), Map.entry("dutch", "nl_NL"), Map.entry("finnish", "fi_FI"), Map.entry("french", "fr_FR"), Map.entry("german", "de_DE"), Map.entry("greek", "el_GR"), Map.entry("hungarian", "hu_HU"), Map.entry("indonesian", "id_ID"), Map.entry("italian", "it_IT"), Map.entry("japanese", "ja_JP"), Map.entry("koreana", "ko_KR"), Map.entry("norwegian", "no_NO"), Map.entry("polish", "pl_PL"), Map.entry("portuguese", "pt_PT"), Map.entry("brazilian", "pt_BR"), Map.entry("romanian", "ro_RO"), Map.entry("russian", "ru_RU"), Map.entry("spanish", "es_ES"), Map.entry("latam", "es_MX"), Map.entry("swedish", "sv_SE"), Map.entry("thai", "th_TH"), Map.entry("turkish", "tr_TR"), Map.entry("ukrainian", "uk_UA"), Map.entry("vietnamese", "vi_VN"));
        steamLanguageWrongMappings = Map.ofEntries(Map.entry("cs_CZ", "cs_CS"), Map.entry("da_DK", "da_DA"), Map.entry("el_GR", "el_EL"), Map.entry("sv_SE", "sv_SV"));
    }
}

