/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.render.helpers;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5944;
import net.minecraft.class_757;
import net.minecraft.class_765;
import net.minecraft.class_8251;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL43C;
import org.vivecraft.client.extensions.RenderTargetExtension;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.MethodHolder;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.gameplay.trackers.TelescopeTracker;
import org.vivecraft.client_vr.provider.MCVR;
import org.vivecraft.client_vr.render.RenderPass;
import org.vivecraft.mixin.client.blaze3d.RenderSystemAccessor;

public class RenderHelper {
    private static int polyBlendSrcA;
    private static int polyBlendDstA;
    private static int polyBlendSrcRGB;
    private static int polyBlendDstRGB;
    private static boolean polyBlend;
    private static boolean polyTex;
    private static boolean polyLight;
    private static boolean polyCull;
    private static final ClientDataHolderVR dataHolder;
    private static final class_310 mc;

    public static void applyVRModelView(RenderPass currentPass, class_4587 poseStack) {
        Matrix4f modelView = currentPass == RenderPass.CENTER && RenderHelper.dataHolder.vrSettings.displayMirrorCenterSmooth > 0.0f ? new Matrix4f().rotation((Quaternionfc)MCVR.get().hmdRotHistory.averageRotation(RenderHelper.dataHolder.vrSettings.displayMirrorCenterSmooth)) : RenderHelper.dataHolder.vrPlayer.vrdata_world_render.getEye(currentPass).getMatrix().transposed().toMCMatrix();
        poseStack.method_23760().method_23761().mul((Matrix4fc)modelView);
        poseStack.method_23760().method_23762().mul((Matrix3fc)new Matrix3f((Matrix4fc)modelView));
    }

    public static class_243 getSmoothCameraPosition(RenderPass renderpass, VRData vrData) {
        if (RenderHelper.dataHolder.currentPass == RenderPass.CENTER && RenderHelper.dataHolder.vrSettings.displayMirrorCenterSmooth > 0.0f) {
            return MCVR.get().hmdHistory.averagePosition(RenderHelper.dataHolder.vrSettings.displayMirrorCenterSmooth).method_1021((double)vrData.worldScale).method_1024(vrData.rotation_radians).method_1019(vrData.origin);
        }
        return vrData.getEye(renderpass).getPosition();
    }

    public static void applyStereo(RenderPass currentPass, class_4587 matrix) {
        if (currentPass == RenderPass.LEFT || currentPass == RenderPass.RIGHT) {
            class_243 eye = RenderHelper.dataHolder.vrPlayer.vrdata_world_render.getEye(currentPass).getPosition().method_1020(RenderHelper.dataHolder.vrPlayer.vrdata_world_render.getEye(RenderPass.CENTER).getPosition());
            matrix.method_22904(-eye.field_1352, -eye.field_1351, -eye.field_1350);
        }
    }

    public static class_243 getControllerRenderPos(int c) {
        if (!RenderHelper.dataHolder.vrSettings.seated) {
            return RenderHelper.dataHolder.vrPlayer.vrdata_world_render.getController(c).getPosition();
        }
        class_243 out = null;
        int mainHand = class_1268.field_5808.ordinal();
        if (RenderHelper.dataHolder.vrSettings.reverseHands) {
            c = 1 - c;
            mainHand = class_1268.field_5810.ordinal();
        }
        if (mc.method_1560() != null && RenderHelper.mc.field_1687 != null) {
            class_243 dir = RenderHelper.dataHolder.vrPlayer.vrdata_world_render.hmd.getDirection();
            dir = dir.method_1024((float)Math.toRadians(c == 0 ? -35.0 : 35.0));
            dir = new class_243(dir.field_1352, 0.0, dir.field_1350);
            dir = dir.method_1029();
            if (TelescopeTracker.isTelescope(RenderHelper.mc.field_1724.method_6030()) && TelescopeTracker.isTelescope(c == mainHand ? RenderHelper.mc.field_1724.method_6047() : RenderHelper.mc.field_1724.method_6079())) {
                VRData.VRDevicePose eye = c == 0 ? RenderHelper.dataHolder.vrPlayer.vrdata_world_render.eye0 : RenderHelper.dataHolder.vrPlayer.vrdata_world_render.eye1;
                out = eye.getPosition().method_1019(RenderHelper.dataHolder.vrPlayer.vrdata_world_render.hmd.getDirection().method_1021(0.2 * (double)RenderHelper.dataHolder.vrPlayer.vrdata_world_render.worldScale));
            }
            if (out == null) {
                out = RenderHelper.dataHolder.vrPlayer.vrdata_world_render.getEye(RenderPass.CENTER).getPosition().method_1031(dir.field_1352 * 0.3 * (double)RenderHelper.dataHolder.vrPlayer.vrdata_world_render.worldScale, -0.4 * (double)RenderHelper.dataHolder.vrPlayer.vrdata_world_render.worldScale, dir.field_1350 * 0.3 * (double)RenderHelper.dataHolder.vrPlayer.vrdata_world_render.worldScale);
            }
        } else {
            class_243 dir = RenderHelper.dataHolder.vrPlayer.vrdata_world_render.hmd.getDirection();
            dir = dir.method_1024((float)Math.toRadians(c == 0 ? -35.0 : 35.0));
            dir = new class_243(dir.field_1352, 0.0, dir.field_1350);
            dir = dir.method_1029();
            out = RenderHelper.dataHolder.vrPlayer.vrdata_world_render.hmd.getPosition().method_1031(dir.field_1352 * 0.3, -0.4, dir.field_1350 * 0.3);
        }
        return out;
    }

    public static void setupRenderingAtController(int controller, class_4587 matrix) {
        class_243 aimSource = RenderHelper.getControllerRenderPos(controller);
        aimSource = aimSource.method_1020(RenderHelper.getSmoothCameraPosition(RenderHelper.dataHolder.currentPass, RenderHelper.dataHolder.vrPlayer.getVRDataWorld()));
        matrix.method_22904(aimSource.field_1352, aimSource.field_1351, aimSource.field_1350);
        float sc = RenderHelper.dataHolder.vrPlayer.vrdata_world_render.worldScale;
        if (RenderHelper.dataHolder.vrSettings.seated && RenderHelper.mc.field_1687 != null && TelescopeTracker.isTelescope(RenderHelper.mc.field_1724.method_6030()) && TelescopeTracker.isTelescope(controller == 0 ? RenderHelper.mc.field_1724.method_6047() : RenderHelper.mc.field_1724.method_6079())) {
            matrix.method_34425(RenderHelper.dataHolder.vrPlayer.vrdata_world_render.hmd.getMatrix().inverted().transposed().toMCMatrix());
            MethodHolder.rotateDegXp(matrix, 90);
            matrix.method_22904(controller == (RenderHelper.dataHolder.vrSettings.reverseHands ? 1 : 0) ? 0.075 * (double)sc : -0.075 * (double)sc, -0.025 * (double)sc, 0.0325 * (double)sc);
        } else {
            matrix.method_34425(RenderHelper.dataHolder.vrPlayer.vrdata_world_render.getController(controller).getMatrix().inverted().transposed().toMCMatrix());
        }
        matrix.method_22905(sc, sc, sc);
    }

    public static void renderDebugAxes(int r, int g, int b, float radius) {
        RenderHelper.setupPolyRendering(true);
        RenderSystem.setShaderTexture((int)0, (class_2960)new class_2960("vivecraft:textures/white.png"));
        RenderHelper.renderCircle(new class_243(0.0, 0.0, 0.0), radius, 32, r, g, b, 255, 0);
        RenderHelper.renderCircle(new class_243(0.0, 0.01, 0.0), radius * 0.75f, 32, r, g, b, 255, 0);
        RenderHelper.renderCircle(new class_243(0.0, 0.02, 0.0), radius * 0.25f, 32, r, g, b, 255, 0);
        RenderHelper.renderCircle(new class_243(0.0, 0.0, 0.15), radius * 0.5f, 32, r, g, b, 255, 2);
        RenderHelper.setupPolyRendering(false);
    }

    public static void renderCircle(class_243 pos, float radius, int edges, int r, int g, int b, int a, int side) {
        class_289 tesselator = class_289.method_1348();
        tesselator.method_1349().method_1328(class_293.class_5596.field_27381, class_290.field_1576);
        tesselator.method_1349().method_22912(pos.field_1352, pos.field_1351, pos.field_1350).method_1336(r, g, b, a).method_1344();
        for (int i = 0; i < edges + 1; ++i) {
            float z;
            float y;
            float x;
            float startAngle = (float)i / (float)edges * (float)Math.PI * 2.0f;
            if (side == 0 || side == 1) {
                x = (float)pos.field_1352 + (float)Math.cos(startAngle) * radius;
                y = (float)pos.field_1351;
                z = (float)pos.field_1350 + (float)Math.sin(startAngle) * radius;
                tesselator.method_1349().method_22912((double)x, (double)y, (double)z).method_1336(r, g, b, a).method_1344();
                continue;
            }
            if (side == 2 || side == 3) {
                x = (float)pos.field_1352 + (float)Math.cos(startAngle) * radius;
                y = (float)pos.field_1351 + (float)Math.sin(startAngle) * radius;
                z = (float)pos.field_1350;
                tesselator.method_1349().method_22912((double)x, (double)y, (double)z).method_1336(r, g, b, a).method_1344();
                continue;
            }
            if (side != 4 && side != 5) continue;
            x = (float)pos.field_1352;
            y = (float)pos.field_1351 + (float)Math.cos(startAngle) * radius;
            z = (float)pos.field_1350 + (float)Math.sin(startAngle) * radius;
            tesselator.method_1349().method_22912((double)x, (double)y, (double)z).method_1336(r, g, b, a).method_1344();
        }
        tesselator.method_1350();
    }

    public static void setupPolyRendering(boolean enable) {
        boolean flag = false;
        if (enable) {
            polyBlendSrcA = GlStateManager.BLEND.field_5047;
            polyBlendDstA = GlStateManager.BLEND.field_5046;
            polyBlendSrcRGB = GlStateManager.BLEND.field_5049;
            polyBlendDstRGB = GlStateManager.BLEND.field_5048;
            polyBlend = GL43C.glIsEnabled((int)3042);
            polyTex = true;
            polyLight = false;
            polyCull = true;
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableCull();
            if (flag) {
                // empty if block
            }
        } else {
            RenderSystem.blendFuncSeparate((int)polyBlendSrcRGB, (int)polyBlendDstRGB, (int)polyBlendSrcA, (int)polyBlendDstA);
            if (!polyBlend) {
                RenderSystem.disableBlend();
            }
            if (polyTex) {
                // empty if block
            }
            if (polyLight) {
                // empty if block
            }
            if (polyCull) {
                RenderSystem.enableCull();
            }
        }
    }

    public static void drawScreen(float f, class_437 screen, class_332 guiGraphics) {
        class_4587 posestack = RenderSystem.getModelViewStack();
        posestack.method_22903();
        posestack.method_34426();
        posestack.method_22904(0.0, 0.0, -11000.0);
        RenderSystem.applyModelViewMatrix();
        Matrix4f guiProjection = new Matrix4f().setOrtho(0.0f, (float)((double)mc.method_22683().method_4489() / mc.method_22683().method_4495()), (float)((double)mc.method_22683().method_4506() / mc.method_22683().method_4495()), 0.0f, 1000.0f, 21000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)guiProjection, (class_8251)class_8251.field_43361);
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        screen.method_25394(guiGraphics, 0, 0, f);
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        posestack.method_22909();
        RenderSystem.applyModelViewMatrix();
        class_276 main = mc.method_1522();
        main.method_35610();
        ((RenderTargetExtension)main).vivecraft$genMipMaps();
        main.method_1242();
    }

    public static void drawSizedQuad(float displayWidth, float displayHeight, float size) {
        RenderHelper.drawSizedQuad(displayWidth, displayHeight, size, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
    }

    public static void drawSizedQuad(float displayWidth, float displayHeight, float size, float[] color) {
        float aspect = displayHeight / displayWidth;
        class_287 bufferbuilder = class_289.method_1348().method_1349();
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1577);
        bufferbuilder.method_22912((double)(-(size / 2.0f)), (double)(-(size * aspect) / 2.0f), 0.0).method_22913(0.0f, 0.0f).method_22915(color[0], color[1], color[2], color[3]).method_22914(0.0f, 0.0f, 1.0f).method_1344();
        bufferbuilder.method_22912((double)(size / 2.0f), (double)(-(size * aspect) / 2.0f), 0.0).method_22913(1.0f, 0.0f).method_22915(color[0], color[1], color[2], color[3]).method_22914(0.0f, 0.0f, 1.0f).method_1344();
        bufferbuilder.method_22912((double)(size / 2.0f), (double)(size * aspect / 2.0f), 0.0).method_22913(1.0f, 1.0f).method_22915(color[0], color[1], color[2], color[3]).method_22914(0.0f, 0.0f, 1.0f).method_1344();
        bufferbuilder.method_22912((double)(-(size / 2.0f)), (double)(size * aspect / 2.0f), 0.0).method_22913(0.0f, 1.0f).method_22915(color[0], color[1], color[2], color[3]).method_22914(0.0f, 0.0f, 1.0f).method_1344();
        class_286.method_43433((class_287.class_7433)bufferbuilder.method_1326());
    }

    public static void drawSizedQuad(float displayWidth, float displayHeight, float size, float[] color, Matrix4f pMatrix) {
        float aspect = displayHeight / displayWidth;
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)color[0], (float)color[1], (float)color[2], (float)color[3]);
        class_287 bufferbuilder = class_289.method_1348().method_1349();
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferbuilder.method_22918(pMatrix, -(size / 2.0f), -(size * aspect) / 2.0f, 0.0f).method_22913(0.0f, 0.0f).method_1344();
        bufferbuilder.method_22918(pMatrix, size / 2.0f, -(size * aspect) / 2.0f, 0.0f).method_22913(1.0f, 0.0f).method_1344();
        bufferbuilder.method_22918(pMatrix, size / 2.0f, size * aspect / 2.0f, 0.0f).method_22913(1.0f, 1.0f).method_1344();
        bufferbuilder.method_22918(pMatrix, -(size / 2.0f), size * aspect / 2.0f, 0.0f).method_22913(0.0f, 1.0f).method_1344();
        class_286.method_43433((class_287.class_7433)bufferbuilder.method_1326());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawSizedQuadWithLightmapCutout(float displayWidth, float displayHeight, float size, int lighti, Matrix4f pMatrix, boolean flipY) {
        RenderHelper.drawSizedQuadWithLightmapCutout(displayWidth, displayHeight, size, lighti, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, pMatrix, flipY);
    }

    public static void drawSizedQuadWithLightmapCutout(float displayWidth, float displayHeight, float size, int lighti, float[] color, Matrix4f pMatrix, boolean flipY) {
        RenderHelper.drawSizedQuadWithLightmap(displayWidth, displayHeight, size, lighti, color, pMatrix, class_757::method_34504, flipY);
    }

    public static void drawSizedQuadSolid(float displayWidth, float displayHeight, float size, float[] color, Matrix4f pMatrix) {
        RenderHelper.drawSizedQuadWithLightmap(displayWidth, displayHeight, size, class_765.method_23687((int)15, (int)15), color, pMatrix, class_757::method_34502, false);
    }

    public static void drawSizedQuadWithLightmap(float displayWidth, float displayHeight, float size, int lighti, float[] color, Matrix4f pMatrix, Supplier<class_5944> shader, boolean flipY) {
        float aspect = displayHeight / displayWidth;
        RenderSystem.setShader(shader);
        RenderHelper.mc.field_1773.method_22974().method_3316();
        RenderHelper.mc.field_1773.method_22975().method_23209();
        class_287 bufferbuilder = class_289.method_1348().method_1349();
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1580);
        Vector3f light0Old = RenderSystemAccessor.getShaderLightDirections()[0];
        Vector3f light1Old = RenderSystemAccessor.getShaderLightDirections()[1];
        RenderSystem.setShaderLights((Vector3f)new Vector3f(0.0f, 0.0f, 1.0f), (Vector3f)new Vector3f(0.0f, 0.0f, 1.0f));
        RenderSystem.setupShaderLights((class_5944)RenderSystem.getShader());
        bufferbuilder.method_22918(pMatrix, -(size / 2.0f), -(size * aspect) / 2.0f, 0.0f).method_22915(color[0], color[1], color[2], color[3]).method_22913(0.0f, flipY ? 1.0f : 0.0f).method_22922(class_4608.field_21444).method_22916(lighti).method_22914(0.0f, 0.0f, 1.0f).method_1344();
        bufferbuilder.method_22918(pMatrix, size / 2.0f, -(size * aspect) / 2.0f, 0.0f).method_22915(color[0], color[1], color[2], color[3]).method_22913(1.0f, flipY ? 1.0f : 0.0f).method_22922(class_4608.field_21444).method_22916(lighti).method_22914(0.0f, 0.0f, 1.0f).method_1344();
        bufferbuilder.method_22918(pMatrix, size / 2.0f, size * aspect / 2.0f, 0.0f).method_22915(color[0], color[1], color[2], color[3]).method_22913(1.0f, flipY ? 0.0f : 1.0f).method_22922(class_4608.field_21444).method_22916(lighti).method_22914(0.0f, 0.0f, 1.0f).method_1344();
        bufferbuilder.method_22918(pMatrix, -(size / 2.0f), size * aspect / 2.0f, 0.0f).method_22915(color[0], color[1], color[2], color[3]).method_22913(0.0f, flipY ? 0.0f : 1.0f).method_22922(class_4608.field_21444).method_22916(lighti).method_22914(0.0f, 0.0f, 1.0f).method_1344();
        class_286.method_43433((class_287.class_7433)bufferbuilder.method_1326());
        RenderHelper.mc.field_1773.method_22974().method_3315();
        if (light0Old != null && light1Old != null) {
            RenderSystem.setShaderLights((Vector3f)light0Old, (Vector3f)light1Old);
            RenderSystem.setupShaderLights((class_5944)RenderSystem.getShader());
        }
    }

    public static void renderFlatQuad(class_243 pos, float width, float height, float yaw, int r, int g, int b, int a, class_4587 poseStack) {
        class_289 tesselator = class_289.method_1348();
        tesselator.method_1349().method_1328(class_293.class_5596.field_27382, class_290.field_29337);
        class_243 offset = new class_243((double)(width / 2.0f), 0.0, (double)(height / 2.0f)).method_1024((float)Math.toRadians(-yaw));
        Matrix4f mat = poseStack.method_23760().method_23761();
        tesselator.method_1349().method_22918(mat, (float)(pos.field_1352 + offset.field_1352), (float)pos.field_1351, (float)(pos.field_1350 + offset.field_1350)).method_1336(r, g, b, a).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        tesselator.method_1349().method_22918(mat, (float)(pos.field_1352 + offset.field_1352), (float)pos.field_1351, (float)(pos.field_1350 - offset.field_1350)).method_1336(r, g, b, a).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        tesselator.method_1349().method_22918(mat, (float)(pos.field_1352 - offset.field_1352), (float)pos.field_1351, (float)(pos.field_1350 - offset.field_1350)).method_1336(r, g, b, a).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        tesselator.method_1349().method_22918(mat, (float)(pos.field_1352 - offset.field_1352), (float)pos.field_1351, (float)(pos.field_1350 + offset.field_1350)).method_1336(r, g, b, a).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        tesselator.method_1350();
    }

    public static void renderBox(class_289 tes, class_243 start, class_243 end, float minX, float maxX, float minY, float maxY, class_2382 color, byte alpha, class_4587 poseStack) {
        class_243 forward = start.method_1020(end).method_1029();
        class_243 right = forward.method_1036(new class_243(0.0, 1.0, 0.0));
        class_243 up = right.method_1036(forward);
        class_243 left = right.method_1021((double)minX);
        right = right.method_1021((double)maxX);
        class_243 down = up.method_1021((double)minY);
        up = up.method_1021((double)maxY);
        class_243 upNormal = up.method_1029();
        class_243 rightNormal = right.method_1029();
        class_243 backRightBottom = start.method_1031(right.field_1352 + down.field_1352, right.field_1351 + down.field_1351, right.field_1350 + down.field_1350);
        class_243 backRightTop = start.method_1031(right.field_1352 + up.field_1352, right.field_1351 + up.field_1351, right.field_1350 + up.field_1350);
        class_243 backLeftBottom = start.method_1031(left.field_1352 + down.field_1352, left.field_1351 + down.field_1351, left.field_1350 + down.field_1350);
        class_243 backLeftTop = start.method_1031(left.field_1352 + up.field_1352, left.field_1351 + up.field_1351, left.field_1350 + up.field_1350);
        class_243 frontRightBottom = end.method_1031(right.field_1352 + down.field_1352, right.field_1351 + down.field_1351, right.field_1350 + down.field_1350);
        class_243 frontRightTop = end.method_1031(right.field_1352 + up.field_1352, right.field_1351 + up.field_1351, right.field_1350 + up.field_1350);
        class_243 frontLeftBottom = end.method_1031(left.field_1352 + down.field_1352, left.field_1351 + down.field_1351, left.field_1350 + down.field_1350);
        class_243 frontLeftTop = end.method_1031(left.field_1352 + up.field_1352, left.field_1351 + up.field_1351, left.field_1350 + up.field_1350);
        class_287 bufferbuilder = tes.method_1349();
        Matrix4f mat = poseStack.method_23760().method_23761();
        RenderHelper.addVertex(bufferbuilder, mat, backRightBottom, color, alpha, forward);
        RenderHelper.addVertex(bufferbuilder, mat, backLeftBottom, color, alpha, forward);
        RenderHelper.addVertex(bufferbuilder, mat, backLeftTop, color, alpha, forward);
        RenderHelper.addVertex(bufferbuilder, mat, backRightTop, color, alpha, forward);
        forward.method_22882();
        RenderHelper.addVertex(bufferbuilder, mat, frontLeftBottom, color, alpha, forward);
        RenderHelper.addVertex(bufferbuilder, mat, frontRightBottom, color, alpha, forward);
        RenderHelper.addVertex(bufferbuilder, mat, frontRightTop, color, alpha, forward);
        RenderHelper.addVertex(bufferbuilder, mat, frontLeftTop, color, alpha, forward);
        RenderHelper.addVertex(bufferbuilder, mat, frontRightBottom, color, alpha, rightNormal);
        RenderHelper.addVertex(bufferbuilder, mat, backRightBottom, color, alpha, rightNormal);
        RenderHelper.addVertex(bufferbuilder, mat, backRightTop, color, alpha, rightNormal);
        RenderHelper.addVertex(bufferbuilder, mat, frontRightTop, color, alpha, rightNormal);
        rightNormal.method_22882();
        RenderHelper.addVertex(bufferbuilder, mat, backLeftBottom, color, alpha, rightNormal);
        RenderHelper.addVertex(bufferbuilder, mat, frontLeftBottom, color, alpha, rightNormal);
        RenderHelper.addVertex(bufferbuilder, mat, frontLeftTop, color, alpha, rightNormal);
        RenderHelper.addVertex(bufferbuilder, mat, backLeftTop, color, alpha, rightNormal);
        RenderHelper.addVertex(bufferbuilder, mat, backLeftTop, color, alpha, upNormal);
        RenderHelper.addVertex(bufferbuilder, mat, frontLeftTop, color, alpha, upNormal);
        RenderHelper.addVertex(bufferbuilder, mat, frontRightTop, color, alpha, upNormal);
        RenderHelper.addVertex(bufferbuilder, mat, backRightTop, color, alpha, upNormal);
        upNormal.method_22882();
        RenderHelper.addVertex(bufferbuilder, mat, frontLeftBottom, color, alpha, upNormal);
        RenderHelper.addVertex(bufferbuilder, mat, backLeftBottom, color, alpha, upNormal);
        RenderHelper.addVertex(bufferbuilder, mat, backRightBottom, color, alpha, upNormal);
        RenderHelper.addVertex(bufferbuilder, mat, frontRightBottom, color, alpha, upNormal);
    }

    private static void addVertex(class_287 buff, Matrix4f mat, class_243 pos, class_2382 color, int alpha, class_243 normal) {
        buff.method_22918(mat, (float)pos.field_1352, (float)pos.field_1351, (float)pos.field_1350).method_1336(color.method_10263(), color.method_10264(), color.method_10260(), alpha).method_22914((float)normal.field_1352, (float)normal.field_1351, (float)normal.field_1350).method_1344();
    }

    static {
        dataHolder = ClientDataHolderVR.getInstance();
        mc = class_310.method_1551();
    }
}

