/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.client_vr.multiplayer;

import com.mojang.authlib.GameProfile;
import net.minecraft.class_243;
import net.minecraft.class_2535;
import net.minecraft.class_2540;
import net.minecraft.class_2658;
import net.minecraft.class_2678;
import net.minecraft.class_2724;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3944;
import net.minecraft.class_437;
import net.minecraft.class_634;
import net.minecraft.class_642;
import net.minecraft.class_7438;
import net.minecraft.class_7439;
import net.minecraft.class_7923;
import net.minecraft.class_7975;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.network.CommonNetworkHelper;

@Mixin(value={class_634.class})
public class ClientPacketListenerVRMixin {
    @Unique
    String vivecraft$lastMsg = null;
    @Final
    @Shadow
    private class_310 field_3690;

    @Inject(at={@At(value="TAIL")}, method={"<init>"})
    public void vivecraft$init(class_310 minecraft, class_437 screen, class_2535 connection, class_642 serverData, GameProfile gameProfile, class_7975 worldSessionTelemetryManager, CallbackInfo ci) {
        if (ClientNetworking.needsReset) {
            ClientNetworking.resetServerSettings();
            ClientNetworking.displayedChatMessage = false;
            ClientNetworking.displayedChatWarning = false;
            ClientNetworking.needsReset = false;
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"handleLogin"})
    public void vivecraft$resetOnLogin(class_2678 p_105030_, CallbackInfo callback) {
        ClientNetworking.resetServerSettings();
        ClientNetworking.sendVersionInfo();
        if (VRState.vrInitialized) {
            ClientDataHolderVR.getInstance().vrPlayer.chatWarningTimer = 200;
            ClientDataHolderVR.getInstance().vrPlayer.teleportWarning = true;
            ClientDataHolderVR.getInstance().vrPlayer.vrSwitchWarning = false;
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;setLevel(Lnet/minecraft/client/multiplayer/ClientLevel;)V", shift=At.Shift.AFTER)}, method={"handleRespawn"})
    public void vivecraft$resetOnDimensionChange(class_2724 clientboundRespawnPacket, CallbackInfo ci) {
        ClientNetworking.resetServerSettings();
        ClientNetworking.sendVersionInfo();
        if (VRState.vrInitialized) {
            ClientDataHolderVR.getInstance().vrPlayer.chatWarningTimer = 200;
            ClientDataHolderVR.getInstance().vrPlayer.teleportWarning = true;
            ClientDataHolderVR.getInstance().vrPlayer.vrSwitchWarning = false;
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"close"})
    public void vivecraft$cleanup(CallbackInfo ci) {
        ClientNetworking.resetServerSettings();
        ClientNetworking.displayedChatMessage = false;
        ClientNetworking.displayedChatWarning = false;
        ClientNetworking.needsReset = true;
    }

    @Inject(at={@At(value="TAIL")}, method={"sendChat"})
    public void vivecraft$chatMsg(String string, CallbackInfo ci) {
        this.vivecraft$lastMsg = string;
    }

    @Inject(at={@At(value="TAIL")}, method={"sendCommand"})
    public void vivecraft$commandMsg(String string, CallbackInfo ci) {
        this.vivecraft$lastMsg = string;
    }

    @Inject(at={@At(value="TAIL")}, method={"handlePlayerChat"})
    public void vivecraft$chat(class_7438 clientboundPlayerChatPacket, CallbackInfo ci) {
        if (VRState.vrRunning && (this.field_3690.field_1724 == null || this.vivecraft$lastMsg == null || clientboundPlayerChatPacket.comp_1099() == this.field_3690.field_1724.method_5667())) {
            this.vivecraft$triggerHapticSound();
        }
        this.vivecraft$lastMsg = null;
    }

    @Inject(at={@At(value="TAIL")}, method={"handleSystemChat"})
    public void vivecraft$chatSystem(class_7439 clientboundSystemChatPacket, CallbackInfo ci) {
        if (VRState.vrRunning && (this.field_3690.field_1724 == null || this.vivecraft$lastMsg == null || clientboundSystemChatPacket.comp_763().getString().contains(this.vivecraft$lastMsg))) {
            this.vivecraft$triggerHapticSound();
        }
        this.vivecraft$lastMsg = null;
    }

    @Unique
    private void vivecraft$triggerHapticSound() {
        ClientDataHolderVR dataholder = ClientDataHolderVR.getInstance();
        if (dataholder.vrSettings.chatNotifications != VRSettings.ChatNotifications.NONE) {
            if (!(dataholder.vrSettings.chatNotifications != VRSettings.ChatNotifications.HAPTIC && dataholder.vrSettings.chatNotifications != VRSettings.ChatNotifications.BOTH || dataholder.vrSettings.seated)) {
                dataholder.vr.triggerHapticPulse(ControllerType.LEFT, 0.2f, 1000.0f, 1.0f);
            }
            if (dataholder.vrSettings.chatNotifications == VRSettings.ChatNotifications.SOUND || dataholder.vrSettings.chatNotifications == VRSettings.ChatNotifications.BOTH) {
                class_243 vec3 = dataholder.vrPlayer.vrdata_world_pre.getController(1).getPosition();
                this.field_3690.field_1687.method_8486(vec3.method_10216(), vec3.method_10214(), vec3.method_10215(), (class_3414)class_7923.field_41172.method_10223(new class_2960(dataholder.vrSettings.chatNotificationSound)), class_3419.field_15254, 0.3f, 0.1f, false);
            }
        }
    }

    @Inject(at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/network/protocol/game/ClientboundCustomPayloadPacket;getData()Lnet/minecraft/network/FriendlyByteBuf;")}, method={"handleCustomPayload"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    public void vivecraft$handlepacket(class_2658 payloadPacket, CallbackInfo info, class_2960 channelID, class_2540 buffer) {
        if (CommonNetworkHelper.CHANNEL.equals((Object)channelID)) {
            ClientNetworking.handlePacket(CommonNetworkHelper.PacketDiscriminators.values()[buffer.readByte()], buffer);
            buffer.release();
            info.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"handleOpenScreen"})
    public void vivecraft$markScreenActive(class_3944 clientboundOpenScreenPacket, CallbackInfo ci) {
        GuiHandler.guiAppearOverBlockActive = true;
    }
}

