/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mod_compat_vr.iris;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import net.irisshaders.iris.api.v0.IrisApi;
import org.vivecraft.client.Xplat;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.client_xr.render_pass.RenderPassManager;

public class IrisHelper {
    private static boolean initialized = false;
    private static boolean initFailed = false;
    private static Method Iris_reload;
    private static Method Iris_getPipelineManager;
    private static Method PipelineManager_getPipeline;
    private static Method WorldRenderingPipeline_shouldRenderUnderwaterOverlay;
    private static boolean dhPresent;
    private static Object dhOverrideInjector;
    private static Method OverrideInjector_unbind;
    private static Class<?> IDhApiFramebuffer;
    private static Method Pipeline_getDHCompat;
    private static Method DHCompatInternal_getInstance;
    private static Method DHCompatInternal_getShadowFBWrapper;
    private static Method DHCompatInternal_getSolidFBWrapper;

    public static void setShadersActive(boolean bl) {
        IrisApi.getInstance().getConfig().setShadersEnabledAndApply(bl);
    }

    public static void reload() {
        RenderPassManager.setVanillaRenderPass();
        if (IrisHelper.init()) {
            try {
                Iris_reload.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                VRSettings.logger.error("Vivecraft: Error reloading Iris shaders on Frame Buffer reinit: {}", (Object)e.getMessage());
            }
        }
    }

    public static boolean hasWaterEffect() {
        if (IrisHelper.init()) {
            try {
                return (Boolean)((Optional)PipelineManager_getPipeline.invoke(Iris_getPipelineManager.invoke(null, new Object[0]), new Object[0])).map(o -> {
                    try {
                        return WorldRenderingPipeline_shouldRenderUnderwaterOverlay.invoke(o, new Object[0]);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        VRSettings.logger.error("Vivecraft: Iris water effect check failed: {}", (Object)e.getMessage());
                        return true;
                    }
                }).orElse(true);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                VRSettings.logger.error("Vivecraft: Iris water effect check failed: {}", (Object)e.getMessage());
            }
        }
        return true;
    }

    public static boolean isShaderActive() {
        return IrisApi.getInstance().isShaderPackInUse();
    }

    public static void unregisterDHIfThere(Object pipeline) {
        if (IrisHelper.init() && dhPresent) {
            try {
                Object dhCompatInstance;
                Object dhCompat = Pipeline_getDHCompat.invoke(pipeline, new Object[0]);
                if (dhCompat != null && (dhCompatInstance = DHCompatInternal_getInstance.invoke(dhCompat, new Object[0])) != null) {
                    OverrideInjector_unbind.invoke(dhOverrideInjector, IDhApiFramebuffer, DHCompatInternal_getShadowFBWrapper.invoke(dhCompatInstance, new Object[0]));
                    OverrideInjector_unbind.invoke(dhOverrideInjector, IDhApiFramebuffer, DHCompatInternal_getSolidFBWrapper.invoke(dhCompatInstance, new Object[0]));
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                VRSettings.logger.error("Vivecraft: Iris DH reset failed: {}", (Object)e.getMessage());
            }
        }
    }

    private static boolean init() {
        if (initialized) {
            return !initFailed;
        }
        try {
            Class<?> iris = IrisHelper.getClassWithAlternative("net.coderbot.iris.Iris", "net.irisshaders.iris.Iris");
            Iris_reload = iris.getMethod("reload", new Class[0]);
            Iris_getPipelineManager = iris.getMethod("getPipelineManager", new Class[0]);
            Class<?> pipelineManager = IrisHelper.getClassWithAlternative("net.coderbot.iris.pipeline.PipelineManager", "net.irisshaders.iris.pipeline.PipelineManager");
            PipelineManager_getPipeline = pipelineManager.getMethod("getPipeline", new Class[0]);
            Class<?> worldRenderingPipeline = IrisHelper.getClassWithAlternative("net.coderbot.iris.pipeline.WorldRenderingPipeline", "net.irisshaders.iris.pipeline.WorldRenderingPipeline");
            WorldRenderingPipeline_shouldRenderUnderwaterOverlay = worldRenderingPipeline.getMethod("shouldRenderUnderwaterOverlay", new Class[0]);
            if (Xplat.isModLoaded("distanthorizons")) {
                try {
                    Class<?> OverrideInjector = Class.forName("com.seibel.distanthorizons.coreapi.DependencyInjection.OverrideInjector");
                    dhOverrideInjector = OverrideInjector.getDeclaredField("INSTANCE").get(null);
                    OverrideInjector_unbind = OverrideInjector.getMethod("unbind", Class.class, Class.forName("com.seibel.distanthorizons.api.interfaces.override.IDhApiOverrideable"));
                    IDhApiFramebuffer = Class.forName("com.seibel.distanthorizons.api.interfaces.override.rendering.IDhApiFramebuffer");
                    Pipeline_getDHCompat = Class.forName("net.irisshaders.iris.pipeline.WorldRenderingPipeline").getMethod("getDHCompat", new Class[0]);
                    DHCompatInternal_getInstance = Class.forName("net.irisshaders.iris.compat.dh.DHCompat").getMethod("getInstance", new Class[0]);
                    Class<?> DHCompatInternal = Class.forName("net.irisshaders.iris.compat.dh.DHCompatInternal");
                    DHCompatInternal_getShadowFBWrapper = DHCompatInternal.getMethod("getShadowFBWrapper", new Class[0]);
                    DHCompatInternal_getSolidFBWrapper = DHCompatInternal.getMethod("getSolidFBWrapper", new Class[0]);
                    dhPresent = true;
                }
                catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
                    dhPresent = false;
                }
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            initFailed = true;
        }
        initialized = true;
        return !initFailed;
    }

    private static Class<?> getClassWithAlternative(String class1, String class2) throws ClassNotFoundException {
        try {
            return Class.forName(class1);
        }
        catch (ClassNotFoundException e) {
            return Class.forName(class2);
        }
    }

    static {
        dhPresent = false;
    }
}

