/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mod_compat_vr.optifine;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_630;
import org.vivecraft.client_vr.settings.VRSettings;

public class OptifineHelper {
    private static boolean checkedForOptifine = false;
    private static boolean optifineLoaded = false;
    private static Class<?> optifineConfig;
    private static Method optifineConfigIsShadersMethod;
    private static Method optifineConfigIsRenderRegionsMethod;
    private static Method optifineConfigIsSkyEnabledMethod;
    private static Method optifineConfigIsSunMoonEnabledMethod;
    private static Method optifineConfigIsStarsEnabledMethod;
    private static Method optifineConfigIsCustomColorsMethod;
    private static Method optifineConfigIsAntialiasingMethod;
    private static Method optifineConfigIsAntialiasingConfiguredMethod;
    private static Class<?> smartAnimations;
    private static Method smartAnimationsSpriteRenderedMethod;
    private static Class<?> customColors;
    private static Method customColorsGetSkyColorMethod;
    private static Method customColorsGetSkyColoEndMethod;
    private static Method customColorsGetUnderwaterColorMethod;
    private static Method customColorsGetUnderlavaColorMethod;
    private static Method customColorsGetFogColorMethod;
    private static Method customColorsGetFogColorEndMethod;
    private static Method customColorsGetFogColorNetherMethod;
    private static Class<?> shadersRender;
    private static Method shadersRenderBeginOutlineMethod;
    private static Method shadersRenderEndOutlineMethod;
    private static Class<?> shaders;
    private static Method shadersBeginEntitiesMethod;
    private static Method shadersEndEntitiesMethod;
    private static Field shadersDFB;
    private static Method shadersFramebufferBindFramebuffer;
    private static Field optionsOfRenderRegions;
    private static Field optionsOfCloudHeight;
    private static Field optionsOfAoLevel;
    private static Field vertexRenderPositions;

    public static boolean isOptifineLoaded() {
        if (!checkedForOptifine) {
            checkedForOptifine = true;
            try {
                Class.forName("net.optifine.Config");
                VRSettings.logger.info("Vivecraft: Optifine detected");
                optifineLoaded = true;
            }
            catch (ClassNotFoundException ignore) {
                VRSettings.logger.info("Vivecraft: Optifine not detected");
                optifineLoaded = false;
            }
            if (optifineLoaded) {
                OptifineHelper.init();
            }
        }
        return optifineLoaded;
    }

    public static boolean isShaderActive() {
        try {
            return (Boolean)optifineConfigIsShadersMethod.invoke(optifineConfig, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean bindShaderFramebuffer() {
        try {
            Object dfb = shadersDFB.get(shaders);
            if (dfb != null) {
                shadersFramebufferBindFramebuffer.invoke(dfb, new Object[0]);
                return true;
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void beginOutlineShader() {
        try {
            shadersRenderBeginOutlineMethod.invoke(shadersRender, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void endOutlineShader() {
        try {
            shadersRenderEndOutlineMethod.invoke(shadersRender, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void beginEntities() {
        try {
            shadersBeginEntitiesMethod.invoke(shaders, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void endEntities() {
        try {
            shadersEndEntitiesMethod.invoke(shaders, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static boolean isSunMoonEnabled() {
        try {
            return (Boolean)optifineConfigIsSunMoonEnabledMethod.invoke(optifineConfig, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isSkyEnabled() {
        try {
            return (Boolean)optifineConfigIsSkyEnabledMethod.invoke(optifineConfig, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isStarsEnabled() {
        try {
            return (Boolean)optifineConfigIsStarsEnabledMethod.invoke(optifineConfig, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isCustomColors() {
        try {
            return (Boolean)optifineConfigIsCustomColorsMethod.invoke(optifineConfig, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isRenderRegions() {
        try {
            return (Boolean)optifineConfigIsRenderRegionsMethod.invoke(optifineConfig, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isAntialiasing() {
        try {
            return (Boolean)optifineConfigIsAntialiasingMethod.invoke(optifineConfig, new Object[0]) != false || (Boolean)optifineConfigIsAntialiasingConfiguredMethod.invoke(optifineConfig, new Object[0]) != false;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void setRenderRegions(boolean active) {
        try {
            optionsOfRenderRegions.set(class_310.method_1551().field_1690, active);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static class_243 getCustomSkyColor(class_243 skyColor, class_1920 blockAccess, double x, double y, double z) {
        try {
            return (class_243)customColorsGetSkyColorMethod.invoke(customColors, skyColor, blockAccess, x, y, z);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return skyColor;
        }
    }

    public static class_243 getCustomSkyColorEnd(class_243 skyColor) {
        try {
            return (class_243)customColorsGetSkyColoEndMethod.invoke(customColors, skyColor);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return skyColor;
        }
    }

    public static class_243 getCustomUnderwaterColor(class_1920 blockAccess, double x, double y, double z) {
        try {
            return (class_243)customColorsGetUnderwaterColorMethod.invoke(customColors, blockAccess, x, y, z);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class_243 getCustomUnderlavaColor(class_1920 blockAccess, double x, double y, double z) {
        try {
            return (class_243)customColorsGetUnderlavaColorMethod.invoke(customColors, blockAccess, x, y, z);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class_243 getCustomFogColor(class_243 fogColor, class_1920 blockAccess, double x, double y, double z) {
        try {
            return (class_243)customColorsGetFogColorMethod.invoke(customColors, fogColor, blockAccess, x, y, z);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return fogColor;
        }
    }

    public static class_243 getCustomFogColorEnd(class_243 fogColor) {
        try {
            return (class_243)customColorsGetFogColorEndMethod.invoke(customColors, fogColor);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return fogColor;
        }
    }

    public static class_243 getCustomFogColorNether(class_243 fogColor) {
        try {
            return (class_243)customColorsGetFogColorNetherMethod.invoke(customColors, fogColor);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return fogColor;
        }
    }

    public static double getCloudHeight() {
        try {
            return (Double)optionsOfCloudHeight.get(class_310.method_1551().field_1690);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public static double getAoLevel() {
        try {
            return (Double)optionsOfAoLevel.get(class_310.method_1551().field_1690);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return 1.0;
        }
    }

    public static void markTextureAsActive(class_1058 sprite) {
        try {
            smartAnimationsSpriteRenderedMethod.invoke(smartAnimations, sprite);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void copyRenderPositions(class_630.class_618 source, class_630.class_618 dest) {
        if (vertexRenderPositions != null) {
            try {
                vertexRenderPositions.set(dest, vertexRenderPositions.get(source));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private static void init() {
        try {
            optifineConfig = Class.forName("net.optifine.Config");
            optifineConfigIsShadersMethod = optifineConfig.getMethod("isShaders", new Class[0]);
            optifineConfigIsRenderRegionsMethod = optifineConfig.getMethod("isRenderRegions", new Class[0]);
            optifineConfigIsSkyEnabledMethod = optifineConfig.getMethod("isSkyEnabled", new Class[0]);
            optifineConfigIsSunMoonEnabledMethod = optifineConfig.getMethod("isSunMoonEnabled", new Class[0]);
            optifineConfigIsStarsEnabledMethod = optifineConfig.getMethod("isStarsEnabled", new Class[0]);
            optifineConfigIsCustomColorsMethod = optifineConfig.getMethod("isCustomColors", new Class[0]);
            optifineConfigIsAntialiasingMethod = optifineConfig.getMethod("isAntialiasing", new Class[0]);
            optifineConfigIsAntialiasingConfiguredMethod = optifineConfig.getMethod("isAntialiasingConfigured", new Class[0]);
            smartAnimations = Class.forName("net.optifine.SmartAnimations");
            smartAnimationsSpriteRenderedMethod = smartAnimations.getMethod("spriteRendered", class_1058.class);
            optionsOfRenderRegions = class_315.class.getField("ofRenderRegions");
            optionsOfCloudHeight = class_315.class.getField("ofCloudsHeight");
            optionsOfAoLevel = class_315.class.getField("ofAoLevel");
            customColors = Class.forName("net.optifine.CustomColors");
            customColorsGetSkyColorMethod = customColors.getMethod("getSkyColor", class_243.class, class_1920.class, Double.TYPE, Double.TYPE, Double.TYPE);
            customColorsGetUnderwaterColorMethod = customColors.getMethod("getUnderwaterColor", class_1920.class, Double.TYPE, Double.TYPE, Double.TYPE);
            customColorsGetUnderlavaColorMethod = customColors.getMethod("getUnderlavaColor", class_1920.class, Double.TYPE, Double.TYPE, Double.TYPE);
            shadersRender = Class.forName("net.optifine.shaders.ShadersRender");
            shadersRenderBeginOutlineMethod = shadersRender.getMethod("beginOutline", new Class[0]);
            shadersRenderEndOutlineMethod = shadersRender.getMethod("endOutline", new Class[0]);
            shaders = Class.forName("net.optifine.shaders.Shaders");
            shadersBeginEntitiesMethod = shaders.getMethod("beginEntities", new Class[0]);
            shadersEndEntitiesMethod = shaders.getMethod("endEntities", new Class[0]);
            Class<?> shadersFramebuffer = Class.forName("net.optifine.shaders.ShadersFramebuffer");
            shadersFramebufferBindFramebuffer = shadersFramebuffer.getMethod("bindFramebuffer", new Class[0]);
            customColorsGetSkyColoEndMethod = customColors.getDeclaredMethod("getSkyColorEnd", class_243.class);
            customColorsGetSkyColoEndMethod.setAccessible(true);
            customColorsGetFogColorMethod = customColors.getDeclaredMethod("getFogColor", class_243.class, class_1920.class, Double.TYPE, Double.TYPE, Double.TYPE);
            customColorsGetFogColorMethod.setAccessible(true);
            customColorsGetFogColorEndMethod = customColors.getDeclaredMethod("getFogColorEnd", class_243.class);
            customColorsGetFogColorEndMethod.setAccessible(true);
            customColorsGetFogColorNetherMethod = customColors.getDeclaredMethod("getFogColorNether", class_243.class);
            customColorsGetFogColorNetherMethod.setAccessible(true);
            shadersDFB = shaders.getDeclaredField("dfb");
            shadersDFB.setAccessible(true);
            try {
                vertexRenderPositions = class_630.class_618.class.getField("renderPositions");
            }
            catch (NoSuchFieldException e) {
                vertexRenderPositions = null;
            }
        }
        catch (ClassNotFoundException e) {
            VRSettings.logger.error("Optifine detected, but couldn't load class: {}", (Object)e.getMessage());
            optifineLoaded = false;
        }
        catch (NoSuchMethodException e) {
            VRSettings.logger.error("Optifine detected, but couldn't load Method: {}", (Object)e.getMessage());
            optifineLoaded = false;
        }
        catch (NoSuchFieldException e) {
            VRSettings.logger.error("Optifine detected, but couldn't load Field: {}", (Object)e.getMessage());
        }
    }
}

