/*
 * Decompiled with CFR 0.152.
 */
package fr.hugman.dawn.debug;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fr.hugman.dawn.Dawn;
import fr.hugman.dawn.debug.BlockData;
import fr.hugman.dawn.debug.EnchantmentData;
import fr.hugman.dawn.debug.EntityTypeData;
import fr.hugman.dawn.debug.ItemData;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1887;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;

public class DataSerialization {
    public static final Gson RAW_GSON = new GsonBuilder().registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).excludeFieldsWithoutExposeAnnotation().create();
    public static final Gson PRETTY_GSON = new GsonBuilder().registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).setPrettyPrinting().excludeFieldsWithoutExposeAnnotation().create();

    public static <T> T loadFromFile(File f, Class<? extends T> clazz, Supplier<T> baseCase) {
        return DataSerialization.loadFromFile(PRETTY_GSON, f, clazz, baseCase);
    }

    public static <T> T loadFromFile(Gson gson, File f, Class<? extends T> clazz, Supplier<T> baseCase) {
        try {
            if (!f.exists()) {
                T t = baseCase.get();
                DataSerialization.saveToFile(gson, f, clazz, t);
                return t;
            }
            FileInputStream in = new FileInputStream(f);
            return (T)gson.fromJson((Reader)new InputStreamReader((InputStream)in, StandardCharsets.UTF_8), clazz);
        }
        catch (IOException e) {
            Dawn.LOGGER.error("Failed to load file", (Throwable)e);
            return null;
        }
    }

    public static <T> void saveToFile(File f, Class<? extends T> clazz, T obj) {
        DataSerialization.saveToFile(PRETTY_GSON, f, clazz, obj);
    }

    public static <T> void saveToFile(Gson gson, File f, Class<? extends T> clazz, T obj) {
        String json = gson.toJson(obj, clazz);
        try {
            f.createNewFile();
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(f));){
                writer.write(json);
            }
        }
        catch (IOException e) {
            Dawn.LOGGER.error("Failed to save file", (Throwable)e);
        }
    }

    public static <T> Function<Map.Entry<class_5321<T>, T>, ?> getMapperFromRegistry(class_2378<T> registry) {
        if (registry == class_7923.field_41175) {
            return entry -> new BlockData(((class_5321)entry.getKey()).method_29177(), (class_2248)entry.getValue());
        }
        if (registry == class_7923.field_41178) {
            return entry -> new ItemData(((class_5321)entry.getKey()).method_29177(), (class_1792)entry.getValue());
        }
        if (registry == class_7923.field_41176) {
            return entry -> new EnchantmentData(((class_5321)entry.getKey()).method_29177(), (class_1887)entry.getValue());
        }
        if (registry == class_7923.field_41177) {
            return entry -> new EntityTypeData(((class_5321)entry.getKey()).method_29177(), (class_1299)entry.getValue());
        }
        return e -> ((class_5321)e.getKey()).method_29177();
    }
}

