/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.itemfilters;

import dev.latvian.mods.itemfilters.ItemFilters;
import dev.latvian.mods.itemfilters.api.IItemFilter;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_7701;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class DisplayStacksCache {
    private static final int MAX_CACHE_SIZE = 1024;
    private static final Object2ObjectLinkedOpenHashMap<CacheKey, List<class_1799>> cache = new Object2ObjectLinkedOpenHashMap(1024);

    @NotNull
    public static List<class_1799> getCachedDisplayStacks(class_1799 filterStack) {
        CacheKey key = new CacheKey(filterStack);
        List<class_1799> result = (List<class_1799>)cache.getAndMoveToFirst((Object)key);
        if (result == null) {
            result = DisplayStacksCache.computeMatchingStacks(filterStack);
            cache.put((Object)key, result);
            if (cache.size() >= 1024) {
                cache.removeLast();
            }
        }
        return result;
    }

    private static List<class_1799> computeMatchingStacks(class_1799 filterStack) {
        IItemFilter f = (IItemFilter)filterStack.method_7909();
        ItemFilters.proxy.registryAccess().ifPresent(ra -> class_7706.method_47330((class_7699)class_7701.field_40183, (boolean)true, (class_7225.class_7874)ra));
        return class_7706.method_47344().method_45414().stream().filter(candidate -> f.filter(filterStack, (class_1799)candidate)).toList();
    }

    public static void clear() {
        cache.clear();
    }

    private static class CacheKey {
        private final int key;

        private CacheKey(class_1799 filterStack) {
            this.key = Objects.hash(class_7923.field_41178.method_10206((Object)filterStack.method_7909()), filterStack.method_7985() ? filterStack.method_7969().hashCode() : 0);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.key == cacheKey.key;
        }

        public int hashCode() {
            return Integer.hashCode(this.key);
        }
    }
}

