/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.client.gui.stats.panel;

import com.mojang.authlib.GameProfile;
import io.github.thecsdev.betterstats.BetterStats;
import io.github.thecsdev.betterstats.api.client.gui.panel.BSComponentPanel;
import io.github.thecsdev.betterstats.api.client.gui.stats.panel.PBSummaryPanel;
import io.github.thecsdev.betterstats.api.client.util.io.LocalPlayerStatsProvider;
import io.github.thecsdev.betterstats.api.util.io.IEditableStatsProvider;
import io.github.thecsdev.betterstats.api.util.io.IStatsProvider;
import io.github.thecsdev.tcdcommons.TCDCommons;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TEntityRendererElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TLabelElement;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import java.util.Objects;
import net.minecraft.class_1299;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public final class GameProfilePanel
extends BSComponentPanel {
    public static final int HEIGHT = 128;
    public static final class_2561 TEXT_UUID = TextUtils.translatable((String)"betterstats.api.client.gui.stats.panel.gameprofilepanel.uuid", (Object[])new Object[0]);
    private final IStatsProvider statsProvider;

    public GameProfilePanel(int x, int y, int width, IStatsProvider statsProvider) throws NullPointerException {
        super(x, y, width, 128);
        this.setScrollFlags(4);
        this.setScrollPadding(7);
        this.setOutlineColor(0);
        this.statsProvider = Objects.requireNonNull(statsProvider);
    }

    protected final void init() {
        int col = -256;
        int sp = this.getScrollPadding();
        int erWidth = (this.getWidth() - sp * 2) / 4;
        int erHeight = this.getHeight() - sp * 2;
        int inWidth = this.getWidth() - sp * 2 - (erWidth + 5);
        boolean a = this.statsProvider instanceof IEditableStatsProvider;
        LocalPlayerStatsProvider localStatsProvider = LocalPlayerStatsProvider.getInstance();
        TEntityRendererElement er = new TEntityRendererElement(sp, sp, erWidth, erHeight, class_1299.field_6097);
        if (localStatsProvider != null && !Objects.equals(this.statsProvider.getGameProfile(), localStatsProvider.getGameProfile())) {
            er.setEntity(class_1299.field_6131);
        }
        er.setEntityScale(a ? 1.3 : 1.2);
        er.setFollowsCursor(BetterStats.getInstance().getConfig().guiMobsFollowCursor);
        this.addChild((TElement)er, true);
        GameProfile profile = this.statsProvider.getGameProfile();
        class_5250 txt_name = profile != null ? TextUtils.literal((String)Objects.toString(profile.getName())) : TextUtils.literal((String)"-");
        class_5250 txt_uuid = profile != null ? TextUtils.literal((String)Objects.toString(profile.getId())) : TextUtils.literal((String)"-");
        TLabelElement lbl_nameKey = new TLabelElement(this.getEndX() - (sp + inWidth), this.getY() + sp, inWidth, 10);
        lbl_nameKey.setText((class_2561)TextUtils.translatable((String)"entity.minecraft.player", (Object[])new Object[0]));
        lbl_nameKey.setTextColor(-256);
        this.addChild((TElement)lbl_nameKey, false);
        TLabelElement lbl_nameVal = new TLabelElement(lbl_nameKey.getX(), lbl_nameKey.getEndY(), lbl_nameKey.getWidth(), lbl_nameKey.getHeight());
        lbl_nameVal.setText((class_2561)txt_name);
        this.addChild((TElement)lbl_nameVal, false);
        TLabelElement lbl_uuidKey = new TLabelElement(lbl_nameVal.getX(), lbl_nameVal.getEndY() + 10, lbl_nameVal.getWidth(), lbl_nameVal.getHeight());
        lbl_uuidKey.setText(TEXT_UUID);
        lbl_uuidKey.setTextColor(-256);
        this.addChild((TElement)lbl_uuidKey, false);
        TLabelElement lbl_uuidVal = new TLabelElement(lbl_uuidKey.getX(), lbl_uuidKey.getEndY(), lbl_uuidKey.getWidth(), lbl_uuidKey.getHeight());
        lbl_uuidVal.setText((class_2561)txt_uuid);
        this.addChild((TElement)lbl_uuidVal, false);
        if (TCDCommons.getInstance().getConfig().enablePlayerBadges) {
            TLabelElement lbl_pbKey = new TLabelElement(lbl_uuidVal.getX(), lbl_uuidVal.getEndY() + 10, lbl_uuidVal.getWidth(), lbl_uuidVal.getHeight());
            lbl_pbKey.setText((class_2561)TextUtils.translatable((String)"tcdcommons.api.badge.playerbadge.plural", (Object[])new Object[0]));
            lbl_pbKey.setTextColor(-256);
            this.addChild((TElement)lbl_pbKey, false);
            PBSummaryPanel pnl_pbs = new PBSummaryPanel(lbl_uuidVal.getX(), lbl_pbKey.getEndY() + 4, lbl_uuidVal.getWidth(), 40, this.statsProvider);
            pnl_pbs.setScrollPadding(0);
            pnl_pbs.setBackgroundColor(0);
            pnl_pbs.setOutlineColor(0);
            this.addChild((TElement)pnl_pbs, false);
        }
    }
}

